/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupData;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupMeta;
import org.pentaho.di.trans.steps.databaselookup.readallcache.ReadAllCache;

public class ReadAllCacheTest {
    private DatabaseLookupData stepData;
    private RowMeta keysMeta;
    private Object[][] keys;
    private Object[][] data;

    @Before
    public void setUp() {
        this.stepData = new DatabaseLookupData();
        this.stepData.conditions = new int[4];
        this.keysMeta = new RowMeta();
        this.keysMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger());
        this.keysMeta.addValueMeta((ValueMetaInterface)new ValueMetaString());
        this.keysMeta.addValueMeta((ValueMetaInterface)new ValueMetaDate());
        this.keysMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger());
        this.keys = new Object[][]{{0L, "0", new Date(0L), null}, {0L, "0", new Date(50L), null}, {2L, "2", new Date(200L), null}, {1L, "1", new Date(100L), null}, {1L, "1", new Date(150L), null}};
        this.data = new Object[][]{{0}, {1}, {2}, {3}, {4}};
    }

    @After
    public void tearDown() {
        this.stepData = null;
        this.keysMeta = null;
        this.keys = null;
        this.data = null;
    }

    @Test(expected=UnsupportedOperationException.class)
    public void storeRowInCache_ThrowsException() throws Exception {
        this.buildCache("").storeRowInCache(new DatabaseLookupMeta(), (RowMetaInterface)this.keysMeta.clone(), this.keys[0], this.data[0]);
    }

    @Test
    public void hasDbConditionStopsSearching() throws Exception {
        this.stepData.hasDBCondition = true;
        Assert.assertNull((Object)this.buildCache("").getRowFromCache((RowMetaInterface)this.keysMeta.clone(), this.keys[0]));
    }

    @Test
    public void lookup_Finds_Only() throws Exception {
        ReadAllCache cache = this.buildCache("=,<,=,IS NULL");
        Object[] found = cache.getRowFromCache((RowMetaInterface)this.keysMeta.clone(), new Object[]{1L, "2", new Date(100L), null});
        Assert.assertArrayEquals((String)"(keys[0] == 1) && (keys[1] < '2') && (keys[2] == 100) --> row 3", (Object[])this.data[3], (Object[])found);
    }

    @Test
    public void lookup_Finds_FirstMatching() throws Exception {
        ReadAllCache cache = this.buildCache("=,IS NOT NULL,<=,IS NULL");
        Object[] found = cache.getRowFromCache((RowMetaInterface)this.keysMeta.clone(), new Object[]{1L, null, new Date(1000000L), null});
        Assert.assertArrayEquals((String)"(keys[0] == 1) && (keys[2] < 1000000) --> row 3", (Object[])this.data[3], (Object[])found);
    }

    @Test
    public void lookup_Finds_WithBetweenOperator() throws Exception {
        RowMeta meta = this.keysMeta.clone();
        meta.setValueMeta(3, (ValueMetaInterface)new ValueMetaDate());
        meta.addValueMeta((ValueMetaInterface)new ValueMetaInteger());
        ReadAllCache cache = this.buildCache("<>,IS NOT NULL,BETWEEN,IS NULL");
        Object[] found = cache.getRowFromCache((RowMetaInterface)meta, new Object[]{-1L, null, new Date(140L), new Date(160L), null});
        Assert.assertArrayEquals((String)"(140 <= keys[2] <= 160) --> row 4", (Object[])this.data[4], (Object[])found);
    }

    @Test
    public void lookup_Finds_WithTwoBetweenOperators() throws Exception {
        RowMeta meta = new RowMeta();
        meta.addValueMeta((ValueMetaInterface)new ValueMetaInteger());
        meta.addValueMeta((ValueMetaInterface)new ValueMetaString());
        meta.addValueMeta((ValueMetaInterface)new ValueMetaString());
        meta.addValueMeta((ValueMetaInterface)new ValueMetaDate());
        meta.addValueMeta((ValueMetaInterface)new ValueMetaDate());
        meta.addValueMeta((ValueMetaInterface)new ValueMetaInteger());
        ReadAllCache cache = this.buildCache(">,BETWEEN,BETWEEN,IS NULL");
        Object[] found = cache.getRowFromCache((RowMetaInterface)meta, new Object[]{-1L, "1", "3", new Date(0L), new Date(1000L), null});
        Assert.assertArrayEquals((String)"('1' <= keys[1] <= '3') && (0 <= keys[2] <= 1000) --> row 2", (Object[])this.data[2], (Object[])found);
    }

    @Test
    public void lookup_DoesNotFind_FilteredByIndex() throws Exception {
        ReadAllCache cache = this.buildCache("=,IS NOT NULL,>=,IS NOT NULL");
        Object[] found = cache.getRowFromCache((RowMetaInterface)this.keysMeta.clone(), new Object[]{1L, null, new Date(0L), null});
        Assert.assertNull((String)"(keys[3] != NULL) --> none", (Object)found);
    }

    @Test
    public void lookup_DoesNotFind_WithBetweenOperator() throws Exception {
        RowMeta meta = this.keysMeta.clone();
        meta.setValueMeta(3, (ValueMetaInterface)new ValueMetaDate());
        meta.addValueMeta((ValueMetaInterface)new ValueMetaInteger());
        ReadAllCache cache = this.buildCache("<>,IS NOT NULL,BETWEEN,IS NULL");
        Object[] found = cache.getRowFromCache((RowMetaInterface)meta, new Object[]{-1L, null, new Date(1000L), new Date(2000L), null});
        Assert.assertNull((String)"(1000 <= keys[2] <= 2000) --> none", (Object)found);
    }

    private ReadAllCache buildCache(String conditions) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(conditions, ",");
        List<String> operators = Arrays.asList(DatabaseLookupMeta.conditionStrings);
        int conditionIndex = 0;
        while (tokenizer.hasMoreElements()) {
            String operator = tokenizer.nextToken();
            int index = operators.indexOf(operator);
            if (index == -1) {
                throw new RuntimeException(conditions + " -- " + operator);
            }
            this.stepData.conditions[conditionIndex] = index;
            ++conditionIndex;
        }
        ReadAllCache.Builder builder = new ReadAllCache.Builder(this.stepData, this.keys.length);
        builder.setKeysMeta((RowMetaInterface)this.keysMeta);
        for (int i = 0; i < this.keys.length; ++i) {
            Object[] keyTuple = this.keys[i];
            Object[] dataTuple = this.data[i];
            builder.add(keyTuple, dataTuple);
        }
        return builder.build();
    }

    @Test
    public void lookup_HandlesAbsenceOfLookupValue() throws Exception {
        this.stepData = new DatabaseLookupData();
        this.stepData.conditions = new int[]{9};
        ReadAllCache.Builder builder = new ReadAllCache.Builder(this.stepData, 2);
        RowMeta keysMeta = new RowMeta();
        keysMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger());
        builder.setKeysMeta((RowMetaInterface)keysMeta);
        builder.add(new Object[]{null}, new Object[]{"null"});
        builder.add(new Object[]{1L}, new Object[]{"one"});
        ReadAllCache cache = builder.build();
        Object[] found = cache.getRowFromCache((RowMetaInterface)new RowMeta(), new Object[0]);
        Assert.assertArrayEquals((String)"(keys[1] == 1L) --> row 2", (Object[])new Object[]{"one"}, (Object[])found);
    }
}

