/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.BitSet;
import java.util.List;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.readallcache.EqIndex;
import org.pentaho.di.trans.steps.databaselookup.readallcache.IndexTestBase;

@RunWith(value=Parameterized.class)
public class NeIndexTest
extends IndexTestBase<EqIndex> {
    @Parameterized.Parameters
    public static List<Object[]> createSampleData() {
        return IndexTestBase.createSampleData();
    }

    public NeIndexTest(Long[][] rows) {
        super(EqIndex.class, rows);
    }

    @Override
    void doAssertMatches(BitSet candidates, long lookupValue, long actualValue) {
        if (lookupValue == actualValue) {
            Assert.fail((String)String.format("Expected not to find [%d] among %s, but got [%d]", lookupValue, candidates, actualValue));
        }
    }

    @Override
    EqIndex createIndexInstance(int column, ValueMetaInterface meta, int rowsAmount) throws Exception {
        return (EqIndex)EqIndex.nonEqualityIndex((int)column, (ValueMetaInterface)meta, (int)rowsAmount);
    }

    @Override
    public void lookupFor_MinusOne() {
        this.testFindsCorrectly(-1L, 5);
    }

    @Override
    public void lookupFor_Zero() {
        this.testFindsCorrectly(0L, 4);
    }

    @Override
    public void lookupFor_One() {
        this.testFindsCorrectly(1L, 4);
    }

    @Override
    public void lookupFor_Two() {
        this.testFindsCorrectly(2L, 3);
    }

    @Override
    public void lookupFor_Three() {
        this.testFindsCorrectly(3L, 4);
    }

    @Override
    public void lookupFor_Hundred() {
        this.testFindsCorrectly(100L, 5);
    }
}

