/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.BitSet;
import java.util.List;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.pentaho.di.trans.steps.databaselookup.readallcache.IndexTestBase;
import org.pentaho.di.trans.steps.databaselookup.readallcache.LtIndex;

@RunWith(value=Parameterized.class)
public class LtIndexTest
extends IndexTestBase<LtIndex> {
    @Parameterized.Parameters
    public static List<Object[]> createSampleData() {
        return IndexTestBase.createSampleData();
    }

    public LtIndexTest(Long[][] rows) {
        super(LtIndex.class, rows);
    }

    @Override
    void doAssertMatches(BitSet candidates, long lookupValue, long actualValue) {
        if (actualValue >= lookupValue) {
            Assert.fail((String)String.format("All found values are expected to be less than [%d], but got [%d] among %s", lookupValue, actualValue, candidates));
        }
    }

    @Override
    public void lookupFor_MinusOne() {
        this.testFindsNothing(-1L);
    }

    @Override
    public void lookupFor_Zero() {
        this.testFindsNothing(0L);
    }

    @Override
    public void lookupFor_One() {
        this.testFindsCorrectly(1L, 1);
    }

    @Override
    public void lookupFor_Two() {
        this.testFindsCorrectly(2L, 2);
    }

    @Override
    public void lookupFor_Three() {
        this.testFindsCorrectly(3L, 4);
    }

    @Override
    public void lookupFor_Hundred() {
        this.testFindsCorrectly(100L, 5);
    }
}

