/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.BitSet;
import java.util.List;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.pentaho.di.trans.steps.databaselookup.readallcache.GtIndex;
import org.pentaho.di.trans.steps.databaselookup.readallcache.IndexTestBase;

@RunWith(value=Parameterized.class)
public class GtIndexTest
extends IndexTestBase<GtIndex> {
    @Parameterized.Parameters
    public static List<Object[]> createSampleData() {
        return IndexTestBase.createSampleData();
    }

    public GtIndexTest(Long[][] rows) {
        super(GtIndex.class, rows);
    }

    @Override
    void doAssertMatches(BitSet candidates, long lookupValue, long actualValue) {
        if (actualValue <= lookupValue) {
            Assert.fail((String)String.format("All found values are expected to be greater than [%d], but got [%d] among %s", lookupValue, actualValue, candidates));
        }
    }

    @Override
    public void lookupFor_MinusOne() {
        this.testFindsCorrectly(-1L, 5);
    }

    @Override
    public void lookupFor_Zero() {
        this.testFindsCorrectly(0L, 4);
    }

    @Override
    public void lookupFor_One() {
        this.testFindsCorrectly(1L, 3);
    }

    @Override
    public void lookupFor_Two() {
        this.testFindsCorrectly(1L, 1);
    }

    @Override
    public void lookupFor_Three() {
        this.testFindsNothing(3L);
    }

    @Override
    public void lookupFor_Hundred() {
        this.testFindsNothing(100L);
    }
}

