/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.BitSet;
import java.util.List;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.pentaho.di.trans.steps.databaselookup.readallcache.EqIndex;
import org.pentaho.di.trans.steps.databaselookup.readallcache.IndexTestBase;

@RunWith(value=Parameterized.class)
public class EqIndexTest
extends IndexTestBase<EqIndex> {
    @Parameterized.Parameters
    public static List<Object[]> createSampleData() {
        return IndexTestBase.createSampleData();
    }

    public EqIndexTest(Long[][] rows) {
        super(EqIndex.class, rows);
    }

    @Override
    void doAssertMatches(BitSet candidates, long lookupValue, long actualValue) {
        if (lookupValue != actualValue) {
            Assert.fail((String)String.format("Expected to find [%d] among %s, but got [%d]", lookupValue, candidates, actualValue));
        }
    }

    @Override
    public void lookupFor_MinusOne() {
        this.testFindsNothing(-1L);
    }

    @Override
    public void lookupFor_Zero() {
        this.testFindsCorrectly(0L, 1);
    }

    @Override
    public void lookupFor_One() {
        this.testFindsCorrectly(1L, 1);
    }

    @Override
    public void lookupFor_Two() {
        this.testFindsCorrectly(2L, 2);
    }

    @Override
    public void lookupFor_Three() {
        this.testFindsCorrectly(3L, 1);
    }

    @Override
    public void lookupFor_Hundred() {
        this.testFindsNothing(100L);
    }
}

