/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.MySQLDatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookup;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupData;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupMeta;
import org.pentaho.di.trans.steps.databaselookup.DefaultCache;
import org.pentaho.di.trans.steps.databaselookup.readallcache.ReadAllCache;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.metastore.api.IMetaStore;

public class DatabaseLookupUTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private static final String BINARY_FIELD = "aBinaryFieldInDb";
    private static final String ID_FIELD = "id";
    private StepMockHelper<DatabaseLookupMeta, DatabaseLookupData> mockHelper;

    @BeforeClass
    public static void setUpClass() throws Exception {
        KettleEnvironment.init();
    }

    @AfterClass
    public static void tearDown() {
        KettleEnvironment.reset();
    }

    @Before
    public void setUp() {
        this.mockHelper = this.createMockHelper();
    }

    @After
    public void cleanUp() {
        this.mockHelper.cleanUp();
    }

    @Test
    public void mySqlVariantDbIsLazyConverted() throws Exception {
        DatabaseLookupMeta meta = this.createDatabaseMeta();
        DatabaseLookupData data = this.createDatabaseData();
        Database db = this.createVirtualDb(meta.getDatabaseMeta());
        DatabaseLookup lookup = this.spyLookup(this.mockHelper, db, meta.getDatabaseMeta());
        lookup.init((StepMetaInterface)meta, (StepDataInterface)data);
        lookup.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        ((Database)Mockito.verify((Object)db)).getLookup((PreparedStatement)Matchers.any(PreparedStatement.class), Matchers.anyBoolean(), Matchers.eq((boolean)false));
    }

    private StepMockHelper<DatabaseLookupMeta, DatabaseLookupData> createMockHelper() {
        StepMockHelper<DatabaseLookupMeta, DatabaseLookupData> mockHelper = new StepMockHelper<DatabaseLookupMeta, DatabaseLookupData>("test DatabaseLookup", DatabaseLookupMeta.class, DatabaseLookupData.class);
        Mockito.when((Object)mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)mockHelper.logChannelInterface);
        Mockito.when((Object)mockHelper.trans.isRunning()).thenReturn((Object)true);
        RowMeta inputRowMeta = new RowMeta();
        RowSet rowSet = (RowSet)Mockito.mock(RowSet.class);
        Mockito.when((Object)rowSet.getRowWait(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)))).thenReturn((Object)new Object[0]).thenReturn(null);
        Mockito.when((Object)rowSet.getRowMeta()).thenReturn((Object)inputRowMeta);
        Mockito.when((Object)mockHelper.trans.findRowSet(Matchers.anyString(), Matchers.anyInt(), Matchers.anyString(), Matchers.anyInt())).thenReturn((Object)rowSet);
        Mockito.when((Object)mockHelper.transMeta.findNextSteps((StepMeta)Matchers.any(StepMeta.class))).thenReturn(Collections.singletonList(Mockito.mock(StepMeta.class)));
        Mockito.when((Object)mockHelper.transMeta.findPreviousSteps((StepMeta)Matchers.any(StepMeta.class), Matchers.anyBoolean())).thenReturn(Collections.singletonList(Mockito.mock(StepMeta.class)));
        return mockHelper;
    }

    private DatabaseLookupMeta createDatabaseMeta() throws KettleException {
        MySQLDatabaseMeta mysql = new MySQLDatabaseMeta();
        mysql.setName("MySQL");
        DatabaseMeta dbMeta = new DatabaseMeta();
        dbMeta.setDatabaseInterface((DatabaseInterface)mysql);
        DatabaseLookupMeta meta = new DatabaseLookupMeta();
        meta.setDatabaseMeta(dbMeta);
        meta.setTablename("VirtualTable");
        meta.setTableKeyField(new String[]{ID_FIELD});
        meta.setKeyCondition(new String[]{"="});
        meta.setReturnValueNewName(new String[]{"returned value"});
        meta.setReturnValueField(new String[]{BINARY_FIELD});
        meta.setReturnValueDefaultType(new int[]{8});
        meta.setStreamKeyField1(new String[0]);
        meta.setStreamKeyField2(new String[0]);
        meta.setReturnValueDefault(new String[]{""});
        meta = (DatabaseLookupMeta)Mockito.spy((Object)meta);
        ((DatabaseLookupMeta)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                RowMetaInterface row = (RowMetaInterface)invocation.getArguments()[0];
                ValueMetaBinary v = new ValueMetaBinary(DatabaseLookupUTest.BINARY_FIELD);
                row.addValueMeta((ValueMetaInterface)v);
                return null;
            }
        }).when((Object)meta)).getFields((RowMetaInterface)Matchers.any(RowMetaInterface.class), Matchers.anyString(), (RowMetaInterface[])Matchers.any(RowMetaInterface[].class), (StepMeta)Matchers.any(StepMeta.class), (VariableSpace)Matchers.any(VariableSpace.class), (Repository)Matchers.any(Repository.class), (IMetaStore)Matchers.any(IMetaStore.class));
        return meta;
    }

    private DatabaseLookupData createDatabaseData() {
        return new DatabaseLookupData();
    }

    private Database createVirtualDb(DatabaseMeta meta) throws Exception {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getMetaData()).thenReturn(Mockito.mock(ResultSetMetaData.class));
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)ps.executeQuery()).thenReturn((Object)rs);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.prepareStatement(Matchers.anyString())).thenReturn((Object)ps);
        Database db = new Database((LoggingObjectInterface)Mockito.mock(LoggingObjectInterface.class), meta);
        db.setConnection(connection);
        db = (Database)Mockito.spy((Object)db);
        ((Database)Mockito.doNothing().when((Object)db)).normalConnect(Matchers.anyString());
        ValueMetaString binary = new ValueMetaString(BINARY_FIELD);
        binary.setStorageType(1);
        ValueMetaInteger id = new ValueMetaInteger(ID_FIELD);
        RowMeta metaByQuerying = new RowMeta();
        metaByQuerying.addValueMeta((ValueMetaInterface)binary);
        metaByQuerying.addValueMeta((ValueMetaInterface)id);
        ((Database)Mockito.doReturn((Object)metaByQuerying).when((Object)db)).getTableFields(Matchers.anyString());
        ((Database)Mockito.doReturn((Object)metaByQuerying).when((Object)db)).getTableFieldsMeta(Matchers.anyString(), Matchers.anyString());
        return db;
    }

    private DatabaseLookup spyLookup(StepMockHelper<DatabaseLookupMeta, DatabaseLookupData> mocks, Database db, DatabaseMeta dbMeta) {
        DatabaseLookup lookup = new DatabaseLookup(mocks.stepMeta, mocks.stepDataInterface, 1, mocks.transMeta, mocks.trans);
        lookup = (DatabaseLookup)Mockito.spy((Object)lookup);
        ((DatabaseLookup)Mockito.doReturn((Object)db).when((Object)lookup)).getDatabase((DatabaseMeta)Matchers.eq((Object)dbMeta));
        for (RowSet rowSet : lookup.getOutputRowSets()) {
            if (!Mockito.mockingDetails((Object)rowSet).isMock()) continue;
            Mockito.when((Object)rowSet.putRow((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class))).thenReturn((Object)true);
        }
        return lookup;
    }

    @Test
    public void testEqualsAndIsNullAreCached() throws Exception {
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        MockDatabaseLookup look = new MockDatabaseLookup(this.mockHelper.stepMeta, (StepDataInterface)this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        DatabaseLookupData lookData = new DatabaseLookupData();
        lookData.cache = DefaultCache.newCache((DatabaseLookupData)lookData, (int)0);
        lookData.lookupMeta = new RowMeta();
        MySQLDatabaseMeta mysql = new MySQLDatabaseMeta();
        mysql.setName("MySQL");
        DatabaseMeta dbMeta = new DatabaseMeta();
        dbMeta.setDatabaseInterface((DatabaseInterface)mysql);
        DatabaseLookupMeta meta = new DatabaseLookupMeta();
        meta.setDatabaseMeta(dbMeta);
        meta.setTablename("VirtualTable");
        meta.setTableKeyField(new String[]{"ID1", "ID2"});
        meta.setKeyCondition(new String[]{"=", "IS NULL"});
        meta.setReturnValueNewName(new String[]{"val1", "val2"});
        meta.setReturnValueField(new String[]{BINARY_FIELD, BINARY_FIELD});
        meta.setReturnValueDefaultType(new int[]{8, 8});
        meta.setStreamKeyField1(new String[0]);
        meta.setStreamKeyField2(new String[0]);
        meta.setReturnValueDefault(new String[]{"", ""});
        meta = (DatabaseLookupMeta)Mockito.spy((Object)meta);
        ((DatabaseLookupMeta)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                RowMetaInterface row = (RowMetaInterface)invocation.getArguments()[0];
                ValueMetaBinary v = new ValueMetaBinary(DatabaseLookupUTest.BINARY_FIELD);
                row.addValueMeta((ValueMetaInterface)v);
                return null;
            }
        }).when((Object)meta)).getFields((RowMetaInterface)Matchers.any(RowMetaInterface.class), Matchers.anyString(), (RowMetaInterface[])Matchers.any(RowMetaInterface[].class), (StepMeta)Matchers.any(StepMeta.class), (VariableSpace)Matchers.any(VariableSpace.class), (Repository)Matchers.any(Repository.class), (IMetaStore)Matchers.any(IMetaStore.class));
        look.init((StepMetaInterface)meta, (StepDataInterface)lookData);
        Assert.assertTrue((boolean)lookData.allEquals);
    }

    @Test
    public void getRowInCacheTest() throws KettleException {
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        DatabaseLookup look = new DatabaseLookup(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        DatabaseLookupData lookData = new DatabaseLookupData();
        lookData.cache = DefaultCache.newCache((DatabaseLookupData)lookData, (int)0);
        lookData.lookupMeta = new RowMeta();
        look.init((StepMetaInterface)new DatabaseLookupMeta(), (StepDataInterface)lookData);
        ValueMetaInteger valueMeta = new ValueMetaInteger("fieldTest");
        RowMeta lookupMeta = new RowMeta();
        lookupMeta.setValueMetaList(Collections.singletonList(valueMeta));
        Object[] kgsRow1 = new Object[]{1L};
        Object[] kgsRow2 = new Object[]{2L};
        Object[] add1 = new Object[]{10L};
        Object[] add2 = new Object[]{20L};
        lookData.cache.storeRowInCache((DatabaseLookupMeta)this.mockHelper.processRowsStepMetaInterface, (RowMetaInterface)lookupMeta, kgsRow1, add1);
        lookData.cache.storeRowInCache((DatabaseLookupMeta)this.mockHelper.processRowsStepMetaInterface, (RowMetaInterface)lookupMeta, kgsRow2, add2);
        Object[] rowToCache = new Object[]{0L};
        lookData.conditions = new int[1];
        lookData.conditions[0] = 5;
        Object[] dataFromCache = lookData.cache.getRowFromCache((RowMetaInterface)lookupMeta, rowToCache);
        Assert.assertArrayEquals((Object[])dataFromCache, (Object[])add1);
    }

    @Test
    public void createsReadOnlyCache_WhenReadAll_AndNotAllEquals() throws Exception {
        DatabaseLookupData data = this.getCreatedData(false);
        Assert.assertThat((Object)data.cache, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ReadAllCache.class)));
    }

    @Test
    public void createsReadDefaultCache_WhenReadAll_AndAllEquals() throws Exception {
        DatabaseLookupData data = this.getCreatedData(true);
        Assert.assertThat((Object)data.cache, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(DefaultCache.class)));
    }

    private DatabaseLookupData getCreatedData(boolean allEquals) throws Exception {
        Database db = (Database)Mockito.mock(Database.class);
        Mockito.when((Object)db.getRows(Matchers.anyString(), Matchers.anyInt())).thenReturn(Collections.singletonList(new Object[]{1L}));
        RowMeta returnRowMeta = new RowMeta();
        returnRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger());
        Mockito.when((Object)db.getReturnRowMeta()).thenReturn((Object)returnRowMeta);
        DatabaseLookupMeta meta = this.createTestMeta();
        DatabaseLookupData data = new DatabaseLookupData();
        DatabaseLookup step = this.createSpiedStep(db, this.mockHelper, meta);
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        data.db = db;
        data.keytypes = new int[]{5};
        if (allEquals) {
            data.allEquals = true;
            data.conditions = new int[]{0};
        } else {
            data.allEquals = false;
            data.conditions = new int[]{2};
        }
        step.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        return data;
    }

    private DatabaseLookupMeta createTestMeta() {
        DatabaseLookupMeta meta = new DatabaseLookupMeta();
        meta.setCached(true);
        meta.setLoadingAllDataInCache(true);
        meta.setDatabaseMeta((DatabaseMeta)Mockito.mock(DatabaseMeta.class));
        meta.allocate(1, 0);
        meta.setStreamKeyField1(new String[]{"Test"});
        return meta;
    }

    private DatabaseLookup createSpiedStep(Database db, StepMockHelper<DatabaseLookupMeta, DatabaseLookupData> mockHelper, DatabaseLookupMeta meta) throws KettleException {
        DatabaseLookup step = this.spyLookup(mockHelper, db, meta.getDatabaseMeta());
        ((DatabaseLookup)Mockito.doNothing().when((Object)step)).determineFieldsTypesQueryingDb();
        ((DatabaseLookup)Mockito.doReturn(null).when((Object)step)).lookupValues((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class));
        RowMeta input = new RowMeta();
        input.addValueMeta((ValueMetaInterface)new ValueMetaInteger("Test"));
        step.setInputRowMeta((RowMetaInterface)input);
        return step;
    }

    @Test
    public void createsReadDefaultCache_AndUsesOnlyNeededFieldsFromMeta() throws Exception {
        Database db = (Database)Mockito.mock(Database.class);
        Mockito.when((Object)db.getRows(Matchers.anyString(), Matchers.anyInt())).thenReturn(Arrays.asList({1L}, {2L}));
        RowMeta returnRowMeta = new RowMeta();
        returnRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger());
        returnRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger());
        Mockito.when((Object)db.getReturnRowMeta()).thenReturn((Object)returnRowMeta);
        DatabaseLookupMeta meta = this.createTestMeta();
        DatabaseLookupData data = new DatabaseLookupData();
        DatabaseLookup step = this.createSpiedStep(db, this.mockHelper, meta);
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        data.db = db;
        data.keytypes = new int[]{5};
        data.allEquals = true;
        data.conditions = new int[]{0};
        step.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        data.lookupMeta = new RowMeta();
        data.lookupMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger());
        Assert.assertNotNull((Object)data.cache.getRowFromCache(data.lookupMeta, new Object[]{1L}));
        Assert.assertNotNull((Object)data.cache.getRowFromCache(data.lookupMeta, new Object[]{2L}));
    }

    public class MockDatabaseLookup
    extends DatabaseLookup {
        public MockDatabaseLookup(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        }

        Database getDatabase(DatabaseMeta meta) {
            try {
                return DatabaseLookupUTest.this.createVirtualDb(meta);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

