/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupData;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.DatabaseMetaLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.NonZeroIntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;

public class DatabaseLookupMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<DatabaseLookupMeta> testMetaClass = DatabaseLookupMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private DatabaseLookupMeta databaseLookupMeta = new DatabaseLookupMeta();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("schemaName", "tablename", "databaseMeta", "orderByClause", "cached", "cacheSize", "loadingAllDataInCache", "failingOnMultipleResults", "eatingRowOnLookupFailure", "streamKeyField1", "streamKeyField2", "keyCondition", "tableKeyField", "returnValueField", "returnValueNewName", "returnValueDefault", "returnValueDefaultType");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("streamKeyField1", stringArrayLoadSaveValidator);
        attrValidatorMap.put("streamKeyField2", stringArrayLoadSaveValidator);
        attrValidatorMap.put("keyCondition", stringArrayLoadSaveValidator);
        attrValidatorMap.put("tableKeyField", stringArrayLoadSaveValidator);
        attrValidatorMap.put("returnValueField", stringArrayLoadSaveValidator);
        attrValidatorMap.put("returnValueNewName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("returnValueDefault", stringArrayLoadSaveValidator);
        attrValidatorMap.put("returnValueDefaultType", new PrimitiveIntArrayLoadSaveValidator(new NonZeroIntLoadSaveValidator(7), 5));
        attrValidatorMap.put("databaseMeta", new DatabaseMetaLoadSaveValidator());
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), getterMap, setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof DatabaseLookupMeta) {
            ((DatabaseLookupMeta)someMeta).allocate(5, 5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void getFieldWithValueUsedTwice() throws KettleStepException {
        this.databaseLookupMeta.setReturnValueField(new String[]{"match", "match", "mismatch"});
        this.databaseLookupMeta.setReturnValueNewName(new String[]{"v1", "v2", "v3"});
        ValueMetaString v1 = new ValueMetaString("match");
        ValueMetaString v2 = new ValueMetaString("match1");
        RowMetaInterface[] info = new RowMetaInterface[]{new RowMeta()};
        info[0].setValueMetaList(Arrays.asList(v1, v2));
        ValueMetaString r1 = new ValueMetaString("value");
        RowMeta row = new RowMeta();
        row.setValueMetaList(new ArrayList<ValueMetaInterface>(Arrays.asList(r1)));
        this.databaseLookupMeta.getFields((RowMetaInterface)row, "", info, null, null, null, null);
        List<ValueMetaInterface> expectedRow = Arrays.asList(new ValueMetaString("value"), new ValueMetaString("v1"), new ValueMetaString("v2"));
        Assert.assertEquals((long)3L, (long)row.getValueMetaList().size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)expectedRow.get(i).getName(), (Object)((ValueMetaInterface)row.getValueMetaList().get(i)).getName());
        }
    }

    @Test
    public void testProvidesModelerMeta() throws Exception {
        DatabaseLookupMeta databaseLookupMeta = new DatabaseLookupMeta();
        databaseLookupMeta.setReturnValueField(new String[]{"f1", "f2", "f3"});
        databaseLookupMeta.setReturnValueNewName(new String[]{"s4", "s5", "s6"});
        DatabaseLookupData databaseLookupData = new DatabaseLookupData();
        databaseLookupData.returnMeta = (RowMetaInterface)Mockito.mock(RowMeta.class);
        Assert.assertEquals((Object)databaseLookupData.returnMeta, (Object)databaseLookupMeta.getRowMeta((StepDataInterface)databaseLookupData));
        Assert.assertEquals((long)3L, (long)databaseLookupMeta.getDatabaseFields().size());
        Assert.assertEquals((Object)"f1", databaseLookupMeta.getDatabaseFields().get(0));
        Assert.assertEquals((Object)"f2", databaseLookupMeta.getDatabaseFields().get(1));
        Assert.assertEquals((Object)"f3", databaseLookupMeta.getDatabaseFields().get(2));
        Assert.assertEquals((long)3L, (long)databaseLookupMeta.getStreamFields().size());
        Assert.assertEquals((Object)"s4", databaseLookupMeta.getStreamFields().get(0));
        Assert.assertEquals((Object)"s5", databaseLookupMeta.getStreamFields().get(1));
        Assert.assertEquals((Object)"s6", databaseLookupMeta.getStreamFields().get(2));
    }

    @Test
    public void cloneTest() throws Exception {
        DatabaseLookupMeta meta = new DatabaseLookupMeta();
        meta.allocate(2, 2);
        meta.setStreamKeyField1(new String[]{"aa", "bb"});
        meta.setTableKeyField(new String[]{"cc", "dd"});
        meta.setKeyCondition(new String[]{"ee", "ff"});
        meta.setStreamKeyField2(new String[]{"gg", "hh"});
        meta.setReturnValueField(new String[]{"ii", "jj"});
        meta.setReturnValueNewName(new String[]{"kk", "ll"});
        meta.setReturnValueDefault(new String[]{"mm", "nn"});
        meta.setReturnValueDefaultType(new int[]{10, 50});
        meta.setOrderByClause("FOO DESC");
        DatabaseLookupMeta aClone = (DatabaseLookupMeta)meta.clone();
        Assert.assertFalse((aClone == meta ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(meta.getStreamKeyField1(), aClone.getStreamKeyField1()));
        Assert.assertTrue((boolean)Arrays.equals(meta.getTableKeyField(), aClone.getTableKeyField()));
        Assert.assertTrue((boolean)Arrays.equals(meta.getKeyCondition(), aClone.getKeyCondition()));
        Assert.assertTrue((boolean)Arrays.equals(meta.getStreamKeyField2(), aClone.getStreamKeyField2()));
        Assert.assertTrue((boolean)Arrays.equals(meta.getReturnValueField(), aClone.getReturnValueField()));
        Assert.assertTrue((boolean)Arrays.equals(meta.getReturnValueNewName(), aClone.getReturnValueNewName()));
        Assert.assertTrue((boolean)Arrays.equals(meta.getReturnValueDefault(), aClone.getReturnValueDefault()));
        Assert.assertTrue((boolean)Arrays.equals(meta.getReturnValueDefaultType(), aClone.getReturnValueDefaultType()));
        Assert.assertEquals((Object)meta.getOrderByClause(), (Object)aClone.getOrderByClause());
        Assert.assertEquals((Object)meta.getXML(), (Object)aClone.getXML());
    }
}

