/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databasejoin;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.databasejoin.DatabaseJoin;
import org.pentaho.di.trans.steps.databasejoin.DatabaseJoinData;
import org.pentaho.di.trans.steps.databasejoin.DatabaseJoinMeta;
import org.powermock.api.mockito.PowerMockito;

public class DatabaseJoinTest {
    DatabaseJoinMeta mockStepMetaInterface;
    DatabaseJoinData mockStepDataInterface;
    DatabaseJoin mockDatabaseJoin;

    @Before
    public void setUp() {
        StepMeta mockStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        TransMeta mockTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        Trans mockTrans = (Trans)Mockito.mock(Trans.class);
        StepPartitioningMeta mockStepPartitioningMeta = (StepPartitioningMeta)Mockito.mock(StepPartitioningMeta.class);
        Mockito.when((Object)mockStepMeta.getName()).thenReturn((Object)"MockStep");
        Mockito.when((Object)mockTransMeta.findStep(Matchers.anyString())).thenReturn((Object)mockStepMeta);
        Mockito.when((Object)mockStepMeta.getTargetStepPartitioningMeta()).thenReturn((Object)mockStepPartitioningMeta);
        this.mockStepMetaInterface = (DatabaseJoinMeta)Mockito.mock(DatabaseJoinMeta.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{StepMetaInterface.class}));
        this.mockStepDataInterface = (DatabaseJoinData)Mockito.mock(DatabaseJoinData.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{StepMetaInterface.class}));
        this.mockStepDataInterface.db = (Database)Mockito.mock(Database.class);
        this.mockStepDataInterface.pstmt = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.mockDatabaseJoin = (DatabaseJoin)PowerMockito.spy((Object)new DatabaseJoin(mockStepMeta, (StepDataInterface)this.mockStepDataInterface, 1, mockTransMeta, mockTrans));
    }

    @Test
    public void testStopRunningWhenStepIsStopped() throws KettleException {
        ((DatabaseJoin)Mockito.doReturn((Object)true).when((Object)this.mockDatabaseJoin)).isStopped();
        this.mockDatabaseJoin.stopRunning((StepMetaInterface)this.mockStepMetaInterface, (StepDataInterface)this.mockStepDataInterface);
        ((DatabaseJoin)Mockito.verify((Object)this.mockDatabaseJoin, (VerificationMode)Mockito.times((int)1))).isStopped();
        ((DatabaseJoinData)Mockito.verify((Object)this.mockStepDataInterface, (VerificationMode)Mockito.times((int)0))).isDisposed();
    }

    @Test
    public void testStopRunningWhenStepDataInterfaceIsDisposed() throws KettleException {
        ((DatabaseJoin)Mockito.doReturn((Object)false).when((Object)this.mockDatabaseJoin)).isStopped();
        ((DatabaseJoinData)Mockito.doReturn((Object)true).when((Object)this.mockStepDataInterface)).isDisposed();
        this.mockDatabaseJoin.stopRunning((StepMetaInterface)this.mockStepMetaInterface, (StepDataInterface)this.mockStepDataInterface);
        ((DatabaseJoin)Mockito.verify((Object)this.mockDatabaseJoin, (VerificationMode)Mockito.times((int)1))).isStopped();
        ((DatabaseJoinData)Mockito.verify((Object)this.mockStepDataInterface, (VerificationMode)Mockito.times((int)1))).isDisposed();
    }

    @Test
    public void testStopRunningWhenStepIsNotStoppedNorStepDataInterfaceIsDisposedAndDatabaseConnectionIsValid() throws KettleException {
        ((DatabaseJoin)Mockito.doReturn((Object)false).when((Object)this.mockDatabaseJoin)).isStopped();
        ((DatabaseJoinData)Mockito.doReturn((Object)false).when((Object)this.mockStepDataInterface)).isDisposed();
        Mockito.when((Object)this.mockStepDataInterface.db.getConnection()).thenReturn(Mockito.mock(Connection.class));
        this.mockDatabaseJoin.stopRunning((StepMetaInterface)this.mockStepMetaInterface, (StepDataInterface)this.mockStepDataInterface);
        ((DatabaseJoin)Mockito.verify((Object)this.mockDatabaseJoin, (VerificationMode)Mockito.times((int)1))).isStopped();
        ((DatabaseJoinData)Mockito.verify((Object)this.mockStepDataInterface, (VerificationMode)Mockito.times((int)1))).isDisposed();
        ((Database)Mockito.verify((Object)this.mockStepDataInterface.db, (VerificationMode)Mockito.times((int)1))).getConnection();
        ((Database)Mockito.verify((Object)this.mockStepDataInterface.db, (VerificationMode)Mockito.times((int)1))).cancelStatement((Statement)Matchers.any(PreparedStatement.class));
        TestCase.assertTrue((boolean)this.mockStepDataInterface.isCanceled);
    }

    @Test
    public void testStopRunningWhenStepIsNotStoppedNorStepDataInterfaceIsDisposedAndDatabaseConnectionIsNotValid() throws KettleException {
        ((DatabaseJoin)Mockito.doReturn((Object)false).when((Object)this.mockDatabaseJoin)).isStopped();
        ((DatabaseJoinData)Mockito.doReturn((Object)false).when((Object)this.mockStepDataInterface)).isDisposed();
        Mockito.when((Object)this.mockStepDataInterface.db.getConnection()).thenReturn(null);
        this.mockDatabaseJoin.stopRunning((StepMetaInterface)this.mockStepMetaInterface, (StepDataInterface)this.mockStepDataInterface);
        ((DatabaseJoin)Mockito.verify((Object)this.mockDatabaseJoin, (VerificationMode)Mockito.times((int)1))).isStopped();
        ((DatabaseJoinData)Mockito.verify((Object)this.mockStepDataInterface, (VerificationMode)Mockito.times((int)1))).isDisposed();
        ((Database)Mockito.verify((Object)this.mockStepDataInterface.db, (VerificationMode)Mockito.times((int)1))).getConnection();
        ((Database)Mockito.verify((Object)this.mockStepDataInterface.db, (VerificationMode)Mockito.times((int)0))).cancelStatement((Statement)Matchers.any(PreparedStatement.class));
        TestCase.assertFalse((boolean)this.mockStepDataInterface.isCanceled);
    }
}

