/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.csvinput.CsvInput;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.csvinput.CsvInputUnitTestBase;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class PDI_15270_Test
extends CsvInputUnitTestBase {
    private CsvInput csvInput;
    private String[] expected;
    private String content;
    private StepMockHelper<CsvInputMeta, StepDataInterface> stepMockHelper;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUp() throws Exception {
        System.setProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "Y");
        this.stepMockHelper = StepMockUtil.getStepMockHelper(CsvInputMeta.class, "Pdi15270Test");
        this.csvInput = new CsvInput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
    }

    @After
    public void cleanUp() {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void noEnclosures() throws Exception {
        String field1 = "FIRST_NM";
        String field2 = "MIDDLE_NM";
        String field3 = "LAST_NM";
        this.content = field1 + "," + field2 + "," + field3;
        this.expected = new String[]{field1, field2, field3};
        this.doTest(this.content, this.expected);
    }

    @Test
    public void noEnclosuresWithEmptyFieldTest() throws Exception {
        String field1 = "Ima";
        String field2 = "";
        String field3 = "Rose";
        this.content = field1 + "," + field2 + "," + field3;
        this.expected = new String[]{field1, field2, field3};
        this.doTest(this.content, this.expected);
    }

    @Test
    public void withEnclosuresTest() throws Exception {
        String field1 = "Tom Tom";
        String field2 = "the";
        String field3 = "Piper's Son";
        this.content = "\"" + field1 + "\"" + "," + "\"" + field2 + "\"" + "," + "\"" + field3 + "\"";
        this.expected = new String[]{field1, field2, field3};
        this.doTest(this.content, this.expected);
    }

    @Test
    public void withEnclosuresOnOneFieldTest() throws Exception {
        String field1 = "Martin";
        String field2 = "Luther";
        String field3 = "King, Jr.";
        this.content = field1 + "," + field2 + "," + "\"" + field3 + "\"";
        this.expected = new String[]{field1, field2, field3};
        this.doTest(this.content, this.expected);
    }

    @Test
    public void withEnclosuresInMiddleOfFieldTest() throws Exception {
        String field1 = "John \"Duke\"";
        String field2 = "";
        String field3 = "Wayne";
        this.content = field1 + "," + field2 + "," + field3;
        this.expected = new String[]{field1, field2, field3};
        this.doTest(this.content, this.expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest(String content, String[] expected) throws Exception {
        QueueRowSet output = new QueueRowSet();
        File tmp = this.createTestFile("utf-8", content);
        try {
            CsvInputMeta meta = this.createMeta(tmp, this.createInputFileFields("f1", "f2", "f3"));
            CsvInputData data = new CsvInputData();
            this.csvInput.init((StepMetaInterface)meta, (StepDataInterface)data);
            this.csvInput.addRowSetToOutputRowSets((RowSet)output);
            try {
                this.csvInput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
            }
            finally {
                this.csvInput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
            }
        }
        finally {
            tmp.delete();
        }
        Object[] row = output.getRowImmediate();
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)expected[0], (Object)row[0]);
        Assert.assertEquals((Object)expected[1], (Object)row[1]);
        Assert.assertEquals((Object)expected[2], (Object)row[2]);
        Assert.assertNull((Object)output.getRowImmediate());
    }
}

