/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.trans.steps.csvinput.NamedFieldsMapping;

public class NamedFieldsMappingTest {
    private NamedFieldsMapping fieldsMapping;

    @Before
    public void before() {
        this.fieldsMapping = new NamedFieldsMapping(new int[]{3, 4});
    }

    @Test
    public void fieldMetaIndex() {
        Assert.assertEquals((long)3L, (long)this.fieldsMapping.fieldMetaIndex(0));
    }

    @Test
    public void fieldMetaIndexWithUnexistingField() {
        Assert.assertEquals((long)-1L, (long)this.fieldsMapping.fieldMetaIndex(4));
    }

    @Test
    public void size() {
        Assert.assertEquals((long)2L, (long)this.fieldsMapping.size());
    }

    @Test
    public void mapping() {
        NamedFieldsMapping mapping = NamedFieldsMapping.mapping((String[])new String[]{"FIRST", "SECOND", "THIRD"}, (String[])new String[]{"SECOND", "THIRD"});
        Assert.assertEquals((long)0L, (long)mapping.fieldMetaIndex(1));
    }

    @Test
    public void mappingWithNonUniqueColumnNames() {
        NamedFieldsMapping mapping = NamedFieldsMapping.mapping((String[])new String[]{"Object", "Test", "Object"}, (String[])new String[]{"Object", "Test", "Object"});
        Assert.assertEquals((long)0L, (long)mapping.fieldMetaIndex(0));
        Assert.assertEquals((long)2L, (long)mapping.fieldMetaIndex(2));
    }

    @Test
    public void fieldMetaIndexWithUnexistingField_nonUniqueColumnNames() {
        NamedFieldsMapping mapping = NamedFieldsMapping.mapping((String[])new String[]{"Object", "Test", "Object"}, (String[])new String[]{"Object", "Test"});
        Assert.assertEquals((long)-1L, (long)mapping.fieldMetaIndex(2));
    }

    @Test
    public void mappingWithNonMatchingColumnNames() {
        NamedFieldsMapping mapping = NamedFieldsMapping.mapping((String[])new String[]{"One", "Two", "Three"}, (String[])new String[]{"A", "B", "C"});
        Assert.assertEquals((long)0L, (long)mapping.fieldMetaIndex(0));
        Assert.assertEquals((long)1L, (long)mapping.fieldMetaIndex(1));
        Assert.assertEquals((long)2L, (long)mapping.fieldMetaIndex(2));
        mapping = NamedFieldsMapping.mapping((String[])new String[]{"A", "B", "A"}, (String[])new String[]{"A", "A"});
        Assert.assertEquals((long)0L, (long)mapping.fieldMetaIndex(0));
        Assert.assertEquals((long)-1L, (long)mapping.fieldMetaIndex(1));
        Assert.assertEquals((long)1L, (long)mapping.fieldMetaIndex(2));
        mapping = NamedFieldsMapping.mapping((String[])new String[]{"A", "B", "A"}, (String[])new String[]{"A", "X", "B", "Z"});
        Assert.assertEquals((long)0L, (long)mapping.fieldMetaIndex(0));
        Assert.assertEquals((long)2L, (long)mapping.fieldMetaIndex(1));
        Assert.assertEquals((long)1L, (long)mapping.fieldMetaIndex(2));
        Assert.assertEquals((long)-1L, (long)mapping.fieldMetaIndex(3));
        mapping = NamedFieldsMapping.mapping((String[])new String[]{"A", "B", "A"}, (String[])new String[]{"A", "A", "C"});
        Assert.assertEquals((long)0L, (long)mapping.fieldMetaIndex(0));
        Assert.assertEquals((long)2L, (long)mapping.fieldMetaIndex(1));
        Assert.assertEquals((long)1L, (long)mapping.fieldMetaIndex(2));
        mapping = NamedFieldsMapping.mapping((String[])new String[]{"A", "B", "C", "D", "E"}, (String[])new String[]{"X", "C", "Y", "B"});
        Assert.assertEquals((long)0L, (long)mapping.fieldMetaIndex(0));
        Assert.assertEquals((long)3L, (long)mapping.fieldMetaIndex(1));
        Assert.assertEquals((long)1L, (long)mapping.fieldMetaIndex(2));
        Assert.assertEquals((long)2L, (long)mapping.fieldMetaIndex(3));
        Assert.assertEquals((long)-1L, (long)mapping.fieldMetaIndex(4));
    }
}

