/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.csvinput.CsvInput;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.csvinput.CsvInputUnitTestBase;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class CsvProcessRowInParallelTest
extends CsvInputUnitTestBase {
    private StepMockHelper<CsvInputMeta, StepDataInterface> stepMockHelper;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUp() {
        this.stepMockHelper = StepMockUtil.getStepMockHelper(CsvInputMeta.class, "CsvProcessRowInParallelTest");
    }

    @After
    public void cleanUp() {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void oneByteNewLineIndicator_NewLineAtTheEnd_2Threads() throws Exception {
        int totalNumberOfSteps = 2;
        String fileContent = "a;1\rb;2\r";
        File sharedFile = this.createTestFile("UTF-8", "a;1\rb;2\r");
        Assert.assertEquals((long)1L, (long)this.createAndRunOneStep(sharedFile, 0, 2));
        Assert.assertEquals((long)1L, (long)this.createAndRunOneStep(sharedFile, 1, 2));
    }

    @Test
    public void oneByteNewLineIndicator_NoNewLineAtTheEnd_2Threads() throws Exception {
        int totalNumberOfSteps = 2;
        String fileContent = "a;1\rb;2\rc;3";
        File sharedFile = this.createTestFile("UTF-8", "a;1\rb;2\rc;3");
        Assert.assertEquals((long)2L, (long)this.createAndRunOneStep(sharedFile, 0, 2));
        Assert.assertEquals((long)1L, (long)this.createAndRunOneStep(sharedFile, 1, 2));
    }

    @Test
    public void PDI_15162_mixedByteNewLineIndicator_NewLineAtTheEnd_2Threads() throws Exception {
        int totalNumberOfSteps = 2;
        String fileContent = "ab;111\r\nbc;222\r\ncd;333\r\nde;444\r\nef;555\rfg;666\r\ngh;777\r\nhi;888\r\nij;999\rjk;000\r";
        File sharedFile = this.createTestFile("UTF-8", "ab;111\r\nbc;222\r\ncd;333\r\nde;444\r\nef;555\rfg;666\r\ngh;777\r\nhi;888\r\nij;999\rjk;000\r");
        Assert.assertEquals((long)5L, (long)this.createAndRunOneStep(sharedFile, 0, 2));
        Assert.assertEquals((long)5L, (long)this.createAndRunOneStep(sharedFile, 1, 2));
    }

    @Test
    public void PDI_15162_mixedByteNewLineIndicator_NoNewLineAtTheEnd_2Threads() throws Exception {
        int totalNumberOfSteps = 2;
        String fileContent = "ab;111\r\nbc;222\r\ncd;333\r\nde;444\r\nef;555\rfg;666\r\ngh;777\r\nhi;888\r\nij;999\rjk;000";
        File sharedFile = this.createTestFile("UTF-8", "ab;111\r\nbc;222\r\ncd;333\r\nde;444\r\nef;555\rfg;666\r\ngh;777\r\nhi;888\r\nij;999\rjk;000");
        Assert.assertEquals((long)5L, (long)this.createAndRunOneStep(sharedFile, 0, 2));
        Assert.assertEquals((long)5L, (long)this.createAndRunOneStep(sharedFile, 1, 2));
    }

    @Test
    public void twoByteNewLineIndicator_NewLineAtTheEnd_2Threads() throws Exception {
        String fileContent = "a;1\r\nb;2\r\n";
        int totalNumberOfSteps = 2;
        File sharedFile = this.createTestFile("UTF-8", "a;1\r\nb;2\r\n");
        Assert.assertEquals((long)1L, (long)this.createAndRunOneStep(sharedFile, 0, 2));
        Assert.assertEquals((long)1L, (long)this.createAndRunOneStep(sharedFile, 1, 2));
    }

    @Test
    public void twoByteNewLineIndicator_NoNewLineAtTheEnd_2Threads() throws Exception {
        String fileContent = "a;1\r\nb;2";
        int totalNumberOfSteps = 2;
        File sharedFile = this.createTestFile("UTF-8", "a;1\r\nb;2");
        int t1 = this.createAndRunOneStep(sharedFile, 0, 2);
        int t2 = this.createAndRunOneStep(sharedFile, 1, 2);
        Assert.assertEquals((long)2L, (long)(t1 + t2));
    }

    @Test
    public void twoByteNewLineIndicator_NewLineAtTheEnd_3Threads() throws Exception {
        String fileContent = "a;1\r\nb;2\r\nc;3\r\nd;4\r\ne;5\r\nf;6\r\n";
        int totalNumberOfSteps = 3;
        File sharedFile = this.createTestFile("UTF-8", "a;1\r\nb;2\r\nc;3\r\nd;4\r\ne;5\r\nf;6\r\n");
        Assert.assertEquals((long)2L, (long)this.createAndRunOneStep(sharedFile, 0, 3));
        Assert.assertEquals((long)2L, (long)this.createAndRunOneStep(sharedFile, 1, 3));
        Assert.assertEquals((long)2L, (long)this.createAndRunOneStep(sharedFile, 2, 3));
    }

    @Test
    public void mixedBytesNewLineIndicator_NoNewLineAtTheEnd_2Threads() throws Exception {
        String fileContent = "abcd;1\r\nb;2\r\nd;3";
        int totalNumberOfSteps = 2;
        File sharedFile = this.createTestFile("UTF-8", "abcd;1\r\nb;2\r\nd;3");
        Assert.assertEquals((long)1L, (long)this.createAndRunOneStep(sharedFile, 0, 2));
        Assert.assertEquals((long)2L, (long)this.createAndRunOneStep(sharedFile, 1, 2));
    }

    @Test
    public void mixedBytesNewLineIndicator_NewLineAtTheEnd_2Threads() throws Exception {
        String fileContent = "abcd;1\r\nb;2\rd;3\r";
        int totalNumberOfSteps = 2;
        File sharedFile = this.createTestFile("UTF-8", "abcd;1\r\nb;2\rd;3\r");
        Assert.assertEquals((long)1L, (long)this.createAndRunOneStep(sharedFile, 0, 2));
        Assert.assertEquals((long)2L, (long)this.createAndRunOneStep(sharedFile, 1, 2));
    }

    @Test
    public void PDI_16589_twoByteNewLineIndicator_withHeaders_NewLineAtTheEnd_4Threads() throws Exception {
        int totalNumberOfSteps = 4;
        String fileContent = "Col1,Col2\r\na,1\r\nb,2\r\nc,3\r\nd,4\r\ne,5\r\nf,6\r\ng,7\r\nh,8\r\ni,9\r\njk,10\r\nlm,11\r\n";
        File sharedFile = this.createTestFile("UTF-8", "Col1,Col2\r\na,1\r\nb,2\r\nc,3\r\nd,4\r\ne,5\r\nf,6\r\ng,7\r\nh,8\r\ni,9\r\njk,10\r\nlm,11\r\n");
        int t1 = this.createAndRunOneStep(sharedFile, 0, 4, true, ",");
        int t2 = this.createAndRunOneStep(sharedFile, 1, 4, true, ",");
        int t3 = this.createAndRunOneStep(sharedFile, 2, 4, true, ",");
        int t4 = this.createAndRunOneStep(sharedFile, 3, 4, true, ",");
        Assert.assertEquals((long)11L, (long)(t1 + t2 + t3 + t4));
    }

    private int processRows(StepMetaDataCombi combi) throws Exception {
        boolean haveRowsToRead;
        CsvInput csvInput = (CsvInput)combi.step;
        CsvInputData stepData = (CsvInputData)combi.data;
        CsvInputMeta stepMeta = (CsvInputMeta)combi.meta;
        final int[] writtenRows = new int[]{0};
        csvInput.addRowListener((RowListener)new RowAdapter(){

            public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                writtenRows[0] = writtenRows[0] + 1;
            }
        });
        while (!(haveRowsToRead = !csvInput.processRow((StepMetaInterface)stepMeta, (StepDataInterface)stepData))) {
        }
        csvInput.dispose((StepMetaInterface)stepMeta, (StepDataInterface)stepData);
        return writtenRows[0];
    }

    private CsvInput createCsvInput() {
        return new CsvInput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
    }

    private int createAndRunOneStep(File sharedFile, int stepNr, int totalNumberOfSteps) throws Exception {
        return this.createAndRunOneStep(sharedFile, stepNr, totalNumberOfSteps, false, ";");
    }

    private int createAndRunOneStep(File sharedFile, int stepNr, int totalNumberOfSteps, boolean headersPresent, String delimiter) throws Exception {
        StepMetaDataCombi combiStep1 = this.createBaseCombi(sharedFile, headersPresent, delimiter);
        this.configureData((CsvInputData)combiStep1.data, stepNr, totalNumberOfSteps);
        return this.processRows(combiStep1);
    }

    private StepMetaDataCombi createBaseCombi(File sharedFile, boolean headerPresent, String delimiter) {
        StepMetaDataCombi combi = new StepMetaDataCombi();
        CsvInputData data = new CsvInputData();
        CsvInputMeta meta = this.createMeta(sharedFile, this.createInputFileFields("Field_000", "Field_001"), headerPresent, delimiter);
        CsvInput csvInput = this.createCsvInput();
        csvInput.init((StepMetaInterface)meta, (StepDataInterface)data);
        combi.step = csvInput;
        combi.data = data;
        combi.meta = meta;
        return combi;
    }

    private CsvInputMeta createMeta(File file, TextFileInputField[] fields, boolean headerPresent, String delimiter) {
        CsvInputMeta meta = this.createMeta(file, fields);
        meta.setDelimiter(delimiter);
        meta.setEnclosure("\"");
        if (!headerPresent) {
            meta.setInputFields(fields);
        }
        meta.setHeaderPresent(headerPresent);
        meta.setRunningInParallel(true);
        return meta;
    }

    private void configureData(CsvInputData data, int currentStepNr, int totalNumberOfSteps) {
        data.parallel = true;
        data.stepNumber = currentStepNr;
        data.totalNumberOfSteps = totalNumberOfSteps;
    }
}

