/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.nio.charset.StandardCharsets;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.csvinput.CsvInput;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.csvinput.CsvInputUnitTestBase;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class CsvInputUnicodeTest
extends CsvInputUnitTestBase {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private static final String UTF8 = "UTF-8";
    private static final String UTF16LE = "UTF-16LE";
    private static final String UTF16LEBOM = "x-UTF-16LE-BOM";
    private static final String UTF16BE = "UTF-16BE";
    private static final String ONE_CHAR_DELIM = "\t";
    private static final String MULTI_CHAR_DELIM = "|||";
    private static final String TEXT = "Header1%1$sHeader2\nValue%1$sValue\nValue%1$sValue\n";
    private static final String TEXTHEADER = "Header1%1$sHeader2\n";
    private static final String TEXTBODY = "Value%1$sValue\nValue%1$sValue\n";
    private static final String TEXT_WITH_ENCLOSURES = "Header1%1$sHeader2\n\"Value\"%1$s\"Value\"\n\"Value\"%1$s\"Value\"\n";
    private static final String TEST_DATA = String.format("Header1%1$sHeader2\nValue%1$sValue\nValue%1$sValue\n", "\t");
    private static final String TEST_DATA1 = String.format("Header1%1$sHeader2\nValue%1$sValue\nValue%1$sValue\n", "|||");
    private static final String TEST_DATA2 = String.format("Header1%1$sHeader2\n\"Value\"%1$s\"Value\"\n\"Value\"%1$s\"Value\"\n", "\t");
    private static final String TEST_DATA3 = String.format("Header1%1$sHeader2\n\"Value\"%1$s\"Value\"\n\"Value\"%1$s\"Value\"\n", "|||");
    private static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    private static final String TEST_DATA_UTF8_BOM = String.format(new String(UTF8_BOM, StandardCharsets.UTF_8) + "Header1%1$sHeader2\nValue%1$sValue\nValue%1$sValue\n", "\t");
    private static final String TEST_DATA_NOHEADER_UTF8_BOM = String.format(new String(UTF8_BOM, StandardCharsets.UTF_8) + "Value%1$sValue\nValue%1$sValue\n", "\t");
    private static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    private static final String TEST_DATA_UTF16LE_BOM = String.format(new String(UTF16LE_BOM, StandardCharsets.UTF_16LE) + TEST_DATA2, "\t");
    private static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    private static final String TEST_DATA_UTF16BE_BOM = String.format(new String(UTF16BE_BOM, StandardCharsets.UTF_16BE) + TEST_DATA2, "\t");
    private static StepMockHelper<CsvInputMeta, StepDataInterface> stepMockHelper;

    @BeforeClass
    public static void setUp() throws KettleException {
        stepMockHelper = StepMockUtil.getStepMockHelper(CsvInputMeta.class, "CsvInputUnicodeTest");
        Mockito.when((Object)CsvInputUnicodeTest.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)CsvInputUnicodeTest.stepMockHelper.logChannelInterface);
        Mockito.when((Object)CsvInputUnicodeTest.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @AfterClass
    public static void cleanUp() {
        stepMockHelper.cleanUp();
    }

    @Test
    public void testUTF16LE() throws Exception {
        this.doTest(UTF16LE, UTF16LE, TEST_DATA, ONE_CHAR_DELIM, true);
    }

    @Test
    public void testUTF16BE() throws Exception {
        this.doTest(UTF16BE, UTF16BE, TEST_DATA, ONE_CHAR_DELIM, true);
    }

    @Test
    public void testUTF16BE_multiDelim() throws Exception {
        this.doTest(UTF16BE, UTF16BE, TEST_DATA1, MULTI_CHAR_DELIM, true);
    }

    @Test
    public void testUTF16LEBOM() throws Exception {
        this.doTest(UTF16LEBOM, UTF16LE, TEST_DATA, ONE_CHAR_DELIM, true);
    }

    @Test
    public void testUTF8() throws Exception {
        this.doTest(UTF8, UTF8, TEST_DATA, ONE_CHAR_DELIM, true);
    }

    @Test
    public void testUTF8_multiDelim() throws Exception {
        this.doTest(UTF8, UTF8, TEST_DATA1, MULTI_CHAR_DELIM, true);
    }

    @Test
    public void testUTF8_headerWithBOM() throws Exception {
        this.doTest(UTF8, UTF8, TEST_DATA_UTF8_BOM, ONE_CHAR_DELIM, true);
    }

    @Test
    public void testUTF8_withoutHeaderWithBOM() throws Exception {
        this.doTest(UTF8, UTF8, TEST_DATA_NOHEADER_UTF8_BOM, ONE_CHAR_DELIM, false);
    }

    @Test
    public void testUTF16LEDataWithEnclosures() throws Exception {
        this.doTest(UTF16LE, UTF16LE, TEST_DATA2, ONE_CHAR_DELIM, true);
    }

    @Test
    public void testUTF16LE_headerWithBOM() throws Exception {
        this.doTest(UTF16LE, UTF16LE, TEST_DATA_UTF16LE_BOM, ONE_CHAR_DELIM, true);
    }

    @Test
    public void testUTF16BEDataWithEnclosures() throws Exception {
        this.doTest(UTF16BE, UTF16BE, TEST_DATA2, ONE_CHAR_DELIM, true);
    }

    @Test
    public void testUTF16BE_headerWithBOM() throws Exception {
        this.doTest(UTF16BE, UTF16BE, TEST_DATA_UTF16BE_BOM, ONE_CHAR_DELIM, true);
    }

    @Test
    public void testUTF16LEBOMDataWithEnclosures() throws Exception {
        this.doTest(UTF16LEBOM, UTF16LE, TEST_DATA2, ONE_CHAR_DELIM, true);
    }

    @Test
    public void testUTF16BE_multiDelim_DataWithEnclosures() throws Exception {
        this.doTest(UTF16BE, UTF16BE, TEST_DATA3, MULTI_CHAR_DELIM, true);
    }

    @Test
    public void testUTF16LE_multiDelim_DataWithEnclosures() throws Exception {
        this.doTest(UTF16LE, UTF16LE, TEST_DATA3, MULTI_CHAR_DELIM, true);
    }

    @Test
    public void testUTF8_multiDelim_DataWithEnclosures() throws Exception {
        this.doTest(UTF8, UTF8, TEST_DATA3, MULTI_CHAR_DELIM, true);
    }

    private void doTest(String fileEncoding, String stepEncoding, String testData, String delimiter, boolean useHeader) throws Exception {
        boolean haveRowsToRead;
        String testFilePath = this.createTestFile(fileEncoding, testData).getAbsolutePath();
        CsvInputMeta meta = this.createStepMeta(testFilePath, stepEncoding, delimiter, useHeader);
        CsvInputData data = new CsvInputData();
        CsvInput csvInput = new CsvInput(CsvInputUnicodeTest.stepMockHelper.stepMeta, CsvInputUnicodeTest.stepMockHelper.stepDataInterface, 0, CsvInputUnicodeTest.stepMockHelper.transMeta, CsvInputUnicodeTest.stepMockHelper.trans);
        csvInput.init((StepMetaInterface)meta, (StepDataInterface)data);
        csvInput.addRowListener((RowListener)new RowAdapter(){

            public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                for (int i = 0; i < rowMeta.size(); ++i) {
                    Assert.assertEquals((Object)"Value", (Object)row[i]);
                }
            }
        });
        while (!(haveRowsToRead = !csvInput.processRow((StepMetaInterface)meta, (StepDataInterface)data))) {
        }
        csvInput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        Assert.assertEquals((long)2L, (long)csvInput.getLinesWritten());
    }

    private CsvInputMeta createStepMeta(String testFilePath, String encoding, String delimiter, boolean useHeader) {
        CsvInputMeta meta = new CsvInputMeta();
        meta.setFilename(testFilePath);
        meta.setDelimiter(delimiter);
        meta.setEncoding(encoding);
        meta.setEnclosure("\"");
        meta.setBufferSize("50000");
        meta.setInputFields(this.getInputFileFields());
        meta.setHeaderPresent(useHeader);
        return meta;
    }

    private TextFileInputField[] getInputFileFields() {
        return this.createInputFileFields("Header1", "Header2");
    }
}

