/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.csvinput.CsvInput;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.csvinput.CsvInputUnitTestBase;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class CsvInputTest
extends CsvInputUnitTestBase {
    private StepMockHelper<CsvInputMeta, StepDataInterface> stepMockHelper;
    private LogChannelInterface logChannelInterface;
    private CsvInputMeta csvInputMeta;

    @Before
    public void setUp() throws Exception {
        this.logChannelInterface = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        this.stepMockHelper = StepMockUtil.getStepMockHelper(CsvInputMeta.class, "CsvInputTest");
        this.csvInputMeta = (CsvInputMeta)Mockito.mock(CsvInputMeta.class);
    }

    @After
    public void cleanUp() {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void guessStringsFromLineWithEmptyLine() throws Exception {
        String[] saData = CsvInput.guessStringsFromLine((LogChannelInterface)this.logChannelInterface, null, (String)this.csvInputMeta.getDelimiter(), (String)this.csvInputMeta.getEnclosure(), (String)this.csvInputMeta.getEscapeCharacter());
        Assert.assertNull((Object)saData);
    }

    @Test
    public void testFileIsReleasedAfterProcessing() throws Exception {
        TextFileInputField[] inputFileFields = this.createInputFileFields("f1", "f2", "f3");
        String fileContents = "Something,,The former was empty!";
        File tmpFile = this.createTestFile("utf-8", fileContents);
        CsvInputMeta meta = this.createMeta(tmpFile, inputFileFields);
        CsvInputData data = new CsvInputData();
        QueueRowSet output = new QueueRowSet();
        CsvInput csvInput = new CsvInput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        csvInput.init((StepMetaInterface)meta, (StepDataInterface)data);
        csvInput.addRowSetToOutputRowSets((RowSet)output);
        csvInput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        csvInput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        Assert.assertTrue((boolean)tmpFile.delete());
        Assert.assertFalse((boolean)tmpFile.exists());
    }
}

