/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.csvinput.CsvInput;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.csvinput.CsvInputUnitTestBase;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class CsvInputMultiCharDelimiterTest
extends CsvInputUnitTestBase {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private CsvInput csvInput;
    private StepMockHelper<CsvInputMeta, StepDataInterface> stepMockHelper;

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = StepMockUtil.getStepMockHelper(CsvInputMeta.class, "CsvInputMultiCharDelimiterTest");
        this.csvInput = new CsvInput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
    }

    @After
    public void cleanUp() {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void multiChar_hasEnclosures_HasNewLine() throws Exception {
        this.doTest("\"value1\"delimiter\"value2\"delimiter\"value3\"\n");
    }

    @Test
    public void multiChar_hasEnclosures_HasNewLineDoubleEnd() throws Exception {
        this.doTest("\"value1\"delimiter\"value2\"delimiter\"value3\"\r\n");
    }

    @Test
    public void multiChar_hasEnclosures_HasNotNewLine() throws Exception {
        this.doTest("\"value1\"delimiter\"value2\"delimiter\"value3\"");
    }

    @Test
    public void multiChar_hasNotEnclosures_HasNewLine() throws Exception {
        this.doTest("value1delimitervalue2delimitervalue3\n");
    }

    @Test
    public void multiChar_hasNotEnclosures_HasNewLineDoubleEnd() throws Exception {
        this.doTest("value1delimitervalue2delimitervalue3\r\n");
    }

    @Test
    public void multiChar_hasNotEnclosures_HasNotNewLine() throws Exception {
        this.doTest("value1delimitervalue2delimitervalue3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(String content) throws Exception {
        QueueRowSet output = new QueueRowSet();
        File tmp = this.createTestFile("utf-8", content);
        try {
            CsvInputMeta meta = this.createMeta(tmp, this.createInputFileFields("f1", "f2", "f3"));
            CsvInputData data = new CsvInputData();
            this.csvInput.init((StepMetaInterface)meta, (StepDataInterface)data);
            this.csvInput.addRowSetToOutputRowSets((RowSet)output);
            try {
                this.csvInput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
            }
            finally {
                this.csvInput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
            }
        }
        finally {
            tmp.delete();
        }
        Object[] row = output.getRowImmediate();
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"value1", (Object)row[0]);
        Assert.assertEquals((Object)"value2", (Object)row[1]);
        Assert.assertEquals((Object)"value3", (Object)row[2]);
        Assert.assertNull((Object)output.getRowImmediate());
    }

    @Override
    CsvInputMeta createMeta(File file, TextFileInputField[] fields) {
        CsvInputMeta meta = super.createMeta(file, fields);
        meta.setDelimiter("delimiter");
        return meta;
    }
}

