/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.TextFileInputFieldValidator;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class CsvInputMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<CsvInputMeta> testMetaClass = CsvInputMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("BufferSize", "Delimiter", "Enclosure", "Encoding", "Filename", "FilenameField", "InputFields", "RowNumField", "AddResultFile", "HeaderPresent", "IncludingFilename", "LazyConversionActive", "NewlinePossibleInFields", "RunningInParallel");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("hasHeader", "hasHeader");
                this.put("includeFilename", "includeFilename");
                this.put("includeRowNumber", "includeRowNumber");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("includeFilename", "includeFilename");
                this.put("includeRowNumber", "includeRowNumber");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("InputFields", new ArrayLoadSaveValidator<TextFileInputField>(new TextFileInputFieldValidator(), 5));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof CsvInputMeta) {
            ((CsvInputMeta)someMeta).allocate(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testClone() {
        CsvInputMeta original = new CsvInputMeta();
        original.setDelimiter(";");
        original.setEnclosure("'");
        TextFileInputField[] originalFields = new TextFileInputField[1];
        TextFileInputField originalField = new TextFileInputField();
        originalField.setName("field");
        originalFields[0] = originalField;
        original.setInputFields(originalFields);
        CsvInputMeta clone = (CsvInputMeta)original.clone();
        Assert.assertNotSame((Object)original, (Object)clone);
        Assert.assertEquals((Object)original.getDelimiter(), (Object)clone.getDelimiter());
        Assert.assertEquals((Object)original.getEnclosure(), (Object)clone.getEnclosure());
        Assert.assertNotSame((Object)original.getInputFields(), (Object)clone.getInputFields());
        Assert.assertNotSame((Object)original.getInputFields()[0], (Object)clone.getInputFields()[0]);
        Assert.assertEquals((Object)original.getInputFields()[0].getName(), (Object)clone.getInputFields()[0].getName());
    }
}

