/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.csvinput.CsvInput;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.csvinput.CsvInputUnitTestBase;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class CsvInputEnclosureTest
extends CsvInputUnitTestBase {
    private static final String QUOTATION_AND_EXCLAMATION_MARK = "\"!";
    private static final String QUOTATION_MARK = "\"";
    private static final String SEMICOLON = ";";
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private CsvInput csvInput;
    private StepMockHelper<CsvInputMeta, StepDataInterface> stepMockHelper;

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = StepMockUtil.getStepMockHelper(CsvInputMeta.class, "CsvInputEnclosureTest");
        this.csvInput = new CsvInput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
    }

    @After
    public void cleanUp() {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void hasEnclosures_HasNewLine() throws Exception {
        this.doTest("\"value1\";\"value2\"\n", QUOTATION_MARK);
    }

    @Test
    public void hasEnclosures_HasNotNewLine() throws Exception {
        this.doTest("\"value1\";\"value2\"", QUOTATION_MARK);
    }

    @Test
    public void hasNotEnclosures_HasNewLine() throws Exception {
        this.doTest("value1;value2\n", QUOTATION_MARK);
    }

    @Test
    public void hasNotEnclosures_HasNotNewLine() throws Exception {
        this.doTest("value1;value2", QUOTATION_MARK);
    }

    @Test
    public void hasMultiSymbolsEnclosureWithoutEnclosureAndEndFile() throws Exception {
        this.doTest("value1;value2", QUOTATION_AND_EXCLAMATION_MARK);
    }

    @Test
    public void hasMultiSymbolsEnclosureWithEnclosureAndWithoutEndFile() throws Exception {
        this.doTest("\"!value1\"!;value2", QUOTATION_AND_EXCLAMATION_MARK);
    }

    @Test
    public void hasMultiSymbolsEnclosurewithEnclosureInBothfield() throws Exception {
        this.doTest("\"!value1\"!;\"!value2\"!", QUOTATION_AND_EXCLAMATION_MARK);
    }

    @Test
    public void hasMultiSymbolsEnclosureWithoutEnclosureAndWithEndfileRN() throws Exception {
        this.doTest("value1;value2\r\n", QUOTATION_AND_EXCLAMATION_MARK);
    }

    @Test
    public void hasMultiSymbolsEnclosureWithEnclosureAndWithEndfileRN() throws Exception {
        this.doTest("value1;\"!value2\"!\r\n", QUOTATION_AND_EXCLAMATION_MARK);
    }

    @Test
    public void hasMultiSymbolsEnclosureWithoutEnclosureAndWithEndfileN() throws Exception {
        this.doTest("value1;value2\n", QUOTATION_AND_EXCLAMATION_MARK);
    }

    @Test
    public void hasMultiSymbolsEnclosureWithEnclosureAndWithEndfileN() throws Exception {
        this.doTest("value1;\"!value2\"!\n", QUOTATION_AND_EXCLAMATION_MARK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest(String content, String enclosure) throws Exception {
        QueueRowSet output = new QueueRowSet();
        File tmp = this.createTestFile("utf-8", content);
        try {
            CsvInputMeta meta = this.createMeta(tmp, this.createInputFileFields("f1", "f2"), enclosure);
            CsvInputData data = new CsvInputData();
            this.csvInput.init((StepMetaInterface)meta, (StepDataInterface)data);
            this.csvInput.addRowSetToOutputRowSets((RowSet)output);
            try {
                this.csvInput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
            }
            finally {
                this.csvInput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
            }
        }
        finally {
            tmp.delete();
        }
        Object[] row = output.getRowImmediate();
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"value1", (Object)row[0]);
        Assert.assertEquals((Object)"value2", (Object)row[1]);
        Assert.assertNull((Object)output.getRowImmediate());
    }

    private CsvInputMeta createMeta(File file, TextFileInputField[] fields, String enclosure) {
        CsvInputMeta meta = this.createMeta(file, fields);
        meta.setDelimiter(SEMICOLON);
        meta.setEnclosure(enclosure);
        return meta;
    }
}

