/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;

public class CsvInputDataTest {
    @Test
    public void testRemoveEscapedEnclosuresWithOneEscapedInMiddle() {
        CsvInputData csvInputData = new CsvInputData();
        csvInputData.enclosure = "\"".getBytes();
        String result = new String(csvInputData.removeEscapedEnclosures("abcd \"\" defg".getBytes(), 1));
        Assert.assertEquals((Object)"abcd \" defg", (Object)result);
    }

    @Test
    public void testRemoveEscapedEnclosuresWithTwoEscapedInMiddle() {
        CsvInputData csvInputData = new CsvInputData();
        csvInputData.enclosure = "\"".getBytes();
        String result = new String(csvInputData.removeEscapedEnclosures("abcd \"\"\"\" defg".getBytes(), 2));
        Assert.assertEquals((Object)"abcd \"\" defg", (Object)result);
    }

    @Test
    public void testRemoveEscapedEnclosuresWithOneByItself() {
        CsvInputData csvInputData = new CsvInputData();
        csvInputData.enclosure = "\"".getBytes();
        String result = new String(csvInputData.removeEscapedEnclosures("\"\"".getBytes(), 1));
        Assert.assertEquals((Object)"\"", (Object)result);
    }

    @Test
    public void testRemoveEscapedEnclosuresWithTwoByThemselves() {
        CsvInputData csvInputData = new CsvInputData();
        csvInputData.enclosure = "\"".getBytes();
        String result = new String(csvInputData.removeEscapedEnclosures("\"\"\"\"".getBytes(), 2));
        Assert.assertEquals((Object)"\"\"", (Object)result);
    }

    @Test
    public void testRemoveEscapedEnclosuresWithCharacterInTheMiddleOfThem() {
        CsvInputData csvInputData = new CsvInputData();
        csvInputData.enclosure = "\"".getBytes();
        String result = new String(csvInputData.removeEscapedEnclosures("345\"\"1\"\"abc".getBytes(), 2));
        Assert.assertEquals((Object)"345\"1\"abc", (Object)result);
    }
}

