/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.csvinput.BaseCsvParsingTest;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class CsvInputContentParsingTest
extends BaseCsvParsingTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Test
    public void testDefaultOptions() throws Exception {
        this.init("default.csv");
        this.setFields(new TextFileInputField("Field 1", -1, -1), new TextFileInputField("Field 2", -1, -1), new TextFileInputField("Field 3", -1, -1));
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third", "3", "3.3"}});
    }

    @Test
    public void testColumnNameWithSpaces() throws Exception {
        this.init("column_name_with_spaces.csv");
        this.setFields(new TextFileInputField("Field 1", -1, -1), new TextFileInputField("Field 2", -1, -1), new TextFileInputField("Field 3", -1, -1));
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third", "3", "3.3"}});
    }

    @Test
    public void testSemicolonOptions() throws Exception {
        ((CsvInputMeta)this.meta).setDelimiter(";");
        this.init("semicolon.csv");
        this.setFields(new TextFileInputField("Field 1", -1, -1), new TextFileInputField("Field 2", -1, -1), new TextFileInputField("Field 3", -1, -1));
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third", "3", "3.3"}, {"\u043d\u0435-\u043b\u0430\u0446\u0456\u043d\u043a\u0430(non-latin)", "4", "4"}});
    }

    @Test
    public void testMultiCharDelimOptions() throws Exception {
        ((CsvInputMeta)this.meta).setDelimiter("|||");
        this.init("multi_delim.csv");
        this.setFields(new TextFileInputField("Field 1", -1, -1), new TextFileInputField("Field 2", -1, -1), new TextFileInputField("Field 3", -1, -1));
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third", "3", "3.3"}, {"\u043d\u0435-\u043b\u0430\u0446\u0456\u043d\u043a\u0430(non-latin)", "4", "4"}});
    }

    @Test
    public void testMixFileFormat() throws Exception {
        String data = "\u30c7\u30fc\u30bf1,\u30c7\u30fc\u30bf2,\u30c7\u30fc\u30bf3,\u30c7\u30fc\u30bf4\n111,\"a\nbc\",\u3042\u3044\u3046,\u3055\u3057\u3059\n222,def,\u304b\u304d\u304f,\u305f\u3061\u3064\r\n333,,\u304b\u304d\u304f,\u305f\u3061\u3064\n444,,\n555,\u304b\u304d\u304f,\r\n666,\u304b\u304d\u304f\r\n\n777,\n888,\u304b\u304d\u304f\r\n\n999,123,123,123,132,132,132,132,132\r";
        String file = this.createTestFile("UTF-8", data).getAbsolutePath();
        ((CsvInputMeta)this.meta).setFileFormat("mixed");
        this.init(file, true);
        this.setFields(new TextFileInputField("Col 1", -1, -1), new TextFileInputField("Col 2", -1, -1), new TextFileInputField("Col 3", -1, -1), new TextFileInputField("Col 4", -1, -1), new TextFileInputField("Col 5", -1, -1));
        this.process();
        this.check(new Object[][]{{"111", "a\nbc", "\u3042\u3044\u3046", "\u3055\u3057\u3059", null}, {"222", "def", "\u304b\u304d\u304f", "\u305f\u3061\u3064", null}, {"333", "", "\u304b\u304d\u304f", "\u305f\u3061\u3064", null}, {"444", "", "", null, null}, {"555", "\u304b\u304d\u304f", "", null, null}, {"666", "\u304b\u304d\u304f", null, null, null}, new Object[0], {"777", "", null, null, null}, {"888", "\u304b\u304d\u304f", null, null, null}, new Object[0], {"999", "123", "123", "123", "132"}});
    }

    @Test
    public void testDosFileFormat() throws Exception {
        String data = "\u30c7\u30fc\u30bf1,\u30c7\u30fc\u30bf2,\u30c7\u30fc\u30bf3,\u30c7\u30fc\u30bf4\r\n111,\"a\r\nbc\",\u3042\u3044\u3046,\u3055\u3057\u3059\r\n222,def,\u304b\u304d\u304f,\u305f\u3061\u3064\r\n333,,\u304b\u304d\u304f,\u305f\u3061\u3064\r\n444,,\r\n555,\u304b\u304d\u304f,\r\n666,\u304b\u304d\u304f\r\n\r\n777,\r\n888,\u304b\u304d\u304f\r\n\r\n999,123,123,123,132,132,132,132,132\r\n";
        String file = this.createTestFile("UTF-8", data).getAbsolutePath();
        ((CsvInputMeta)this.meta).setFileFormat("DOS");
        this.init(file, true);
        this.setFields(new TextFileInputField("Col 1", -1, -1), new TextFileInputField("Col 2", -1, -1), new TextFileInputField("Col 3", -1, -1), new TextFileInputField("Col 4", -1, -1), new TextFileInputField("Col 5", -1, -1));
        this.process();
        this.check(new Object[][]{{"111", "a\r\nbc", "\u3042\u3044\u3046", "\u3055\u3057\u3059", null}, {"222", "def", "\u304b\u304d\u304f", "\u305f\u3061\u3064", null}, {"333", "", "\u304b\u304d\u304f", "\u305f\u3061\u3064", null}, {"444", "", "", null, null}, {"555", "\u304b\u304d\u304f", "", null, null}, {"666", "\u304b\u304d\u304f", null, null, null}, new Object[0], {"777", "", null, null, null}, {"888", "\u304b\u304d\u304f", null, null, null}, new Object[0], {"999", "123", "123", "123", "132"}});
    }

    @Test
    public void testUnixFileFormat() throws Exception {
        String data = "\u30c7\u30fc\u30bf1,\u30c7\u30fc\u30bf2,\u30c7\u30fc\u30bf3,\u30c7\u30fc\u30bf4\n111,\"a\nbc\",\n\n444,,\n555,\u304b\u304d\u304f,\n\n\n777,\n888,\u304b\u304d\u304f\n999,123,123,123,132,132,132,132,132\n";
        String file = this.createTestFile("UTF-8", data).getAbsolutePath();
        ((CsvInputMeta)this.meta).setFileFormat("Unix");
        this.init(file, true);
        this.setFields(new TextFileInputField("Col 1", -1, -1), new TextFileInputField("Col 2", -1, -1), new TextFileInputField("Col 3", -1, -1), new TextFileInputField("Col 4", -1, -1), new TextFileInputField("Col 5", -1, -1));
        this.process();
        this.check(new Object[][]{{"111", "a\nbc", "", null, null}, new Object[0], {"444", "", "", null, null}, {"555", "\u304b\u304d\u304f", "", null, null}, new Object[0], new Object[0], {"777", "", null, null, null}, {"888", "\u304b\u304d\u304f", null, null, null}, {"999", "123", "123", "123", "132"}});
    }

    @Test(expected=KettleStepException.class)
    public void testNoHeaderOptions() throws Exception {
        ((CsvInputMeta)this.meta).setHeaderPresent(false);
        this.init("default.csv");
        this.setFields(new TextFileInputField(), new TextFileInputField(), new TextFileInputField());
        this.process();
    }

    File createTestFile(String encoding, String content) throws IOException {
        File tempFile = File.createTempFile("PDI_tmp", ".csv");
        tempFile.deleteOnExit();
        try (PrintWriter osw = new PrintWriter(tempFile, encoding);){
            osw.write(content);
        }
        return tempFile;
    }
}

