/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.creditcardvalidator;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.creditcardvalidator.CreditCardValidatorMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;

public class CreditCardValidatorMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Test
    public void testLoadSave() throws KettleException {
        List<String> attributes = Arrays.asList("DynamicField", "ResultFieldName", "CardType", "OnlyDigits", "NotValidMsg");
        LoadSaveTester<CreditCardValidatorMeta> loadSaveTester = new LoadSaveTester<CreditCardValidatorMeta>(CreditCardValidatorMeta.class, attributes);
        loadSaveTester.testSerialization();
    }

    @Test
    public void testSupportsErrorHandling() {
        Assert.assertTrue((boolean)new CreditCardValidatorMeta().supportsErrorHandling());
    }

    @Test
    public void testDefaults() {
        CreditCardValidatorMeta meta = new CreditCardValidatorMeta();
        meta.setDefault();
        Assert.assertEquals((Object)"result", (Object)meta.getResultFieldName());
        Assert.assertFalse((boolean)meta.isOnlyDigits());
        Assert.assertEquals((Object)"card type", (Object)meta.getCardType());
        Assert.assertEquals((Object)"not valid message", (Object)meta.getNotValidMsg());
    }

    @Test
    public void testGetFields() throws KettleStepException {
        CreditCardValidatorMeta meta = new CreditCardValidatorMeta();
        meta.setDefault();
        meta.setResultFieldName("The Result Field");
        meta.setCardType("The Card Type Field");
        meta.setNotValidMsg("Is Card Valid");
        RowMeta rowMeta = new RowMeta();
        meta.getFields((RowMetaInterface)rowMeta, "this step", null, null, (VariableSpace)new Variables(), null, null);
        Assert.assertEquals((long)3L, (long)rowMeta.size());
        Assert.assertEquals((Object)"The Result Field", (Object)rowMeta.getValueMeta(0).getName());
        Assert.assertEquals((long)4L, (long)rowMeta.getValueMeta(0).getType());
        Assert.assertEquals((Object)"this step", (Object)rowMeta.getValueMeta(0).getOrigin());
        Assert.assertEquals((Object)"The Card Type Field", (Object)rowMeta.getValueMeta(1).getName());
        Assert.assertEquals((long)2L, (long)rowMeta.getValueMeta(1).getType());
        Assert.assertEquals((Object)"this step", (Object)rowMeta.getValueMeta(1).getOrigin());
        Assert.assertEquals((Object)"Is Card Valid", (Object)rowMeta.getValueMeta(2).getName());
        Assert.assertEquals((long)2L, (long)rowMeta.getValueMeta(2).getType());
        Assert.assertEquals((Object)"this step", (Object)rowMeta.getValueMeta(2).getOrigin());
    }
}

