/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.constant;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.constant.Constant;
import org.pentaho.di.trans.steps.constant.ConstantData;
import org.pentaho.di.trans.steps.constant.ConstantMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class ConstantTest {
    private StepMockHelper<ConstantMeta, ConstantData> mockHelper;
    private ConstantMeta constantMeta = (ConstantMeta)Mockito.mock(ConstantMeta.class);
    private ConstantData constantData = (ConstantData)Mockito.mock(ConstantData.class);
    private RowMetaAndData rowMetaAndData = (RowMetaAndData)Mockito.mock(RowMetaAndData.class);
    private Constant constantSpy;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void setUpBeforeClass() throws KettlePluginException {
        ValueMetaPluginType.getInstance().searchPlugins();
    }

    @Before
    public void setUp() throws Exception {
        this.mockHelper = new StepMockHelper<ConstantMeta, ConstantData>("Add Constants", ConstantMeta.class, ConstantData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        Mockito.when((Object)this.mockHelper.trans.isRunning()).thenReturn((Object)true);
        ((ConstantData)Mockito.doReturn((Object)this.rowMetaAndData).when(this.mockHelper.stepDataInterface)).getConstants();
        this.constantSpy = (Constant)Mockito.spy((Object)new Constant(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans));
    }

    @After
    public void tearDown() throws Exception {
        this.mockHelper.cleanUp();
    }

    @Test
    public void testProcessRow_success() throws Exception {
        ((Constant)Mockito.doReturn((Object)new Object[1]).when((Object)this.constantSpy)).getRow();
        ((Constant)Mockito.doReturn((Object)new RowMeta()).when((Object)this.constantSpy)).getInputRowMeta();
        ((RowMetaAndData)Mockito.doReturn((Object)new Object[1]).when((Object)this.rowMetaAndData)).getData();
        boolean success = this.constantSpy.processRow((StepMetaInterface)this.constantMeta, (StepDataInterface)this.constantData);
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void testProcessRow_fail() throws Exception {
        ((Constant)Mockito.doReturn(null).when((Object)this.constantSpy)).getRow();
        ((Constant)Mockito.doReturn(null).when((Object)this.constantSpy)).getInputRowMeta();
        boolean success = this.constantSpy.processRow((StepMetaInterface)this.constantMeta, (StepDataInterface)this.constantData);
        Assert.assertFalse((boolean)success);
    }
}

