/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.calculator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.calculator.CalculatorData;
import org.pentaho.di.trans.steps.calculator.CalculatorMeta;
import org.pentaho.di.trans.steps.calculator.CalculatorMetaFunction;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;

public class CalculatorMetaTest
implements InitializerInterface<CalculatorMeta> {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester<CalculatorMeta> loadSaveTester;
    Class<CalculatorMeta> testMetaClass = CalculatorMeta.class;

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException {
        KettleEnvironment.init();
    }

    @Before
    public void setUpLoadSave() throws Exception {
        List<String> attributes = Arrays.asList("Calculation");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        ArrayLoadSaveValidator<CalculatorMetaFunction> calculationMetaFunctionArrayLoadSaveValidator = new ArrayLoadSaveValidator<CalculatorMetaFunction>(new CalculatorMetaFunctionLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("Calculation", calculationMetaFunctionArrayLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<CalculatorMeta>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), getterMap, setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(CalculatorMeta someMeta) {
        someMeta.allocate(5);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testGetStepData() {
        CalculatorMeta meta = new CalculatorMeta();
        Assert.assertTrue((boolean)(meta.getStepData() instanceof CalculatorData));
    }

    @Test
    public void testSetDefault() {
        CalculatorMeta meta = new CalculatorMeta();
        meta.setDefault();
        Assert.assertNotNull((Object)meta.getCalculation());
        Assert.assertEquals((long)0L, (long)meta.getCalculation().length);
        Assert.assertTrue((boolean)meta.isFailIfNoFile());
    }

    public class CalculatorMetaFunctionLoadSaveValidator
    implements FieldLoadSaveValidator<CalculatorMetaFunction> {
        final Random rand = new Random();

        @Override
        public CalculatorMetaFunction getTestObject() {
            CalculatorMetaFunction rtn = new CalculatorMetaFunction();
            rtn.setCalcType(this.rand.nextInt(CalculatorMetaFunction.calc_desc.length));
            rtn.setConversionMask(UUID.randomUUID().toString());
            rtn.setCurrencySymbol(UUID.randomUUID().toString());
            rtn.setDecimalSymbol(UUID.randomUUID().toString());
            rtn.setFieldA(UUID.randomUUID().toString());
            rtn.setFieldB(UUID.randomUUID().toString());
            rtn.setFieldC(UUID.randomUUID().toString());
            rtn.setFieldName(UUID.randomUUID().toString());
            rtn.setGroupingSymbol(UUID.randomUUID().toString());
            rtn.setValueLength(this.rand.nextInt(50));
            rtn.setValuePrecision(this.rand.nextInt(9));
            rtn.setValueType(this.rand.nextInt(7) + 1);
            rtn.setRemovedFromResult(this.rand.nextBoolean());
            return rtn;
        }

        @Override
        public boolean validateTestObject(CalculatorMetaFunction testObject, Object actual) {
            if (!(actual instanceof CalculatorMetaFunction)) {
                return false;
            }
            CalculatorMetaFunction actualInput = (CalculatorMetaFunction)actual;
            return testObject.getXML().equals(actualInput.getXML());
        }
    }
}

