/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.calculator;

import java.lang.reflect.Field;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.calculator.Calculator;
import org.pentaho.di.trans.steps.calculator.CalculatorData;
import org.pentaho.di.trans.steps.calculator.CalculatorMeta;
import org.pentaho.di.trans.steps.calculator.CalculatorMetaFunction;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class CalculatorBackwardCompatibilityUnitTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private StepMockHelper<CalculatorMeta, CalculatorData> smh;
    private static final String SYS_PROPERTY_ROUND_2_MODE = "ROUND_2_MODE";
    private static final int OBSOLETE_ROUND_2_MODE = 6;
    private static final int DEFAULT_ROUND_2_MODE = -1;

    private static int getRound2Mode() {
        int value = -1;
        try {
            Class<ValueDataUtil> cls = ValueDataUtil.class;
            Field f = cls.getDeclaredField(SYS_PROPERTY_ROUND_2_MODE);
            f.setAccessible(true);
            value = (Integer)f.get(null);
            f.setAccessible(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    private static void setRound2Mode(int newValue) {
        try {
            Class<ValueDataUtil> cls = ValueDataUtil.class;
            Field f = cls.getDeclaredField(SYS_PROPERTY_ROUND_2_MODE);
            f.setAccessible(true);
            f.set(null, newValue);
            f.setAccessible(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @BeforeClass
    public static void init() throws KettleException {
        Assert.assertEquals((long)-1L, (long)CalculatorBackwardCompatibilityUnitTest.getRound2Mode());
        CalculatorBackwardCompatibilityUnitTest.setRound2Mode(6);
        Assert.assertEquals((long)6L, (long)CalculatorBackwardCompatibilityUnitTest.getRound2Mode());
        KettleEnvironment.init((boolean)false);
    }

    @AfterClass
    public static void restore() throws Exception {
        CalculatorBackwardCompatibilityUnitTest.setRound2Mode(-1);
        Assert.assertEquals((long)-1L, (long)CalculatorBackwardCompatibilityUnitTest.getRound2Mode());
    }

    @Before
    public void setUp() {
        this.smh = new StepMockHelper<CalculatorMeta, CalculatorData>("Calculator", CalculatorMeta.class, CalculatorData.class);
        Mockito.when((Object)this.smh.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.smh.logChannelInterface);
        Mockito.when((Object)this.smh.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void cleanUp() {
        this.smh.cleanUp();
    }

    @Test
    public void testRound() throws KettleException {
        this.assertRound(1.0, 1.2);
        this.assertRound(2.0, 1.5);
        this.assertRound(2.0, 1.7);
        this.assertRound(2.0, 2.2);
        this.assertRound(3.0, 2.5);
        this.assertRound(3.0, 2.7);
        this.assertRound(-1.0, -1.2);
        this.assertRound(-1.0, -1.5);
        this.assertRound(-2.0, -1.7);
        this.assertRound(-2.0, -2.2);
        this.assertRound(-2.0, -2.5);
        this.assertRound(-3.0, -2.7);
    }

    public void assertRound(final double expectedResult, double value) throws KettleException {
        RowMeta inputRowMeta = new RowMeta();
        ValueMetaNumber valueMeta = new ValueMetaNumber("Value");
        inputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        RowSet inputRowSet = this.smh.getMockInputRowSet(new Object[][]{{value}});
        inputRowSet.setRowMeta((RowMetaInterface)inputRowMeta);
        Calculator calculator = new Calculator(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        calculator.addRowSetToInputRowSets(inputRowSet);
        calculator.setInputRowMeta((RowMetaInterface)inputRowMeta);
        calculator.init(this.smh.initStepMetaInterface, this.smh.initStepDataInterface);
        CalculatorMeta meta = new CalculatorMeta();
        meta.setCalculation(new CalculatorMetaFunction[]{new CalculatorMetaFunction("test", 14, "Value", null, null, 1, 2, 0, false, "", "", "", "")});
        try {
            calculator.addRowListener((RowListener)new RowAdapter(){

                public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    Assert.assertEquals((Object)expectedResult, (Object)row[1]);
                }
            });
            calculator.processRow((StepMetaInterface)meta, (StepDataInterface)new CalculatorData());
        }
        catch (KettleException ke) {
            ke.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testRound2() throws KettleException {
        this.assertRound2(1.0, 1.2, 0L);
        this.assertRound2(2.0, 1.5, 0L);
        this.assertRound2(2.0, 1.7, 0L);
        this.assertRound2(2.0, 2.2, 0L);
        this.assertRound2(2.0, 2.5, 0L);
        this.assertRound2(3.0, 2.7, 0L);
        this.assertRound2(-1.0, -1.2, 0L);
        this.assertRound2(-2.0, -1.5, 0L);
        this.assertRound2(-2.0, -1.7, 0L);
        this.assertRound2(-2.0, -2.2, 0L);
        this.assertRound2(-2.0, -2.5, 0L);
        this.assertRound2(-3.0, -2.7, 0L);
    }

    public void assertRound2(final double expectedResult, double value, long precision) throws KettleException {
        RowMeta inputRowMeta = new RowMeta();
        ValueMetaNumber valueMeta = new ValueMetaNumber("Value");
        ValueMetaInteger precisionMeta = new ValueMetaInteger("Precision");
        inputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        inputRowMeta.addValueMeta((ValueMetaInterface)precisionMeta);
        RowSet inputRowSet = this.smh.getMockInputRowSet(new Object[][]{{value, precision}});
        inputRowSet.setRowMeta((RowMetaInterface)inputRowMeta);
        Calculator calculator = new Calculator(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        calculator.addRowSetToInputRowSets(inputRowSet);
        calculator.setInputRowMeta((RowMetaInterface)inputRowMeta);
        calculator.init(this.smh.initStepMetaInterface, this.smh.initStepDataInterface);
        CalculatorMeta meta = new CalculatorMeta();
        meta.setCalculation(new CalculatorMetaFunction[]{new CalculatorMetaFunction("test", 15, "Value", "Precision", null, 1, 2, 0, false, "", "", "", "")});
        try {
            calculator.addRowListener((RowListener)new RowAdapter(){

                public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    Assert.assertEquals((Object)expectedResult, (Object)row[2]);
                }
            });
            calculator.processRow((StepMetaInterface)meta, (StepDataInterface)new CalculatorData());
        }
        catch (KettleException ke) {
            ke.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testRoundStd() throws KettleException {
        this.assertRoundStd(1.0, 1.2);
        this.assertRoundStd(2.0, 1.5);
        this.assertRoundStd(2.0, 1.7);
        this.assertRoundStd(2.0, 2.2);
        this.assertRoundStd(3.0, 2.5);
        this.assertRoundStd(3.0, 2.7);
        this.assertRoundStd(-1.0, -1.2);
        this.assertRoundStd(-2.0, -1.5);
        this.assertRoundStd(-2.0, -1.7);
        this.assertRoundStd(-2.0, -2.2);
        this.assertRoundStd(-3.0, -2.5);
        this.assertRoundStd(-3.0, -2.7);
    }

    public void assertRoundStd(final double expectedResult, double value) throws KettleException {
        RowMeta inputRowMeta = new RowMeta();
        ValueMetaNumber valueMeta = new ValueMetaNumber("Value");
        inputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        RowSet inputRowSet = this.smh.getMockInputRowSet(new Object[][]{{value}});
        inputRowSet.setRowMeta((RowMetaInterface)inputRowMeta);
        Calculator calculator = new Calculator(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        calculator.addRowSetToInputRowSets(inputRowSet);
        calculator.setInputRowMeta((RowMetaInterface)inputRowMeta);
        calculator.init(this.smh.initStepMetaInterface, this.smh.initStepDataInterface);
        CalculatorMeta meta = new CalculatorMeta();
        meta.setCalculation(new CalculatorMetaFunction[]{new CalculatorMetaFunction("test", 16, "Value", null, null, 1, 2, 0, false, "", "", "", "")});
        try {
            calculator.addRowListener((RowListener)new RowAdapter(){

                public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    Assert.assertEquals((Object)expectedResult, (Object)row[1]);
                }
            });
            calculator.processRow((StepMetaInterface)meta, (StepDataInterface)new CalculatorData());
        }
        catch (KettleException ke) {
            ke.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testRoundStd2() throws KettleException {
        this.assertRoundStd2(1.0, 1.2, 0L);
        this.assertRoundStd2(2.0, 1.5, 0L);
        this.assertRoundStd2(2.0, 1.7, 0L);
        this.assertRoundStd2(2.0, 2.2, 0L);
        this.assertRoundStd2(3.0, 2.5, 0L);
        this.assertRoundStd2(3.0, 2.7, 0L);
        this.assertRoundStd2(-1.0, -1.2, 0L);
        this.assertRoundStd2(-2.0, -1.5, 0L);
        this.assertRoundStd2(-2.0, -1.7, 0L);
        this.assertRoundStd2(-2.0, -2.2, 0L);
        this.assertRoundStd2(-3.0, -2.5, 0L);
        this.assertRoundStd2(-3.0, -2.7, 0L);
    }

    public void assertRoundStd2(final double expectedResult, double value, long precision) throws KettleException {
        RowMeta inputRowMeta = new RowMeta();
        ValueMetaNumber valueMeta = new ValueMetaNumber("Value");
        ValueMetaInteger precisionMeta = new ValueMetaInteger("Precision");
        inputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        inputRowMeta.addValueMeta((ValueMetaInterface)precisionMeta);
        RowSet inputRowSet = this.smh.getMockInputRowSet(new Object[][]{{value, precision}});
        inputRowSet.setRowMeta((RowMetaInterface)inputRowMeta);
        Calculator calculator = new Calculator(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        calculator.addRowSetToInputRowSets(inputRowSet);
        calculator.setInputRowMeta((RowMetaInterface)inputRowMeta);
        calculator.init(this.smh.initStepMetaInterface, this.smh.initStepDataInterface);
        CalculatorMeta meta = new CalculatorMeta();
        meta.setCalculation(new CalculatorMetaFunction[]{new CalculatorMetaFunction("test", 17, "Value", "Precision", null, 1, 2, 0, false, "", "", "", "")});
        try {
            calculator.addRowListener((RowListener)new RowAdapter(){

                public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    Assert.assertEquals((Object)expectedResult, (Object)row[2]);
                }
            });
            calculator.processRow((StepMetaInterface)meta, (StepDataInterface)new CalculatorData());
        }
        catch (KettleException ke) {
            ke.printStackTrace();
            Assert.fail();
        }
    }
}

