/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepOption;

@RunWith(value=MockitoJUnitRunner.class)
public class StepOptionTest {
    @Mock
    StepMeta stepMeta;
    @Mock
    VariableSpace space;

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException {
        KettleEnvironment.init();
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.space.environmentSubstitute(Matchers.anyString())).thenAnswer(incovacationMock -> {
            Object[] arguments = incovacationMock.getArguments();
            return (String)arguments[0];
        });
    }

    @Test
    public void testCheckPass() {
        ArrayList remarks = new ArrayList();
        StepOption.checkInteger(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", (String)"9");
        StepOption.checkLong(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", (String)"9");
        StepOption.checkBoolean(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", (String)"true");
        StepOption.checkBoolean(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", (String)"false");
        Assert.assertEquals((long)0L, (long)remarks.size());
    }

    @Test
    public void testCheckPassEmpty() {
        ArrayList remarks = new ArrayList();
        StepOption.checkInteger(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", (String)"");
        StepOption.checkLong(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", (String)"");
        StepOption.checkBoolean(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", (String)"");
        StepOption.checkInteger(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", null);
        StepOption.checkLong(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", null);
        StepOption.checkBoolean(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", null);
        Assert.assertEquals((long)0L, (long)remarks.size());
    }

    @Test
    public void testCheckFailInteger() {
        ArrayList remarks = new ArrayList();
        StepOption.checkInteger(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", (String)"asdf");
        Assert.assertEquals((long)1L, (long)remarks.size());
        Assert.assertEquals((Object)((CheckResultInterface)remarks.get(0)).getText(), (Object)BaseMessages.getString(StepOption.class, (String)"StepOption.CheckResult.NotAInteger", (String[])new String[]{"IDENTIFIER"}));
    }

    @Test
    public void testCheckFailLong() {
        ArrayList remarks = new ArrayList();
        StepOption.checkLong(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", (String)"asdf");
        Assert.assertEquals((long)1L, (long)remarks.size());
        Assert.assertEquals((Object)((CheckResultInterface)remarks.get(0)).getText(), (Object)BaseMessages.getString(StepOption.class, (String)"StepOption.CheckResult.NotAInteger", (String[])new String[]{"IDENTIFIER"}));
    }

    @Test
    public void testCheckFailBoolean() {
        ArrayList remarks = new ArrayList();
        StepOption.checkBoolean(remarks, (StepMeta)this.stepMeta, (VariableSpace)this.space, (String)"IDENTIFIER", (String)"asdf");
        Assert.assertEquals((long)1L, (long)remarks.size());
        Assert.assertEquals((Object)((CheckResultInterface)remarks.get(0)).getText(), (Object)BaseMessages.getString(StepOption.class, (String)"StepOption.CheckResult.NotABoolean", (String[])new String[]{"IDENTIFIER"}));
    }
}

