/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.core.util.AbstractStepMeta;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.trans.step.FakeRowDistribution;
import org.pentaho.di.trans.step.RowDistributionInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.missing.MissingTrans;
import org.pentaho.di.utils.TestUtils;

public class StepMetaTest {
    private static final Random rand = new Random();
    private static final String STEP_ID = "step_id";

    @Test
    public void cloning() throws Exception {
        StepMeta meta = StepMetaTest.createTestMeta();
        StepMeta clone = (StepMeta)meta.clone();
        StepMetaTest.assertEquals(meta, clone);
    }

    @Test
    public void testEqualsHashCodeConsistency() throws Exception {
        StepMeta step = new StepMeta();
        step.setName("step");
        TestUtils.checkEqualsHashCodeConsistency(step, step);
        StepMeta stepSame = new StepMeta();
        stepSame.setName("step");
        Assert.assertTrue((boolean)step.equals((Object)stepSame));
        TestUtils.checkEqualsHashCodeConsistency(step, stepSame);
        StepMeta stepCaps = new StepMeta();
        stepCaps.setName("STEP");
        TestUtils.checkEqualsHashCodeConsistency(step, stepCaps);
        StepMeta stepOther = new StepMeta();
        stepOther.setName("something else");
        TestUtils.checkEqualsHashCodeConsistency(step, stepOther);
    }

    @Test
    public void stepMetaXmlConsistency() throws Exception {
        StepMeta meta = new StepMeta("id", "name", null);
        MissingTrans smi = new MissingTrans(meta.getName(), meta.getStepID());
        meta.setStepMetaInterface((StepMetaInterface)smi);
        StepMeta fromXml = StepMeta.fromXml((String)meta.getXML());
        Assert.assertThat((Object)meta.getXML(), (Matcher)CoreMatchers.is((Object)fromXml.getXML()));
    }

    private static StepMeta createTestMeta() throws Exception {
        StepMetaInterface stepMetaInterface = (StepMetaInterface)Mockito.mock(AbstractStepMeta.class);
        Mockito.when((Object)stepMetaInterface.clone()).thenReturn((Object)stepMetaInterface);
        StepMeta meta = new StepMeta(STEP_ID, "stepname", stepMetaInterface);
        meta.setSelected(true);
        meta.setDistributes(false);
        meta.setCopiesString("2");
        meta.setLocation(1, 2);
        meta.setDraw(true);
        meta.setDescription("description");
        meta.setTerminator(true);
        meta.setClusterSchemaName("clusterSchemaName");
        boolean shouldDistribute = rand.nextBoolean();
        meta.setDistributes(shouldDistribute);
        if (shouldDistribute) {
            meta.setRowDistribution(StepMetaTest.selectRowDistribution());
        }
        HashMap attributes = new HashMap();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("1", "1");
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("2", "2");
        attributes.put("qwerty", map1);
        attributes.put("asdfg", map2);
        meta.setAttributesMap(attributes);
        meta.setStepPartitioningMeta(StepMetaTest.createStepPartitioningMeta("stepMethod", "stepSchema"));
        meta.setTargetStepPartitioningMeta(StepMetaTest.createStepPartitioningMeta("targetMethod", "targetSchema"));
        meta.setClusterSchema(new ClusterSchema("cluster_schema", Collections.emptyList()));
        return meta;
    }

    private static RowDistributionInterface selectRowDistribution() {
        return new FakeRowDistribution();
    }

    private static StepPartitioningMeta createStepPartitioningMeta(String method, String schemaName) throws Exception {
        StepPartitioningMeta meta = new StepPartitioningMeta(method, new PartitionSchema(schemaName, Collections.emptyList()));
        meta.setPartitionSchemaName("schema_name");
        return meta;
    }

    private static void assertEquals(StepMeta meta, StepMeta another) {
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)meta, (Object)another, (boolean)false, StepMeta.class, (String[])new String[]{"location", "targetStepPartitioningMeta"}));
        boolean manualCheck = new EqualsBuilder().append(meta.getLocation().x, another.getLocation().x).append(meta.getLocation().y, another.getLocation().y).isEquals();
        Assert.assertTrue((boolean)manualCheck);
    }
}

