/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;

public class BaseStepMetaCloningTest {
    @Test
    public void testClone() throws Exception {
        Database db1 = (Database)Mockito.mock(Database.class);
        Database db2 = (Database)Mockito.mock(Database.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        BaseStepMeta meta = new BaseStepMeta();
        meta.setChanged(true);
        meta.databases = new Database[]{db1, db2};
        StepIOMeta ioMeta = new StepIOMeta(true, false, false, false, false, false);
        meta.setStepIOMeta((StepIOMetaInterface)ioMeta);
        meta.repository = repository;
        meta.parentStepMeta = stepMeta;
        BaseStepMeta clone = (BaseStepMeta)meta.clone();
        Assert.assertTrue((boolean)clone.hasChanged());
        Assert.assertTrue((clone.databases == meta.databases ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])meta.databases, (Object[])clone.databases);
        Assert.assertEquals((Object)meta.repository, (Object)clone.repository);
        Assert.assertEquals((Object)meta.parentStepMeta, (Object)clone.parentStepMeta);
        StepIOMetaInterface cloneIOMeta = clone.getStepIOMeta();
        Assert.assertNotNull((Object)cloneIOMeta);
        Assert.assertEquals((Object)ioMeta.isInputAcceptor(), (Object)cloneIOMeta.isInputAcceptor());
        Assert.assertEquals((Object)ioMeta.isInputDynamic(), (Object)cloneIOMeta.isInputDynamic());
        Assert.assertEquals((Object)ioMeta.isInputOptional(), (Object)cloneIOMeta.isInputOptional());
        Assert.assertEquals((Object)ioMeta.isOutputDynamic(), (Object)cloneIOMeta.isOutputDynamic());
        Assert.assertEquals((Object)ioMeta.isOutputProducer(), (Object)cloneIOMeta.isOutputProducer());
        Assert.assertEquals((Object)ioMeta.isSortedDataRequired(), (Object)cloneIOMeta.isSortedDataRequired());
        Assert.assertNotNull((Object)cloneIOMeta.getInfoStreams());
        Assert.assertEquals((long)0L, (long)cloneIOMeta.getInfoStreams().size());
    }

    @Test
    public void testCloneWithInfoSteps() throws Exception {
        Database db1 = (Database)Mockito.mock(Database.class);
        Database db2 = (Database)Mockito.mock(Database.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        BaseStepMeta meta = new BaseStepMeta();
        meta.setChanged(true);
        meta.databases = new Database[]{db1, db2};
        StepIOMeta ioMeta = new StepIOMeta(true, false, false, false, false, false);
        meta.setStepIOMeta((StepIOMetaInterface)ioMeta);
        String refStepName = "referenced step";
        StepMeta refStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        ((StepMeta)Mockito.doReturn((Object)"referenced step").when((Object)refStepMeta)).getName();
        Stream stream = new Stream(StreamInterface.StreamType.INFO, refStepMeta, null, null, (Object)"referenced step");
        ioMeta.addStream((StreamInterface)stream);
        meta.repository = repository;
        meta.parentStepMeta = stepMeta;
        BaseStepMeta clone = (BaseStepMeta)meta.clone();
        Assert.assertTrue((boolean)clone.hasChanged());
        Assert.assertTrue((clone.databases == meta.databases ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])meta.databases, (Object[])clone.databases);
        Assert.assertEquals((Object)meta.repository, (Object)clone.repository);
        Assert.assertEquals((Object)meta.parentStepMeta, (Object)clone.parentStepMeta);
        StepIOMetaInterface cloneIOMeta = clone.getStepIOMeta();
        Assert.assertNotNull((Object)cloneIOMeta);
        Assert.assertEquals((Object)ioMeta.isInputAcceptor(), (Object)cloneIOMeta.isInputAcceptor());
        Assert.assertEquals((Object)ioMeta.isInputDynamic(), (Object)cloneIOMeta.isInputDynamic());
        Assert.assertEquals((Object)ioMeta.isInputOptional(), (Object)cloneIOMeta.isInputOptional());
        Assert.assertEquals((Object)ioMeta.isOutputDynamic(), (Object)cloneIOMeta.isOutputDynamic());
        Assert.assertEquals((Object)ioMeta.isOutputProducer(), (Object)cloneIOMeta.isOutputProducer());
        Assert.assertEquals((Object)ioMeta.isSortedDataRequired(), (Object)cloneIOMeta.isSortedDataRequired());
        List clonedInfoStreams = cloneIOMeta.getInfoStreams();
        Assert.assertNotNull((Object)clonedInfoStreams);
        Assert.assertEquals((long)1L, (long)clonedInfoStreams.size());
        StreamInterface clonedStream = (StreamInterface)clonedInfoStreams.get(0);
        Assert.assertNotSame((Object)stream, (Object)clonedStream);
        Assert.assertEquals((Object)stream.getStreamType(), (Object)clonedStream.getStreamType());
        Assert.assertEquals((Object)"referenced step", (Object)clonedStream.getStepname());
        Assert.assertSame((Object)refStepMeta, (Object)clonedStream.getStepMeta());
    }
}

