/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.cluster;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogChannelInterfaceFactory;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransMetaFactory;
import org.pentaho.di.trans.TransMetaFactoryImpl;
import org.pentaho.di.trans.cluster.TransSplitter;
import org.w3c.dom.Node;

public class TransSplitterTest {
    private LogChannelInterfaceFactory oldLogChannelInterfaceFactory;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUp() throws Exception {
        LogChannelInterfaceFactory logChannelInterfaceFactory = (LogChannelInterfaceFactory)Mockito.mock(LogChannelInterfaceFactory.class);
        LogChannelInterface logChannelInterface = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        this.oldLogChannelInterfaceFactory = KettleLogStore.getLogChannelInterfaceFactory();
        KettleLogStore.setLogChannelInterfaceFactory((LogChannelInterfaceFactory)logChannelInterfaceFactory);
        Mockito.when((Object)logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)logChannelInterface);
    }

    @After
    public void tearDown() {
        KettleLogStore.setLogChannelInterfaceFactory((LogChannelInterfaceFactory)this.oldLogChannelInterfaceFactory);
    }

    @Test
    public void testTransSplitterReadsRep() throws KettleException {
        TransMeta meta = (TransMeta)Mockito.mock(TransMeta.class);
        Repository rep = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)meta.getRepository()).thenReturn((Object)rep);
        TransMeta meta2 = (TransMeta)Mockito.mock(TransMeta.class);
        TransMetaFactory factory = (TransMetaFactory)Mockito.mock(TransMetaFactory.class);
        Mockito.when((Object)factory.create((Node)Matchers.any(Node.class), (Repository)Matchers.any(Repository.class))).thenReturn((Object)meta2);
        Mockito.when((Object)meta.getXML()).thenReturn((Object)"<transformation></transformation>");
        try {
            new TransSplitter(meta, factory);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Repository)Mockito.verify((Object)rep, (VerificationMode)Mockito.times((int)1))).readTransSharedObjects(meta2);
    }

    @Test
    public void testTransSplitterRowsetSize() throws KettleException {
        TransMeta originalMeta = new TransMeta();
        originalMeta.setSizeRowset(0);
        TransMetaFactoryImpl factory = new TransMetaFactoryImpl();
        try {
            TransSplitter transSplitter = new TransSplitter(originalMeta, (TransMetaFactory)factory);
            transSplitter.splitOriginalTransformation();
            Assert.assertEquals((long)originalMeta.getSizeRowset(), (long)transSplitter.getMaster().getSizeRowset());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

