/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.websocket;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogChannelInterfaceFactory;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.engine.api.remote.StopMessage;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.ael.websocket.DaemonMessagesClientEndpoint;
import org.pentaho.di.trans.ael.websocket.TransWebSocketEngineAdapter;
import org.pentaho.di.trans.step.StepMetaDataCombi;

public class TransWebSocketEngineAdapterTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private LogChannelInterfaceFactory logChannelFactory = (LogChannelInterfaceFactory)Mockito.mock(LogChannelInterfaceFactory.class);
    private LogChannelInterface logChannel = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);

    @BeforeClass
    public static void init() throws Exception {
        KettleClientEnvironment.init();
        PluginRegistry.addPluginType((PluginTypeInterface)StepPluginType.getInstance());
        PluginRegistry.init();
        if (!Props.isInitialized()) {
            Props.init((int)0);
        }
    }

    @Before
    public void setUp() throws Exception {
        KettleLogStore.setLogChannelInterfaceFactory((LogChannelInterfaceFactory)this.logChannelFactory);
        Mockito.when((Object)this.logChannelFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any())).thenReturn((Object)this.logChannel);
    }

    @Test
    public void testOpsIncludeSubTrans() throws Exception {
        TransMeta transMeta = new TransMeta(this.getClass().getResource("grid-to-subtrans.ktr").getPath());
        TransWebSocketEngineAdapter adapter = new TransWebSocketEngineAdapter(transMeta, "", "", false);
        adapter.prepareExecution(new String[0]);
        List steps = adapter.getSteps();
        steps.sort(Comparator.comparing(s -> s.stepname));
        Assert.assertEquals((long)2L, (long)steps.size());
        Assert.assertEquals((long)0L, (long)((StepMetaDataCombi)steps.get((int)0)).step.subStatuses().size());
        Assert.assertEquals((long)2L, (long)((StepMetaDataCombi)steps.get((int)1)).step.subStatuses().size());
    }

    @Test
    public void testSafeStopStaysRunningUntilStopped() throws Exception {
        TransMeta transMeta = new TransMeta(this.getClass().getResource("grid-to-subtrans.ktr").getPath());
        final DaemonMessagesClientEndpoint daemonEndpoint = (DaemonMessagesClientEndpoint)Mockito.mock(DaemonMessagesClientEndpoint.class);
        final CountDownLatch latch = new CountDownLatch(1);
        TransWebSocketEngineAdapter adapter = new TransWebSocketEngineAdapter(transMeta, "", "", false){

            DaemonMessagesClientEndpoint getDaemonEndpoint() throws KettleException {
                return daemonEndpoint;
            }

            public void waitUntilFinished() {
                try {
                    latch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        adapter.prepareExecution(new String[0]);
        adapter.getSteps().stream().map(stepMetaDataCombi -> stepMetaDataCombi.step).forEach(step -> step.setRunning(true));
        adapter.safeStop();
        StopMessage.builder().reasonPhrase("User Request").safeStop(true).build();
        ((DaemonMessagesClientEndpoint)Mockito.verify((Object)daemonEndpoint)).sendMessage((StopMessage)Matchers.argThat(this.matchesSafeStop()));
        List steps = adapter.getSteps();
        steps.stream().map(s -> s.step).forEach(step -> Assert.assertEquals((Object)"Halting", (Object)step.getStatus().getDescription()));
        latch.countDown();
    }

    private Matcher<StopMessage> matchesSafeStop() {
        return new BaseMatcher<StopMessage>(){

            public boolean matches(Object o) {
                return ((StopMessage)o).isSafeStop();
            }

            public void describeTo(Description description) {
            }
        };
    }
}

