/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.websocket;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.remote.Message;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.ael.websocket.MessageEventService;
import org.pentaho.di.trans.ael.websocket.StepInterfaceWebSocketEngineAdapter;
import org.pentaho.di.trans.ael.websocket.Util;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;

@RunWith(value=MockitoJUnitRunner.class)
public class StepInterfaceWebSocketEngineAdapterTest {
    @Mock
    private Operation op;
    private MessageEventService messageEventService;
    @Mock
    private StepMeta stepMeta;
    @Mock
    private TransMeta transMeta;
    @Mock
    private StepDataInterface dataInterface;
    @Mock
    private Trans tran;

    @Before
    public void before() throws KettleException {
        Mockito.when((Object)this.stepMeta.getName()).thenReturn((Object)"foo");
        Mockito.when((Object)this.op.getId()).thenReturn((Object)"Operation ID");
        this.messageEventService = new MessageEventService();
    }

    @Test
    public void testHandlerCreation() throws KettleException {
        new StepInterfaceWebSocketEngineAdapter(this.op, this.messageEventService, this.stepMeta, this.transMeta, this.dataInterface, this.tran, Collections.emptyList());
        Assert.assertTrue((boolean)this.messageEventService.hasHandlers((Message)Util.getOperationRowEvent((String)this.op.getId())));
        Assert.assertTrue((boolean)this.messageEventService.hasHandlers((Message)Util.getOperationStatusEvent((String)this.op.getId())));
        Assert.assertTrue((boolean)this.messageEventService.hasHandlers((Message)Util.getMetricEvents((String)this.op.getId())));
        Assert.assertTrue((this.messageEventService.getHandlersFor((Message)Util.getOperationRowEvent((String)this.op.getId())).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.messageEventService.getHandlersFor((Message)Util.getOperationStatusEvent((String)this.op.getId())).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.messageEventService.getHandlersFor((Message)Util.getMetricEvents((String)this.op.getId())).size() == 1 ? 1 : 0) != 0);
    }
}

