/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.websocket;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.ael.websocket.DaemonMessagesClientEndpoint;
import org.pentaho.di.trans.ael.websocket.SessionConfigurator;

@RunWith(value=MockitoJUnitRunner.class)
public class SessionConfiguratorTest {
    private SessionConfigurator sessionConfigurator;
    @Mock
    private Map<String, List<String>> headers;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testNoAuthentication() throws URISyntaxException {
        this.sessionConfigurator = new SessionConfigurator(new URI("ws://test:8080/execute"), null, null);
        this.sessionConfigurator.beforeRequest(this.headers);
        ((Map)Mockito.verify(this.headers, (VerificationMode)Mockito.times((int)0))).put(Matchers.any(), Matchers.any());
    }

    @Test
    public void testPrincipal() throws URISyntaxException, RuntimeException {
        this.sessionConfigurator = new SessionConfigurator(new URI("ws://test:8080/execute"), null, "testPrincipal");
        this.expectedException.expect(RuntimeException.class);
        this.sessionConfigurator.beforeRequest(this.headers);
    }

    @Test
    public void testPrincipalKeytab() throws URISyntaxException, RuntimeException {
        this.sessionConfigurator = new SessionConfigurator(new URI("ws://test:8080/execute"), "filepath.keytab", "testPrincipal");
        this.expectedException.expect(RuntimeException.class);
        this.sessionConfigurator.beforeRequest(this.headers);
    }

    @Test
    public void testDaemonNoAuthentication() throws KettleException {
        this.expectedException.expect(KettleException.class);
        new DaemonMessagesClientEndpoint("host", "8080", true, null);
    }

    @Test
    public void testDaemonWithAuthentication() throws KettleException {
        System.getProperties().setProperty("KETTLE_AEL_PDI_DAEMON_PRINCIPAL", "principal");
        System.getProperties().setProperty("KETTLE_AEL_PDI_DAEMON_KEYTAB", "filepath.keytab");
        this.expectedException.expect(KettleException.class);
        new DaemonMessagesClientEndpoint("host", "8080", true, null);
    }
}

