/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.websocket;

import java.util.Date;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.engine.api.events.LogEvent;
import org.pentaho.di.engine.api.events.MetricsEvent;
import org.pentaho.di.engine.api.events.StatusEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.model.ModelType;
import org.pentaho.di.engine.api.remote.Message;
import org.pentaho.di.engine.api.remote.RemoteSource;
import org.pentaho.di.engine.api.remote.StopMessage;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.LogLevel;
import org.pentaho.di.trans.ael.websocket.MessageEventService;
import org.pentaho.di.trans.ael.websocket.Util;
import org.pentaho.di.trans.ael.websocket.exception.HandlerRegistrationException;
import org.pentaho.di.trans.ael.websocket.exception.MessageEventFireEventException;
import org.pentaho.di.trans.ael.websocket.handler.MessageEventHandler;

@RunWith(value=MockitoJUnitRunner.class)
public class MessageEventServiceTest {
    private LogEvent transformationMessageEvent;
    private LogEvent operationMessageEvent;
    private MetricsEvent otherOpMessageEvent;
    private StatusEvent otherTransMessageEvent;
    @Mock
    private MessageEventHandler messageEventHandler;
    @Mock
    private MessageEventHandler messageEventHandler2;
    @Mock
    private LogEntry logEntry;
    private MessageEventService messageEventService;

    @Before
    public void before() {
        this.messageEventService = new MessageEventService();
        ((MessageEventHandler)Mockito.doReturn((Object)"Handler_ID").when((Object)this.messageEventHandler)).getIdentifier();
        ((MessageEventHandler)Mockito.doReturn((Object)"Handler_ID2").when((Object)this.messageEventHandler2)).getIdentifier();
        this.transformationMessageEvent = Util.getTransformationLogEvent();
        this.operationMessageEvent = Util.getOperationLogEvent((String)"Operation_ID");
        this.otherOpMessageEvent = Util.getMetricEvents((String)"Metrics_ID");
        this.otherTransMessageEvent = Util.getTransformationStatusEvent();
        ((LogEntry)Mockito.doReturn((Object)"message").when((Object)this.logEntry)).getMessage();
        ((LogEntry)Mockito.doReturn((Object)LogLevel.ERROR).when((Object)this.logEntry)).getLogLogLevel();
        ((LogEntry)Mockito.doReturn((Object)new Date()).when((Object)this.logEntry)).getTimestamp();
    }

    @Test
    public void testTranformationAddHandler() throws KettleException {
        this.messageEventService.addHandler((Message)this.transformationMessageEvent, this.messageEventHandler);
        Assert.assertTrue((this.messageEventService.getHandlersFor((Message)this.transformationMessageEvent).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.messageEventHandler.getIdentifier().equals(((MessageEventHandler)this.messageEventService.getHandlersFor((Message)this.transformationMessageEvent).get(0)).getIdentifier()));
    }

    @Test(expected=HandlerRegistrationException.class)
    public void testTranformationDuplicateAddHandler() throws KettleException {
        this.messageEventService.addHandler((Message)this.transformationMessageEvent, this.messageEventHandler);
        this.messageEventService.addHandler((Message)this.transformationMessageEvent, this.messageEventHandler);
    }

    @Test
    public void testTranformationAddDiffHandlersForSameEvent() throws KettleException {
        this.testAddDiffHandlersForSameEvent((Message)this.transformationMessageEvent, this.messageEventHandler, this.messageEventHandler2);
    }

    @Test
    public void testTransformationHasHandler() throws KettleException {
        this.addHandlers((Message)this.transformationMessageEvent, this.messageEventHandler, this.messageEventHandler2);
        Assert.assertTrue((boolean)this.messageEventService.hasHandlers((Message)this.transformationMessageEvent));
    }

    @Test
    public void testTransformationHasHandlerFalseTrans() throws KettleException {
        this.addHandlers((Message)this.transformationMessageEvent, this.messageEventHandler, this.messageEventHandler2);
        Assert.assertFalse((boolean)this.messageEventService.hasHandlers((Message)this.otherTransMessageEvent));
    }

    @Test
    public void testTransformationHasHandlerFalseOp() throws KettleException {
        this.addHandlers((Message)this.transformationMessageEvent, this.messageEventHandler, this.messageEventHandler2);
        Assert.assertFalse((boolean)this.messageEventService.hasHandlers((Message)this.otherOpMessageEvent));
    }

    @Test
    public void testOperationAddHandler() throws KettleException {
        this.messageEventService.addHandler((Message)this.operationMessageEvent, this.messageEventHandler);
        Assert.assertTrue((this.messageEventService.getHandlersFor((Message)this.operationMessageEvent).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.messageEventHandler.getIdentifier().equals(((MessageEventHandler)this.messageEventService.getHandlersFor((Message)this.operationMessageEvent).get(0)).getIdentifier()));
    }

    @Test(expected=HandlerRegistrationException.class)
    public void testOperationDuplicateAddHandler() throws KettleException {
        this.messageEventService.addHandler((Message)this.operationMessageEvent, this.messageEventHandler);
        this.messageEventService.addHandler((Message)this.operationMessageEvent, this.messageEventHandler);
    }

    @Test
    public void testOperationAddDiffHandlersForSameEvent() throws KettleException {
        this.testAddDiffHandlersForSameEvent((Message)this.operationMessageEvent, this.messageEventHandler, this.messageEventHandler2);
    }

    @Test
    public void testOperationHasHandler() throws KettleException {
        this.addHandlers((Message)this.operationMessageEvent, this.messageEventHandler, this.messageEventHandler2);
        Assert.assertTrue((boolean)this.messageEventService.hasHandlers((Message)this.operationMessageEvent));
    }

    @Test
    public void testOperationHasHandlerFalseTrans() throws KettleException {
        this.addHandlers((Message)this.operationMessageEvent, this.messageEventHandler, this.messageEventHandler2);
        Assert.assertFalse((boolean)this.messageEventService.hasHandlers((Message)this.otherTransMessageEvent));
    }

    @Test
    public void testOperationHasHandlerFalseOp() throws KettleException {
        this.addHandlers((Message)this.operationMessageEvent, this.messageEventHandler, this.messageEventHandler2);
        Assert.assertFalse((boolean)this.messageEventService.hasHandlers((Message)this.otherOpMessageEvent));
    }

    @Test(expected=HandlerRegistrationException.class)
    public void testMsgEventTypeNull() throws KettleException {
        this.messageEventService.addHandler(null, this.messageEventHandler);
    }

    @Test(expected=HandlerRegistrationException.class)
    public void testMsgHandlerNull() throws KettleException {
        this.messageEventService.addHandler((Message)this.operationMessageEvent, null);
    }

    @Test(expected=HandlerRegistrationException.class)
    public void testbothNull() throws KettleException {
        this.messageEventService.addHandler(null, null);
    }

    @Test(expected=MessageEventFireEventException.class)
    public void testFireEventNull() throws KettleException {
        this.messageEventService.fireEvent(null);
    }

    @Test
    public void testOperationFireEvent() throws KettleException {
        this.addHandlers((Message)this.operationMessageEvent, this.messageEventHandler, this.messageEventHandler2);
        LogEvent logEvent = new LogEvent((LogicalModelElement)new RemoteSource(ModelType.OPERATION, "Operation_ID"), this.logEntry);
        this.messageEventService.fireEvent((Message)logEvent);
        ((MessageEventHandler)Mockito.verify((Object)this.messageEventHandler)).execute((Message)logEvent);
        ((MessageEventHandler)Mockito.verify((Object)this.messageEventHandler2)).execute((Message)logEvent);
    }

    @Test(expected=MessageEventFireEventException.class)
    public void testOperationFireEventThrowException() throws KettleException {
        this.addHandlers((Message)this.operationMessageEvent, this.messageEventHandler, this.messageEventHandler2);
        ((MessageEventHandler)Mockito.doThrow((Throwable)new RuntimeException("Test")).when((Object)this.messageEventHandler)).execute((Message)Matchers.any(Message.class));
        LogEvent logEvent = new LogEvent((LogicalModelElement)new RemoteSource(ModelType.OPERATION, "Operation_ID"), this.logEntry);
        this.messageEventService.fireEvent((Message)logEvent);
        ((MessageEventHandler)Mockito.verify((Object)this.messageEventHandler, (VerificationMode)Mockito.never())).execute((Message)logEvent);
        ((MessageEventHandler)Mockito.verify((Object)this.messageEventHandler2)).execute((Message)logEvent);
    }

    @Test
    public void testStopMessageFireEvent() throws KettleException {
        this.addHandlers((Message)new StopMessage(""), this.messageEventHandler, this.messageEventHandler2);
        StopMessage msg = new StopMessage("User request");
        this.messageEventService.fireEvent((Message)msg);
        ((MessageEventHandler)Mockito.verify((Object)this.messageEventHandler)).execute((Message)msg);
        ((MessageEventHandler)Mockito.verify((Object)this.messageEventHandler2)).execute((Message)msg);
    }

    @Test
    public void testTransformationFireEvent() throws Exception {
        this.addHandlers((Message)this.transformationMessageEvent, this.messageEventHandler, this.messageEventHandler2);
        LogEvent logEvent = new LogEvent((LogicalModelElement)new RemoteSource(ModelType.TRANSFORMATION, "Operation_ID"), this.logEntry);
        this.messageEventService.fireEvent((Message)logEvent);
        ((MessageEventHandler)Mockito.verify((Object)this.messageEventHandler)).execute((Message)logEvent);
        ((MessageEventHandler)Mockito.verify((Object)this.messageEventHandler2)).execute((Message)logEvent);
    }

    public void addHandlers(Message messageEvent, MessageEventHandler handler, MessageEventHandler handler2) throws KettleException {
        this.messageEventService.addHandler(messageEvent, handler);
        this.messageEventService.addHandler(messageEvent, handler2);
    }

    private void testAddDiffHandlersForSameEvent(Message messageEvent, MessageEventHandler handler, MessageEventHandler handler2) throws KettleException {
        this.messageEventService.addHandler(messageEvent, handler);
        this.messageEventService.addHandler(messageEvent, handler2);
        Assert.assertTrue((this.messageEventService.getHandlersFor(messageEvent).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.getIdentifier().equals(((MessageEventHandler)this.messageEventService.getHandlersFor(messageEvent).get(0)).getIdentifier()));
        Assert.assertTrue((boolean)handler2.getIdentifier().equals(((MessageEventHandler)this.messageEventService.getHandlersFor(messageEvent).get(1)).getIdentifier()));
    }
}

