/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.adapters;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.engine.api.model.Hop;
import org.pentaho.di.engine.api.model.ModelElement;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.ael.adapters.TransMetaConverter;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@RunWith(value=MockitoJUnitRunner.class)
public class TransMetaConverterTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    @Spy
    StepMetaInterface stepMetaInterface = new DummyTransMeta();
    final String XML = "<xml></xml>";

    @Before
    public void before() throws KettleException {
        Mockito.when((Object)this.stepMetaInterface.getXML()).thenReturn((Object)"<xml></xml>");
    }

    @BeforeClass
    public static void init() throws Exception {
        KettleClientEnvironment.init();
        PluginRegistry.addPluginType((PluginTypeInterface)StepPluginType.getInstance());
        PluginRegistry.init();
        if (!Props.isInitialized()) {
            Props.init((int)0);
        }
    }

    @AfterClass
    public static void cleanUp() {
        KettleClientEnvironment.reset();
    }

    @Test
    public void simpleConvert() {
        TransMeta meta = new TransMeta();
        meta.setFilename("fileName");
        meta.addStep(new StepMeta("stepName", this.stepMetaInterface));
        Transformation trans = TransMetaConverter.convert((TransMeta)meta);
        MatcherAssert.assertThat((Object)trans.getId(), (Matcher)CoreMatchers.is((Object)meta.getFilename()));
        MatcherAssert.assertThat((Object)trans.getOperations().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Operation)trans.getOperations().get(0)).getId(), (Matcher)CoreMatchers.is((Object)"stepName"));
    }

    @Test
    public void transWithHops() {
        TransMeta meta = new TransMeta();
        meta.setFilename("fileName");
        StepMeta from = new StepMeta("step1", this.stepMetaInterface);
        meta.addStep(from);
        StepMeta to = new StepMeta("step2", this.stepMetaInterface);
        meta.addStep(to);
        meta.addTransHop(new TransHopMeta(from, to));
        Transformation trans = TransMetaConverter.convert((TransMeta)meta);
        MatcherAssert.assertThat((Object)trans.getId(), (Matcher)CoreMatchers.is((Object)meta.getFilename()));
        MatcherAssert.assertThat((Object)trans.getOperations().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)trans.getHops().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Hop)trans.getHops().get(0)).getFrom().getId(), (Matcher)CoreMatchers.is((Object)from.getName()));
        MatcherAssert.assertThat((Object)((Hop)trans.getHops().get(0)).getTo().getId(), (Matcher)CoreMatchers.is((Object)to.getName()));
        MatcherAssert.assertThat(trans.getHops().stream().map(Hop::getType).collect(Collectors.toList()), (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.is((Object)"NORMAL")));
    }

    @Test
    public void transIdFromRepo() throws Exception {
        TransMeta meta = new TransMeta();
        meta.setName("transName");
        Transformation trans = TransMetaConverter.convert((TransMeta)meta);
        MatcherAssert.assertThat((Object)trans.getId(), (Matcher)CoreMatchers.is((Object)"/transName"));
    }

    @Test
    public void transConfigItems() throws Exception {
        TransMeta meta = new TransMeta();
        meta.setName("foo");
        Transformation trans = TransMetaConverter.convert((TransMeta)meta);
        MatcherAssert.assertThat(trans.getConfig().get("TransMetaName"), (Matcher)CoreMatchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)((String)trans.getConfig().get("TransMeta")), (Matcher)CoreMatchers.startsWith((String)"<transformation>"));
    }

    @Test
    public void transConfigItemsNoNameSpecified() throws Exception {
        TransMeta meta = new TransMeta();
        Transformation trans = TransMetaConverter.convert((TransMeta)meta);
        MatcherAssert.assertThat(trans.getConfig().get("TransMetaName"), (Matcher)CoreMatchers.is((Object)"No Name"));
        MatcherAssert.assertThat((Object)((String)trans.getConfig().get("TransMeta")), (Matcher)CoreMatchers.startsWith((String)"<transformation>"));
    }

    @Test
    public void testDisabledHops() {
        TransMeta trans = new TransMeta();
        StepMeta start = new StepMeta("Start", this.stepMetaInterface);
        trans.addStep(start);
        StepMeta withEnabledHop = new StepMeta("WithEnabledHop", this.stepMetaInterface);
        trans.addStep(withEnabledHop);
        StepMeta withDisabledHop = new StepMeta("WithDisabledHop", this.stepMetaInterface);
        trans.addStep(withDisabledHop);
        StepMeta shouldStay = new StepMeta("ShouldStay", this.stepMetaInterface);
        trans.addStep(shouldStay);
        StepMeta shouldNotStay = new StepMeta("ShouldNotStay", this.stepMetaInterface);
        trans.addStep(shouldNotStay);
        StepMeta withEnabledAndDisabledHops = new StepMeta("WithEnabledAndDisabledHops", this.stepMetaInterface);
        trans.addStep(withEnabledAndDisabledHops);
        StepMeta afterEnabledDisabled = new StepMeta("AfterEnabledDisabled", this.stepMetaInterface);
        trans.addStep(afterEnabledDisabled);
        trans.addTransHop(new TransHopMeta(start, withEnabledHop));
        trans.addTransHop(new TransHopMeta(start, withDisabledHop, false));
        trans.addTransHop(new TransHopMeta(withEnabledHop, shouldStay));
        trans.addTransHop(new TransHopMeta(withDisabledHop, shouldStay));
        trans.addTransHop(new TransHopMeta(withDisabledHop, shouldNotStay));
        trans.addTransHop(new TransHopMeta(start, withEnabledAndDisabledHops));
        trans.addTransHop(new TransHopMeta(withEnabledHop, withEnabledAndDisabledHops, false));
        trans.addTransHop(new TransHopMeta(withEnabledAndDisabledHops, afterEnabledDisabled));
        Transformation transformation = TransMetaConverter.convert((TransMeta)trans);
        List steps = transformation.getOperations().stream().map(op -> op.getId()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Only 5 ops should exist", (Object)steps.size(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat(steps, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"Start", "WithEnabledHop", "ShouldStay", "WithEnabledAndDisabledHops", "AfterEnabledDisabled"}));
        List hops = transformation.getHops().stream().map(hop -> hop.getId()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Only 4 hops should exist", (Object)hops.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(hops, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"Start -> WithEnabledHop", "WithEnabledHop -> ShouldStay", "Start -> WithEnabledAndDisabledHops", "WithEnabledAndDisabledHops -> AfterEnabledDisabled"}));
    }

    @Test
    public void testRemovingDisabledInputSteps() {
        TransMeta trans = new TransMeta();
        StepMeta inputToBeRemoved = new StepMeta("InputToBeRemoved", this.stepMetaInterface);
        trans.addStep(inputToBeRemoved);
        StepMeta inputToStay = new StepMeta("InputToStay", this.stepMetaInterface);
        trans.addStep(inputToStay);
        StepMeta inputReceiver1 = new StepMeta("InputReceiver1", this.stepMetaInterface);
        trans.addStep(inputReceiver1);
        StepMeta inputReceiver2 = new StepMeta("InputReceiver2", this.stepMetaInterface);
        trans.addStep(inputReceiver2);
        TransHopMeta hop1 = new TransHopMeta(inputToBeRemoved, inputReceiver1, false);
        TransHopMeta hop2 = new TransHopMeta(inputToStay, inputReceiver1);
        TransHopMeta hop3 = new TransHopMeta(inputToBeRemoved, inputReceiver2, false);
        trans.addTransHop(hop1);
        trans.addTransHop(hop2);
        trans.addTransHop(hop3);
        Transformation transformation = TransMetaConverter.convert((TransMeta)trans);
        List steps = transformation.getOperations().stream().map(op -> op.getId()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Only 2 ops should exist", (Object)steps.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(steps, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"InputToStay", "InputReceiver1"}));
        List hops = transformation.getHops().stream().map(hop -> hop.getId()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Only 1 hop should exist", (Object)hops.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(hops, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"InputToStay -> InputReceiver1"}));
    }

    @Test
    public void testMultipleDisabledHops() {
        TransMeta trans = new TransMeta();
        StepMeta input = new StepMeta("Input", this.stepMetaInterface);
        trans.addStep(input);
        StepMeta step1 = new StepMeta("Step1", this.stepMetaInterface);
        trans.addStep(step1);
        StepMeta step2 = new StepMeta("Step2", this.stepMetaInterface);
        trans.addStep(step2);
        StepMeta step3 = new StepMeta("Step3", this.stepMetaInterface);
        trans.addStep(step3);
        TransHopMeta hop1 = new TransHopMeta(input, step1, false);
        TransHopMeta hop2 = new TransHopMeta(step1, step2, false);
        TransHopMeta hop3 = new TransHopMeta(step2, step3, false);
        trans.addTransHop(hop1);
        trans.addTransHop(hop2);
        trans.addTransHop(hop3);
        Transformation transformation = TransMetaConverter.convert((TransMeta)trans);
        MatcherAssert.assertThat((String)"Trans has steps though all of them should be removed", (Object)transformation.getOperations().size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((String)"Trans has hops though all of them should be removed", (Object)transformation.getHops().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void errorHops() throws Exception {
        TransMeta meta = new TransMeta();
        meta.setFilename("fileName");
        StepMeta from = new StepMeta("step1", this.stepMetaInterface);
        meta.addStep(from);
        StepMeta to = new StepMeta("step2", this.stepMetaInterface);
        meta.addStep(to);
        meta.addTransHop(new TransHopMeta(from, to));
        StepMeta error = new StepMeta("errorHandler", this.stepMetaInterface);
        meta.addStep(error);
        TransHopMeta errorHop = new TransHopMeta(from, error);
        errorHop.setErrorHop(true);
        meta.addTransHop(errorHop);
        Transformation trans = TransMetaConverter.convert((TransMeta)meta);
        Map<String, List<Hop>> hops = trans.getHops().stream().collect(Collectors.groupingBy(Hop::getType));
        List<Hop> normalHops = hops.get("NORMAL");
        MatcherAssert.assertThat((Object)normalHops.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)normalHops.get(0).getTo().getId(), (Matcher)CoreMatchers.is((Object)"step2"));
        List<Hop> errorHops = hops.get("ERROR");
        MatcherAssert.assertThat((Object)errorHops.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)errorHops.get(0).getTo().getId(), (Matcher)CoreMatchers.is((Object)"errorHandler"));
        MatcherAssert.assertThat(hops.values().stream().flatMap(Collection::stream).map(Hop::getFrom).map(ModelElement::getId).collect(Collectors.toList()), (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.equalTo((Object)"step1")));
    }

    @Test
    public void lazyConversionTurnedOff() throws KettleException {
        TransMeta cloneMeta;
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        CsvInputMeta csvInputMeta = new CsvInputMeta();
        csvInputMeta.setLazyConversionActive(true);
        StepMeta csvInput = new StepMeta("Csv", (StepMetaInterface)csvInputMeta);
        transMeta.addStep(csvInput);
        TableInputMeta tableInputMeta = new TableInputMeta();
        tableInputMeta.setLazyConversionActive(true);
        StepMeta tableInput = new StepMeta("Table", (StepMetaInterface)tableInputMeta);
        transMeta.addStep(tableInput);
        Transformation trans = TransMetaConverter.convert((TransMeta)transMeta);
        String transMetaXml = (String)trans.getConfig().get("TransMeta");
        try {
            Document doc = XMLHandler.loadXMLString((String)transMetaXml);
            Node stepNode = XMLHandler.getSubNode((Node)doc, (String)"transformation");
            cloneMeta = new TransMeta(stepNode, null);
        }
        catch (KettleMissingPluginsException | KettleXMLException e) {
            throw new RuntimeException(e);
        }
        MatcherAssert.assertThat((Object)((CsvInputMeta)cloneMeta.findStep("Csv").getStepMetaInterface()).isLazyConversionActive(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((TableInputMeta)cloneMeta.findStep("Table").getStepMetaInterface()).isLazyConversionActive(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIncludesSubTransformations() throws Exception {
        TransMeta parentTransMeta = new TransMeta(this.getClass().getResource("trans-meta-converter-parent.ktr").getPath());
        Transformation transformation = TransMetaConverter.convert((TransMeta)parentTransMeta);
        HashMap config = (HashMap)transformation.getConfig("SubTransformations").get();
        Assert.assertEquals((long)1L, (long)config.size());
        Assert.assertNotNull(config.get("file://" + this.getClass().getResource("trans-meta-converter-sub.ktr").getPath()));
    }

    @Test
    public void testIncludesSubTransformationsFromRepository() throws Exception {
        TransMeta parentTransMeta = new TransMeta(this.getClass().getResource("trans-meta-converter-parent.ktr").getPath());
        Repository repository = (Repository)Mockito.mock(Repository.class);
        TransMeta transMeta = new TransMeta();
        RepositoryDirectory repositoryDirectory = new RepositoryDirectory(null, "public");
        String directory = this.getClass().getResource("").toString().replace(File.separator, "/");
        Mockito.when((Object)repository.findDirectory("public")).thenReturn((Object)repositoryDirectory);
        Mockito.when((Object)repository.loadTransformation("trans-meta-converter-sub.ktr", (RepositoryDirectoryInterface)repositoryDirectory, null, true, null)).thenReturn((Object)transMeta);
        parentTransMeta.setRepository(repository);
        parentTransMeta.setRepositoryDirectory((RepositoryDirectoryInterface)repositoryDirectory);
        parentTransMeta.setVariable("Internal.Entry.Current.Directory", "public");
        Transformation transformation = TransMetaConverter.convert((TransMeta)parentTransMeta);
        HashMap config = (HashMap)transformation.getConfig("SubTransformations").get();
        Assert.assertEquals((long)1L, (long)config.size());
        Assert.assertNotNull(config.get("public/trans-meta-converter-sub.ktr"));
    }

    @Test
    public void testClonesTransMeta() throws KettleException {
        TransMeta originalTransMeta = (TransMeta)Mockito.spy((Object)new TransMeta());
        class ResultCaptor
        implements Answer<Object> {
            private Object result;

            ResultCaptor() {
            }

            public Object getResult() {
                return this.result;
            }

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                this.result = invocationOnMock.callRealMethod();
                return this.result;
            }
        }
        ResultCaptor cloneTransMetaCaptor = new ResultCaptor();
        ((TransMeta)Mockito.doAnswer((Answer)cloneTransMetaCaptor).when((Object)originalTransMeta)).realClone(Matchers.eq((boolean)false));
        originalTransMeta.setName("TransName");
        TransMetaConverter.convert((TransMeta)originalTransMeta);
        TransMeta cloneTransMeta = (TransMeta)cloneTransMetaCaptor.getResult();
        ((TransMeta)Mockito.verify((Object)originalTransMeta)).realClone(Matchers.eq((boolean)false));
        MatcherAssert.assertThat((Object)cloneTransMeta.getName(), (Matcher)CoreMatchers.is((Object)originalTransMeta.getName()));
        ((TransMeta)Mockito.verify((Object)originalTransMeta, (VerificationMode)Mockito.never())).getXML();
        ((TransMeta)Mockito.verify((Object)cloneTransMeta)).getXML();
    }

    @Test
    public void testResolveStepMetaResources() throws KettleException, MetaStoreException {
        Variables variables = new Variables();
        TransMeta transMeta = (TransMeta)Mockito.spy((Object)new TransMeta());
        transMeta.setParentVariableSpace((VariableSpace)variables);
        ((TransMeta)Mockito.doReturn((Object)transMeta).when((Object)transMeta)).realClone(false);
        TestMetaResolvableResource testMetaResolvableResource = (TestMetaResolvableResource)((Object)Mockito.spy((Object)((Object)new TestMetaResolvableResource())));
        TestMetaResolvableResource testMetaResolvableResourceTwo = (TestMetaResolvableResource)((Object)Mockito.spy((Object)((Object)new TestMetaResolvableResource())));
        StepMeta testMeta = new StepMeta("TestMeta", (StepMetaInterface)testMetaResolvableResource);
        StepMeta testMetaTwo = new StepMeta("TestMeta2", (StepMetaInterface)testMetaResolvableResourceTwo);
        transMeta.addStep(testMeta);
        transMeta.addStep(testMetaTwo);
        transMeta.addTransHop(new TransHopMeta(testMeta, testMetaTwo));
        TransMetaConverter.convert((TransMeta)transMeta);
        ((TestMetaResolvableResource)((Object)Mockito.verify((Object)((Object)testMetaResolvableResource)))).resolve();
        ((TestMetaResolvableResource)((Object)Mockito.verify((Object)((Object)testMetaResolvableResourceTwo)))).resolve();
    }

    private static class TestMetaResolvableResource
    extends BaseStepMeta
    implements StepMetaInterface,
    ResolvableResource {
        private TestMetaResolvableResource() {
        }

        public void resolve() {
        }

        public void setDefault() {
        }

        public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            return null;
        }

        public StepDataInterface getStepData() {
            return null;
        }
    }
}

