/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;

public class TransTestingUtil {
    public static List<Object[]> execute(BaseStep step, StepMetaInterface meta, StepDataInterface data, int expectedRowsAmount, boolean checkIsDone) throws Exception {
        int i;
        BlockingRowSet output = new BlockingRowSet(Math.max(1, expectedRowsAmount));
        step.setOutputRowSets(Collections.singletonList(output));
        ArrayList<Object[]> result = new ArrayList<Object[]>(expectedRowsAmount);
        for (i = 0; step.processRow(meta, data) && i < expectedRowsAmount; ++i) {
            Object[] row = output.getRowImmediate();
            Assert.assertNotNull((String)Integer.toString(i), (Object)row);
            result.add(row);
        }
        Assert.assertEquals((String)"The amount of executions should be equal to expected", (long)expectedRowsAmount, (long)i);
        if (checkIsDone) {
            Assert.assertTrue((boolean)output.isDone());
        }
        return result;
    }

    public static void assertResult(Object[] expectedRow, Object[] actualRow) {
        TransTestingUtil.assertRow(0, expectedRow, actualRow);
    }

    public static void assertResult(List<Object[]> expected, List<Object[]> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Object[] expectedRow = expected.get(i);
            Object[] actualRow = actual.get(i);
            TransTestingUtil.assertRow(i, expectedRow, actualRow);
        }
    }

    private static void assertRow(int index, Object[] expected, Object[] actual) {
        int i;
        boolean sizeCondition;
        Assert.assertNotNull((Object)actual);
        boolean bl = sizeCondition = expected.length <= actual.length;
        if (!sizeCondition) {
            Assert.fail((String)String.format("Row [%d]: expected.length=[%d]; actual.length=[%d]", index, expected.length, actual.length));
        }
        for (i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)String.format("[%d][%d]", index, i), (Object)expected[i], (Object)actual[i]);
        }
        while (i < actual.length) {
            Assert.assertNull((Object)actual[i]);
            ++i;
        }
    }
}

