/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;

public class TransTestFactory {
    public static final String INJECTOR_STEPNAME = "injector";
    public static final String DUMMY_STEPNAME = "dummy";
    public static final String ERROR_STEPNAME = "dummyError";
    public static final String NUMBER_ERRORS_FIELD = "NumberErrors";
    public static final String ERROR_DESC_FIELD = "ErrorDescription";
    public static final String ERROR_FIELD_VALUE = "ErrorFieldValue";
    public static final String ERROR_CODE_VALUE = "ErrorCodeValue";
    static PluginRegistry registry = PluginRegistry.getInstance();

    public static TransMeta generateTestTransformation(VariableSpace parent, StepMetaInterface oneMeta, String oneStepname) {
        return TransTestFactory.generateTestTransformation(parent, oneMeta, oneStepname, null);
    }

    public static TransMeta generateTestTransformation(VariableSpace parent, StepMetaInterface oneMeta, String oneStepname, RowMetaInterface injectorRowMeta) {
        TransMeta previewMeta = new TransMeta(parent);
        StepMeta zero = TransTestFactory.getInjectorStepMeta(injectorRowMeta);
        previewMeta.addStep(zero);
        StepMeta one = new StepMeta(registry.getPluginId(StepPluginType.class, (Object)oneMeta), oneStepname, oneMeta);
        one.setLocation(150, 50);
        one.setDraw(true);
        previewMeta.addStep(one);
        StepMeta two = TransTestFactory.getReadStepMeta();
        previewMeta.addStep(two);
        TransHopMeta zeroOne = new TransHopMeta(zero, one);
        previewMeta.addTransHop(zeroOne);
        TransHopMeta oneTwo = new TransHopMeta(one, two);
        previewMeta.addTransHop(oneTwo);
        return previewMeta;
    }

    public static TransMeta generateTestTransformationError(VariableSpace parent, StepMetaInterface oneMeta, String oneStepname) {
        TransMeta previewMeta = new TransMeta(parent);
        if (parent == null) {
            parent = new Variables();
        }
        StepMeta zero = TransTestFactory.getInjectorStepMeta();
        previewMeta.addStep(zero);
        StepMeta one = new StepMeta(registry.getPluginId(StepPluginType.class, (Object)oneMeta), oneStepname, oneMeta);
        one.setLocation(150, 50);
        one.setDraw(true);
        previewMeta.addStep(one);
        StepMeta two = TransTestFactory.getReadStepMeta();
        previewMeta.addStep(two);
        StepMeta err = TransTestFactory.getReadStepMeta(ERROR_STEPNAME);
        previewMeta.addStep(err);
        TransHopMeta zeroOne = new TransHopMeta(zero, one);
        previewMeta.addTransHop(zeroOne);
        TransHopMeta oneTwo = new TransHopMeta(one, two);
        previewMeta.addTransHop(oneTwo);
        StepErrorMeta errMeta = new StepErrorMeta(parent, one, err);
        errMeta.setEnabled(true);
        errMeta.setNrErrorsValuename(NUMBER_ERRORS_FIELD);
        errMeta.setErrorDescriptionsValuename(ERROR_DESC_FIELD);
        errMeta.setErrorFieldsValuename(ERROR_FIELD_VALUE);
        errMeta.setErrorCodesValuename(ERROR_CODE_VALUE);
        one.setStepErrorMeta(errMeta);
        TransHopMeta oneErr = new TransHopMeta(one, err);
        previewMeta.addTransHop(oneErr);
        return previewMeta;
    }

    public static List<RowMetaAndData> executeTestTransformation(TransMeta transMeta, String testStepname, List<RowMetaAndData> inputData) throws KettleException {
        return TransTestFactory.executeTestTransformation(transMeta, INJECTOR_STEPNAME, testStepname, DUMMY_STEPNAME, inputData);
    }

    public static List<RowMetaAndData> executeTestTransformation(TransMeta transMeta, String injectorStepname, String testStepname, String dummyStepname, List<RowMetaAndData> inputData) throws KettleException {
        return TransTestFactory.executeTestTransformation(transMeta, injectorStepname, testStepname, dummyStepname, inputData, null, null);
    }

    public static List<RowMetaAndData> executeTestTransformation(TransMeta transMeta, String injectorStepname, String testStepname, String dummyStepname, List<RowMetaAndData> inputData, VariableSpace runTimeVariables, VariableSpace runTimeParameters) throws KettleException {
        Trans trans = new Trans(transMeta);
        trans.initializeVariablesFrom(runTimeVariables);
        if (runTimeParameters != null) {
            for (String param : trans.listParameters()) {
                String value = runTimeParameters.getVariable(param);
                if (value == null) continue;
                trans.setParameterValue(param, value);
                transMeta.setParameterValue(param, value);
            }
        }
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = inputData;
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        if (trans.getResult().getNrErrors() > 0L) {
            throw new KettleException("Test transformation finished with errors. Check the log.");
        }
        return dummyRc.getRowsRead();
    }

    public static Map<String, RowStepCollector> executeTestTransformationError(TransMeta transMeta, String testStepname, List<RowMetaAndData> inputData) throws KettleException {
        return TransTestFactory.executeTestTransformationError(transMeta, INJECTOR_STEPNAME, testStepname, DUMMY_STEPNAME, ERROR_STEPNAME, inputData);
    }

    public static Map<String, RowStepCollector> executeTestTransformationError(TransMeta transMeta, String injectorStepname, String testStepname, String dummyStepname, String errorStepName, List<RowMetaAndData> inputData) throws KettleException {
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        StepInterface junit = trans.getStepInterface(testStepname, 0);
        RowStepCollector dummyJu = new RowStepCollector();
        junit.addRowListener((RowListener)dummyJu);
        StepInterface er = trans.getStepInterface(errorStepName, 0);
        RowStepCollector erColl = new RowStepCollector();
        er.addRowListener((RowListener)erColl);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = inputData;
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        if (trans.getResult().getNrErrors() > 0L) {
            throw new KettleException("Test transformation finished with errors. Check the log.");
        }
        HashMap<String, RowStepCollector> ret = new HashMap<String, RowStepCollector>();
        ret.put(dummyStepname, dummyRc);
        ret.put(errorStepName, erColl);
        ret.put(testStepname, dummyJu);
        return ret;
    }

    static StepMeta getInjectorStepMeta() {
        return TransTestFactory.getInjectorStepMeta(null);
    }

    static StepMeta getInjectorStepMeta(RowMetaInterface outputRowMeta) {
        InjectorMeta zeroMeta = new InjectorMeta();
        if (outputRowMeta != null && outputRowMeta.size() > 0) {
            String[] fieldName = new String[outputRowMeta.size()];
            int[] fieldLength = new int[outputRowMeta.size()];
            int[] fieldPrecision = new int[outputRowMeta.size()];
            int[] fieldType = new int[outputRowMeta.size()];
            for (int i = 0; i < outputRowMeta.size(); ++i) {
                ValueMetaInterface field = outputRowMeta.getValueMeta(i);
                fieldName[i] = field.getName();
                fieldLength[i] = field.getLength();
                fieldPrecision[i] = field.getPrecision();
                fieldType[i] = field.getType();
            }
            zeroMeta.setFieldname(fieldName);
            zeroMeta.setLength(fieldLength);
            zeroMeta.setPrecision(fieldPrecision);
            zeroMeta.setType(fieldType);
        }
        StepMeta zero = new StepMeta(registry.getPluginId(StepPluginType.class, (Object)zeroMeta), INJECTOR_STEPNAME, (StepMetaInterface)zeroMeta);
        zero.setLocation(50, 50);
        zero.setDraw(true);
        return zero;
    }

    static StepMeta getReadStepMeta(String name) {
        DummyTransMeta twoMeta = new DummyTransMeta();
        StepMeta two = new StepMeta(registry.getPluginId(StepPluginType.class, (Object)twoMeta), name, (StepMetaInterface)twoMeta);
        two.setLocation(250, 50);
        two.setDraw(true);
        return two;
    }

    static StepMeta getReadStepMeta() {
        return TransTestFactory.getReadStepMeta(DUMMY_STEPNAME);
    }
}

