/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.logging.StepLogTable;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransListener;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransStoppedListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;

@RunWith(value=MockitoJUnitRunner.class)
public class TransTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    @Mock
    private StepInterface stepMock;
    @Mock
    private StepInterface stepMock2;
    @Mock
    private StepDataInterface data;
    @Mock
    private StepDataInterface data2;
    @Mock
    private StepMeta stepMeta;
    @Mock
    private StepMeta stepMeta2;
    @Mock
    private TransMeta transMeta;
    int count = 10000;
    Trans trans;
    TransMeta meta;
    private final TransListener listener = new TransListener(){

        public void transStarted(Trans trans) throws KettleException {
        }

        public void transActive(Trans trans) {
        }

        public void transFinished(Trans trans) throws KettleException {
        }
    };
    private final TransStoppedListener transStoppedListener = new TransStoppedListener(){

        public void transStopped(Trans trans) {
        }
    };

    @BeforeClass
    public static void beforeClass() throws KettleException {
        KettleEnvironment.init();
    }

    @Before
    public void beforeTest() throws KettleException {
        this.meta = new TransMeta();
        this.trans = new Trans(this.meta);
        this.trans.setLog((LogChannelInterface)Mockito.mock(LogChannelInterface.class));
        this.trans.prepareExecution(null);
        this.trans.startThreads();
    }

    @Test(timeout=1000L)
    public void transWithNoStepsIsNotEndless() throws Exception {
        Trans transWithNoSteps = new Trans(new TransMeta());
        transWithNoSteps = (Trans)Mockito.spy((Object)transWithNoSteps);
        transWithNoSteps.prepareExecution(new String[0]);
        transWithNoSteps.startThreads();
        ((Trans)Mockito.verify((Object)transWithNoSteps)).fireTransStartedListeners();
        ((Trans)Mockito.verify((Object)transWithNoSteps)).fireTransFinishedListeners();
    }

    @Test
    public void testFindDatabaseWithEncodedConnectionName() {
        DatabaseMeta dbMeta1 = new DatabaseMeta("encoded_DBConnection", "Oracle", "localhost", "access", "test", "111", "test", "test");
        dbMeta1.setDisplayName("encoded.DBConnection");
        this.meta.addDatabase(dbMeta1);
        DatabaseMeta dbMeta2 = new DatabaseMeta("normalDBConnection", "Oracle", "localhost", "access", "test", "111", "test", "test");
        dbMeta2.setDisplayName("normalDBConnection");
        this.meta.addDatabase(dbMeta2);
        DatabaseMeta databaseMeta = this.meta.findDatabase(dbMeta1.getDisplayName());
        Assert.assertNotNull((Object)databaseMeta);
        Assert.assertEquals((Object)databaseMeta.getName(), (Object)"encoded_DBConnection");
        Assert.assertEquals((Object)databaseMeta.getDisplayName(), (Object)"encoded.DBConnection");
    }

    @Test
    public void testLoggingObjectIsNotLeakInMeta() {
        String expected = this.meta.log.getLogChannelId();
        this.meta.clear();
        String actual = this.meta.log.getLogChannelId();
        Assert.assertEquals((String)"Use same logChannel for empty constructors, or assign General level for clear() calls", (Object)expected, (Object)actual);
    }

    @Test
    public void testLoggingObjectIsNotLeakInTrans() throws KettleException {
        Repository rep = (Repository)Mockito.mock(Repository.class);
        RepositoryDirectoryInterface repInt = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)rep.loadTransformation(Mockito.anyString(), (RepositoryDirectoryInterface)Mockito.any(RepositoryDirectoryInterface.class), (ProgressMonitorListener)Mockito.any(ProgressMonitorListener.class), Mockito.anyBoolean(), Mockito.anyString())).thenReturn((Object)this.meta);
        Mockito.when((Object)rep.findDirectory(Mockito.anyString())).thenReturn((Object)repInt);
        Trans trans = new Trans((VariableSpace)this.meta, rep, "junit", "junitDir", "fileName");
        Assert.assertEquals((String)"Log channel General assigned", (Object)LogChannel.GENERAL.getLogChannelId(), (Object)trans.log.getLogChannelId());
    }

    @Test
    public void testTransFinishListenersConcurrentModification() throws KettleException, InterruptedException {
        CountDownLatch start = new CountDownLatch(1);
        TransFinishListenerAdder add = new TransFinishListenerAdder(this.trans, start);
        TransFinishListenerFirer firer = new TransFinishListenerFirer(this.trans, start);
        this.startThreads(add, firer, start);
        Assert.assertEquals((String)"All listeners are added: no ConcurrentModificationException", (long)this.count, (long)add.c);
        Assert.assertEquals((String)"All Finish listeners are iterated over: no ConcurrentModificationException", (long)this.count, (long)firer.c);
    }

    @Test
    public void testTransStartListenersConcurrentModification() throws InterruptedException {
        CountDownLatch start = new CountDownLatch(1);
        TransFinishListenerAdder add = new TransFinishListenerAdder(this.trans, start);
        TransStartListenerFirer starter = new TransStartListenerFirer(this.trans, start);
        this.startThreads(add, starter, start);
        Assert.assertEquals((String)"All listeners are added: no ConcurrentModificationException", (long)this.count, (long)add.c);
        Assert.assertEquals((String)"All Start listeners are iterated over: no ConcurrentModificationException", (long)this.count, (long)starter.c);
    }

    @Test
    public void testTransStoppedListenersConcurrentModification() throws InterruptedException {
        CountDownLatch start = new CountDownLatch(1);
        TransStoppedCaller stopper = new TransStoppedCaller(this.trans, start);
        TransStopListenerAdder adder = new TransStopListenerAdder(this.trans, start);
        this.startThreads(stopper, adder, start);
        Assert.assertEquals((String)"All transformation stop listeners is added", (long)this.count, (long)adder.c);
        Assert.assertEquals((String)"All stop call success", (long)this.count, (long)stopper.c);
    }

    @Test
    public void testPDI12424ParametersFromMetaAreCopiedToTrans() throws KettleException, URISyntaxException, IOException {
        String testParam = "testParam";
        String testParamValue = "testParamValue";
        TransMeta mockTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        Mockito.when((Object)mockTransMeta.listVariables()).thenReturn((Object)new String[0]);
        Mockito.when((Object)mockTransMeta.listParameters()).thenReturn((Object)new String[]{testParam});
        Mockito.when((Object)mockTransMeta.getParameterValue(testParam)).thenReturn((Object)testParamValue);
        FileObject ktr = KettleVFS.createTempFile((String)"parameters", (String)".ktr", (String)"ram://");
        try (OutputStream outputStream = ktr.getContent().getOutputStream(true);){
            ByteArrayInputStream inputStream = new ByteArrayInputStream("<transformation></transformation>".getBytes());
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        Trans trans = new Trans((VariableSpace)mockTransMeta, null, null, null, ktr.getURL().toURI().toString());
        Assert.assertEquals((Object)testParamValue, (Object)trans.getParameterValue(testParam));
    }

    @Test
    public void testRecordsCleanUpMethodIsCalled() throws Exception {
        Database mockedDataBase = (Database)Mockito.mock(Database.class);
        Trans trans = (Trans)Mockito.mock(Trans.class);
        StepLogTable stepLogTable = StepLogTable.getDefault((VariableSpace)((VariableSpace)Mockito.mock(VariableSpace.class)), (HasDatabasesInterface)((HasDatabasesInterface)Mockito.mock(HasDatabasesInterface.class)));
        stepLogTable.setConnectionName("connection");
        TransMeta transMeta = new TransMeta();
        transMeta.setStepLogTable(stepLogTable);
        Mockito.when((Object)trans.getTransMeta()).thenReturn((Object)transMeta);
        Mockito.when((Object)trans.createDataBase((DatabaseMeta)Matchers.any(DatabaseMeta.class))).thenReturn((Object)mockedDataBase);
        Mockito.when((Object)trans.getSteps()).thenReturn(new ArrayList());
        ((Trans)Mockito.doCallRealMethod().when((Object)trans)).writeStepLogInformation();
        trans.writeStepLogInformation();
        ((Database)Mockito.verify((Object)mockedDataBase)).cleanupLogRecords((LogTableCoreInterface)stepLogTable);
    }

    @Test
    public void testFireTransFinishedListeners() throws Exception {
        Trans trans = new Trans();
        TransListener mockListener = (TransListener)Mockito.mock(TransListener.class);
        trans.setTransListeners(Collections.singletonList(mockListener));
        trans.fireTransFinishedListeners();
        ((TransListener)Mockito.verify((Object)mockListener)).transFinished(trans);
    }

    @Test(expected=KettleException.class)
    public void testFireTransFinishedListenersExceptionOnTransFinished() throws Exception {
        Trans trans = new Trans();
        TransListener mockListener = (TransListener)Mockito.mock(TransListener.class);
        ((TransListener)Mockito.doThrow(KettleException.class).when((Object)mockListener)).transFinished(trans);
        trans.setTransListeners(Collections.singletonList(mockListener));
        trans.fireTransFinishedListeners();
    }

    @Test
    public void testFinishStatus() throws Exception {
        while (this.trans.isRunning()) {
            Thread.sleep(1L);
        }
        Assert.assertEquals((Object)"Finished", (Object)this.trans.getStatus());
    }

    @Test
    public void testSafeStop() {
        Mockito.when((Object)this.stepMock.isSafeStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.stepMock.getStepname()).thenReturn((Object)"stepName");
        this.trans.setSteps((List)ImmutableList.of((Object)this.combi(this.stepMock, this.data, this.stepMeta)));
        Result result = this.trans.getResult();
        Assert.assertFalse((boolean)result.isSafeStop());
        Mockito.when((Object)this.stepMock.isSafeStopped()).thenReturn((Object)true);
        result = this.trans.getResult();
        Assert.assertTrue((boolean)result.isSafeStop());
    }

    @Test
    public void safeStopStopsInputStepsRightAway() throws KettleException {
        this.trans.setSteps((List)ImmutableList.of((Object)this.combi(this.stepMock, this.data, this.stepMeta)));
        Mockito.when((Object)this.transMeta.findPreviousSteps(this.stepMeta, true)).thenReturn(Collections.emptyList());
        this.trans.transMeta = this.transMeta;
        this.trans.safeStop();
        this.verifyStopped(this.stepMock, 1);
    }

    @Test
    public void safeLetsNonInputStepsKeepRunning() throws KettleException {
        this.trans.setSteps((List)ImmutableList.of((Object)this.combi(this.stepMock, this.data, this.stepMeta), (Object)this.combi(this.stepMock2, this.data2, this.stepMeta2)));
        Mockito.when((Object)this.transMeta.findPreviousSteps(this.stepMeta, true)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.transMeta.findPreviousSteps(this.stepMeta2, true)).thenReturn((Object)ImmutableList.of((Object)this.stepMeta));
        this.trans.transMeta = this.transMeta;
        this.trans.safeStop();
        this.verifyStopped(this.stepMock, 1);
        this.verifyStopped(this.stepMock2, 0);
    }

    private void verifyStopped(StepInterface step, int numberTimesCalled) throws KettleException {
        ((StepInterface)Mockito.verify((Object)step, (VerificationMode)Mockito.times((int)numberTimesCalled))).setStopped(true);
        ((StepInterface)Mockito.verify((Object)step, (VerificationMode)Mockito.times((int)numberTimesCalled))).setSafeStopped(true);
        ((StepInterface)Mockito.verify((Object)step, (VerificationMode)Mockito.times((int)numberTimesCalled))).resumeRunning();
        ((StepInterface)Mockito.verify((Object)step, (VerificationMode)Mockito.times((int)numberTimesCalled))).stopRunning((StepMetaInterface)Matchers.any(), (StepDataInterface)Matchers.any());
    }

    private StepMetaDataCombi combi(StepInterface step, StepDataInterface data, StepMeta stepMeta) {
        StepMetaDataCombi stepMetaDataCombi = new StepMetaDataCombi();
        stepMetaDataCombi.step = step;
        stepMetaDataCombi.data = data;
        stepMetaDataCombi.stepMeta = stepMeta;
        return stepMetaDataCombi;
    }

    private void startThreads(Runnable one, Runnable two, CountDownLatch start) throws InterruptedException {
        Thread th = new Thread(one);
        Thread tt = new Thread(two);
        th.start();
        tt.start();
        start.countDown();
        th.join();
        tt.join();
    }

    @Test
    public void testNewTransformationsWithContainerObjectId() throws Exception {
        TransMeta meta = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransMeta)Mockito.doReturn((Object)new String[]{"X", "Y", "Z"}).when((Object)meta)).listVariables();
        ((TransMeta)Mockito.doReturn((Object)new String[]{"A", "B", "C"}).when((Object)meta)).listParameters();
        ((TransMeta)Mockito.doReturn((Object)"XYZ").when((Object)meta)).getVariable(Matchers.anyString());
        ((TransMeta)Mockito.doReturn((Object)"").when((Object)meta)).getParameterDescription(Matchers.anyString());
        ((TransMeta)Mockito.doReturn((Object)"").when((Object)meta)).getParameterDefault(Matchers.anyString());
        ((TransMeta)Mockito.doReturn((Object)"ABC").when((Object)meta)).getParameterValue(Matchers.anyString());
        String carteId = UUID.randomUUID().toString();
        ((TransMeta)Mockito.doReturn((Object)carteId).when((Object)meta)).getContainerObjectId();
        Trans trans = new Trans(meta);
        Assert.assertEquals((Object)carteId, (Object)trans.getContainerObjectId());
    }

    @Test
    public void testTwoTransformationsGetSameLogChannelId() throws Exception {
        TransMeta meta = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransMeta)Mockito.doReturn((Object)new String[]{"X", "Y", "Z"}).when((Object)meta)).listVariables();
        ((TransMeta)Mockito.doReturn((Object)new String[]{"A", "B", "C"}).when((Object)meta)).listParameters();
        ((TransMeta)Mockito.doReturn((Object)"XYZ").when((Object)meta)).getVariable(Matchers.anyString());
        ((TransMeta)Mockito.doReturn((Object)"").when((Object)meta)).getParameterDescription(Matchers.anyString());
        ((TransMeta)Mockito.doReturn((Object)"").when((Object)meta)).getParameterDefault(Matchers.anyString());
        ((TransMeta)Mockito.doReturn((Object)"ABC").when((Object)meta)).getParameterValue(Matchers.anyString());
        Trans trans1 = new Trans(meta);
        Trans trans2 = new Trans(meta);
        Assert.assertEquals((Object)trans1.getLogChannelId(), (Object)trans2.getLogChannelId());
    }

    @Test
    public void testTwoTransformationsGetDifferentLogChannelIdWithDifferentCarteId() throws Exception {
        TransMeta meta1 = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransMeta)Mockito.doReturn((Object)new String[]{"X", "Y", "Z"}).when((Object)meta1)).listVariables();
        ((TransMeta)Mockito.doReturn((Object)new String[]{"A", "B", "C"}).when((Object)meta1)).listParameters();
        ((TransMeta)Mockito.doReturn((Object)"XYZ").when((Object)meta1)).getVariable(Matchers.anyString());
        ((TransMeta)Mockito.doReturn((Object)"").when((Object)meta1)).getParameterDescription(Matchers.anyString());
        ((TransMeta)Mockito.doReturn((Object)"").when((Object)meta1)).getParameterDefault(Matchers.anyString());
        ((TransMeta)Mockito.doReturn((Object)"ABC").when((Object)meta1)).getParameterValue(Matchers.anyString());
        TransMeta meta2 = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransMeta)Mockito.doReturn((Object)new String[]{"X", "Y", "Z"}).when((Object)meta2)).listVariables();
        ((TransMeta)Mockito.doReturn((Object)new String[]{"A", "B", "C"}).when((Object)meta2)).listParameters();
        ((TransMeta)Mockito.doReturn((Object)"XYZ").when((Object)meta2)).getVariable(Matchers.anyString());
        ((TransMeta)Mockito.doReturn((Object)"").when((Object)meta2)).getParameterDescription(Matchers.anyString());
        ((TransMeta)Mockito.doReturn((Object)"").when((Object)meta2)).getParameterDefault(Matchers.anyString());
        ((TransMeta)Mockito.doReturn((Object)"ABC").when((Object)meta2)).getParameterValue(Matchers.anyString());
        String carteId1 = UUID.randomUUID().toString();
        String carteId2 = UUID.randomUUID().toString();
        ((TransMeta)Mockito.doReturn((Object)carteId1).when((Object)meta1)).getContainerObjectId();
        ((TransMeta)Mockito.doReturn((Object)carteId2).when((Object)meta2)).getContainerObjectId();
        Trans trans1 = new Trans(meta1);
        Trans trans2 = new Trans(meta2);
        Assert.assertNotEquals((Object)trans1.getContainerObjectId(), (Object)trans2.getContainerObjectId());
        Assert.assertNotEquals((Object)trans1.getLogChannelId(), (Object)trans2.getLogChannelId());
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithFilename() {
        Trans transTest = new Trans();
        boolean hasFilename = true;
        boolean hasRepoDir = false;
        transTest.copyVariablesFrom(null);
        transTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        transTest.setVariable("Internal.Transformation.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        transTest.setVariable("Internal.Transformation.Repository.Directory", "/SomeRepDirectory");
        transTest.setInternalEntryCurrentDirectory(hasFilename, hasRepoDir);
        Assert.assertEquals((Object)"file:///C:/SomeFilenameDirectory", (Object)transTest.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithRepository() {
        Trans transTest = new Trans();
        boolean hasFilename = false;
        boolean hasRepoDir = true;
        transTest.copyVariablesFrom(null);
        transTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        transTest.setVariable("Internal.Transformation.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        transTest.setVariable("Internal.Transformation.Repository.Directory", "/SomeRepDirectory");
        transTest.setInternalEntryCurrentDirectory(hasFilename, hasRepoDir);
        Assert.assertEquals((Object)"/SomeRepDirectory", (Object)transTest.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithoutFilenameOrRepository() {
        Trans transTest = new Trans();
        transTest.copyVariablesFrom(null);
        boolean hasFilename = false;
        boolean hasRepoDir = false;
        transTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        transTest.setVariable("Internal.Transformation.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        transTest.setVariable("Internal.Transformation.Repository.Directory", "/SomeRepDirectory");
        transTest.setInternalEntryCurrentDirectory(hasFilename, hasRepoDir);
        Assert.assertEquals((Object)"Original value defined at run execution", (Object)transTest.getVariable("Internal.Entry.Current.Directory"));
    }

    private class TransStartListenerFirer
    extends TransKicker {
        TransStartListenerFirer(Trans tr, CountDownLatch start) {
            super(tr, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                try {
                    this.tr.fireTransStartedListeners();
                }
                catch (KettleException e) {
                    throw new RuntimeException();
                }
            }
        }
    }

    private class TransFinishListenerFirer
    extends TransKicker {
        TransFinishListenerFirer(Trans tr, CountDownLatch start) {
            super(tr, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                try {
                    this.tr.fireTransFinishedListeners();
                    this.tr.waitUntilFinished();
                }
                catch (KettleException e) {
                    throw new RuntimeException();
                }
            }
        }
    }

    private class TransFinishListenerAdder
    extends TransKicker {
        TransFinishListenerAdder(Trans tr, CountDownLatch start) {
            super(tr, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                this.tr.addTransListener(TransTest.this.listener);
            }
        }
    }

    private class TransStopListenerAdder
    extends TransKicker {
        TransStopListenerAdder(Trans tr, CountDownLatch start) {
            super(tr, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                TransTest.this.trans.addTransStoppedListener(TransTest.this.transStoppedListener);
            }
        }
    }

    private class TransStoppedCaller
    extends TransKicker {
        TransStoppedCaller(Trans tr, CountDownLatch start) {
            super(tr, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                TransTest.this.trans.stopAll();
            }
        }
    }

    private abstract class TransKicker
    implements Runnable {
        protected Trans tr;
        protected int c = 0;
        protected CountDownLatch start;
        protected int max;

        TransKicker(Trans tr, CountDownLatch start) {
            this.max = TransTest.this.count;
            this.tr = tr;
            this.start = start;
        }

        protected boolean isStopped() {
            ++this.c;
            return this.c >= this.max;
        }
    }
}

