/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.Properties;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransSupplier;
import org.pentaho.di.trans.ael.websocket.TransWebSocketEngineAdapter;

public class TransSupplierTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private Trans trans = (Trans)Mockito.mock(Trans.class);
    private TransMeta meta = (TransMeta)Mockito.mock(TransMeta.class);
    private Supplier<Trans> fallbackSupplier = (Supplier)Mockito.mock(Supplier.class);
    private LogChannelInterface log = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
    private TransHopMeta transHopMeta = (TransHopMeta)Mockito.mock(TransHopMeta.class);
    private TransSupplier transSupplier;
    private Properties props = null;

    @Before
    public void before() throws KettleException {
        this.props = System.getProperties();
    }

    @Test
    public void testFallback() throws KettleException {
        Mockito.when((Object)this.fallbackSupplier.get()).thenReturn((Object)this.trans);
        this.transSupplier = new TransSupplier(this.meta, this.log, this.fallbackSupplier);
        Trans transRet = this.transSupplier.get();
        ((Supplier)Mockito.verify(this.fallbackSupplier)).get();
        Assert.assertEquals((Object)transRet, (Object)this.trans);
    }

    @Test
    public void testWebsocketVersion() throws KettleException {
        this.props.setProperty("KETTLE_AEL_PDI_DAEMON_VERSION", "2.0");
        Mockito.when((Object)this.meta.getVariable("engine")).thenReturn((Object)"spark");
        Mockito.when((Object)this.meta.getVariable("engine.host")).thenReturn((Object)"hostname");
        Mockito.when((Object)this.meta.getVariable("engine.port")).thenReturn((Object)"8080");
        Mockito.when((Object)this.meta.nrTransHops()).thenReturn((Object)0);
        Mockito.when((Object)this.meta.getTransHop(0)).thenReturn((Object)this.transHopMeta);
        Mockito.when((Object)this.meta.realClone(false)).thenReturn((Object)this.meta);
        Mockito.when((Object)this.transHopMeta.isEnabled()).thenReturn((Object)false);
        this.transSupplier = new TransSupplier(this.meta, this.log, this.fallbackSupplier);
        Trans transRet = this.transSupplier.get();
        Assert.assertTrue((boolean)(transRet instanceof TransWebSocketEngineAdapter));
    }

    @Test(expected=RuntimeException.class)
    public void testInvalidEngine() throws KettleException {
        this.props.setProperty("KETTLE_AEL_PDI_DAEMON_VERSION", "1.0");
        Mockito.when((Object)this.meta.getVariable("engine")).thenReturn((Object)"invalidEngine");
        this.transSupplier = new TransSupplier(this.meta, this.log, this.fallbackSupplier);
        this.transSupplier.get();
    }
}

