/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.listeners.ContentChangedListener;
import org.pentaho.di.core.logging.TransLogTable;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.metastore.DatabaseMetaStoreUtil;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaChangeListenerInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.datagrid.DataGridMeta;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;
import org.pentaho.di.trans.steps.userdefinedjavaclass.InfoStepDefinition;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UserDefinedJavaClassDef;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UserDefinedJavaClassMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.stores.memory.MemoryMetaStore;
import org.powermock.modules.junit4.PowerMockRunner;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RunWith(value=PowerMockRunner.class)
public class TransMetaTest {
    public static final String STEP_NAME = "Any step name";
    private TransMeta transMeta;

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init((boolean)false);
    }

    @Before
    public void setUp() throws Exception {
        this.transMeta = new TransMeta();
    }

    @Test
    public void testGetMinimum() {
        Point minimalCanvasPoint = new Point(0, 0);
        Point stepPoint = new Point(500, 500);
        Point point = this.transMeta.getMinimum();
        Assert.assertEquals((long)minimalCanvasPoint.x, (long)point.x);
        Assert.assertEquals((long)minimalCanvasPoint.y, (long)point.y);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)stepMeta.getLocation()).thenReturn((Object)stepPoint);
        this.transMeta.addStep(stepMeta);
        Point actualStepPoint = this.transMeta.getMinimum();
        Assert.assertEquals((long)(stepPoint.x - 20), (long)actualStepPoint.x);
        Assert.assertEquals((long)(stepPoint.y - 20), (long)actualStepPoint.y);
    }

    @Test
    public void getThisStepFieldsPassesCloneRowMeta() throws Exception {
        String overriddenValue = "overridden";
        StepMeta nextStep = TransMetaTest.mockStepMeta("nextStep");
        StepMetaInterface smi = (StepMetaInterface)Mockito.mock(StepMetaInterface.class);
        StepIOMeta ioMeta = (StepIOMeta)Mockito.mock(StepIOMeta.class);
        Mockito.when((Object)smi.getStepIOMeta()).thenReturn((Object)ioMeta);
        ((StepMetaInterface)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                RowMetaInterface rmi = (RowMetaInterface)invocation.getArguments()[0];
                rmi.clear();
                rmi.addValueMeta((ValueMetaInterface)new ValueMetaString("overridden"));
                return null;
            }
        }).when((Object)smi)).getFields((RowMetaInterface)Mockito.any(RowMetaInterface.class), Mockito.anyString(), (RowMetaInterface[])Mockito.any(RowMetaInterface[].class), (StepMeta)Mockito.eq((Object)nextStep), (VariableSpace)Mockito.any(VariableSpace.class), (Repository)Mockito.any(Repository.class), (IMetaStore)Mockito.any(IMetaStore.class));
        StepMeta thisStep = TransMetaTest.mockStepMeta("thisStep");
        Mockito.when((Object)thisStep.getStepMetaInterface()).thenReturn((Object)smi);
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("value"));
        RowMetaInterface thisStepsFields = this.transMeta.getThisStepFields(thisStep, nextStep, (RowMetaInterface)rowMeta);
        Assert.assertEquals((long)1L, (long)thisStepsFields.size());
        Assert.assertEquals((Object)"overridden", (Object)thisStepsFields.getValueMeta(0).getName());
    }

    @Test
    public void getThisStepFieldsPassesClonedInfoRowMeta() throws Exception {
        StepMetaInterface smi = (StepMetaInterface)Mockito.mock(StepMetaInterface.class);
        StepIOMeta ioMeta = (StepIOMeta)Mockito.mock(StepIOMeta.class);
        Mockito.when((Object)smi.getStepIOMeta()).thenReturn((Object)ioMeta);
        StepMeta thisStep = TransMetaTest.mockStepMeta("thisStep");
        StepMeta nextStep = TransMetaTest.mockStepMeta("nextStep");
        Mockito.when((Object)thisStep.getStepMetaInterface()).thenReturn((Object)smi);
        RowMeta row = new RowMeta();
        Mockito.when((Object)smi.getTableFields()).thenReturn((Object)row);
        this.transMeta.getThisStepFields(thisStep, nextStep, (RowMetaInterface)row);
        ((StepMetaInterface)Mockito.verify((Object)smi, (VerificationMode)Mockito.never())).getFields((RowMetaInterface)Mockito.any(), (String)Mockito.any(), (RowMetaInterface[])Mockito.eq((Object)new RowMetaInterface[]{row}), (StepMeta)Mockito.any(), (VariableSpace)Mockito.any(), (Repository)Mockito.any(), (IMetaStore)Mockito.any());
    }

    @Test
    public void testDatabaseNotOverridden() throws Exception {
        String name = "db meta";
        DatabaseMeta dbMetaShared = new DatabaseMeta();
        dbMetaShared.setName("db meta");
        dbMetaShared.setHostname("host");
        DatabaseMeta dbMetaStore = new DatabaseMeta();
        dbMetaStore.setName("db meta");
        dbMetaStore.setHostname("anotherhost");
        MemoryMetaStore mstore = new MemoryMetaStore();
        DatabaseMetaStoreUtil.createDatabaseElement((IMetaStore)mstore, (DatabaseMeta)dbMetaStore);
        TransMeta trans = new TransMeta();
        trans.addOrReplaceDatabase(dbMetaShared);
        trans.setMetaStore((IMetaStore)mstore);
        trans.importFromMetaStore();
        DatabaseMeta dbMeta = trans.findDatabase("db meta");
        Assert.assertEquals((Object)dbMetaShared.getHostname(), (Object)dbMeta.getHostname());
    }

    @Test
    public void testContentChangeListener() throws Exception {
        ContentChangedListener listener = (ContentChangedListener)Mockito.mock(ContentChangedListener.class);
        this.transMeta.addContentChangedListener(listener);
        this.transMeta.setChanged();
        this.transMeta.setChanged(true);
        ((ContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).contentChanged(Matchers.same((Object)this.transMeta));
        this.transMeta.clearChanged();
        this.transMeta.setChanged(false);
        ((ContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).contentSafe(Matchers.same((Object)this.transMeta));
        this.transMeta.removeContentChangedListener(listener);
        this.transMeta.setChanged();
        this.transMeta.setChanged(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testCompare() throws Exception {
        TransMeta transMeta = new TransMeta("aFile", "aName");
        TransMeta transMeta2 = new TransMeta("aFile", "aName");
        Assert.assertEquals((long)0L, (long)transMeta.compare(transMeta, transMeta2));
        transMeta2.setVariable("myVariable", "myValue");
        Assert.assertEquals((long)0L, (long)transMeta.compare(transMeta, transMeta2));
        transMeta2.setFilename(null);
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta2, transMeta));
        transMeta2.setFilename("aFile");
        transMeta2.setName(null);
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta2, transMeta));
        transMeta2.setFilename("aFile2");
        transMeta2.setName("aName");
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta2, transMeta));
        transMeta2.setFilename("aFile");
        transMeta2.setName("aName2");
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta2, transMeta));
        transMeta.setFilename(null);
        transMeta2.setFilename(null);
        transMeta2.setName("aName");
        Assert.assertEquals((long)0L, (long)transMeta.compare(transMeta, transMeta2));
        RepositoryDirectoryInterface path1 = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        transMeta.setRepositoryDirectory(path1);
        Mockito.when((Object)path1.getPath()).thenReturn((Object)"aPath2");
        RepositoryDirectoryInterface path2 = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)path2.getPath()).thenReturn((Object)"aPath");
        transMeta2.setRepositoryDirectory(path2);
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta2, transMeta));
        Mockito.when((Object)path1.getPath()).thenReturn((Object)"aPath");
        Assert.assertEquals((long)0L, (long)transMeta.compare(transMeta, transMeta2));
        ObjectRevision revision2 = (ObjectRevision)Mockito.mock(ObjectRevision.class);
        transMeta2.setObjectRevision(revision2);
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta2, transMeta));
        ObjectRevision revision1 = (ObjectRevision)Mockito.mock(ObjectRevision.class);
        transMeta.setObjectRevision(revision1);
        Mockito.when((Object)revision1.getName()).thenReturn((Object)"aRevision");
        Mockito.when((Object)revision2.getName()).thenReturn((Object)"aRevision");
        Assert.assertEquals((long)0L, (long)transMeta.compare(transMeta, transMeta2));
        Mockito.when((Object)revision2.getName()).thenReturn((Object)"aRevision2");
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta2, transMeta));
    }

    @Test
    public void testEquals() throws Exception {
        TransMeta transMeta = new TransMeta("1", "2");
        Assert.assertFalse((boolean)transMeta.equals((Object)"somethingelse"));
        Assert.assertTrue((boolean)transMeta.equals((Object)new TransMeta("1", "2")));
    }

    @Test
    public void testTransHops() throws Exception {
        TransMeta transMeta = new TransMeta("transFile", "myTrans");
        StepMeta step1 = new StepMeta("name1", null);
        StepMeta step2 = new StepMeta("name2", null);
        StepMeta step3 = new StepMeta("name3", null);
        StepMeta step4 = new StepMeta("name4", null);
        TransHopMeta hopMeta1 = new TransHopMeta(step1, step2, true);
        TransHopMeta hopMeta2 = new TransHopMeta(step2, step3, true);
        TransHopMeta hopMeta3 = new TransHopMeta(step3, step4, false);
        transMeta.addTransHop(0, hopMeta1);
        transMeta.addTransHop(1, hopMeta2);
        transMeta.addTransHop(2, hopMeta3);
        List hops = transMeta.getTransHopSteps(true);
        Assert.assertSame((Object)step1, hops.get(0));
        Assert.assertSame((Object)step2, hops.get(1));
        Assert.assertSame((Object)step3, hops.get(2));
        Assert.assertSame((Object)step4, hops.get(3));
        Assert.assertEquals((Object)hopMeta2, (Object)transMeta.findTransHop("name2 --> name3 (enabled)"));
        Assert.assertEquals((Object)hopMeta3, (Object)transMeta.findTransHopFrom(step3));
        Assert.assertEquals((Object)hopMeta2, (Object)transMeta.findTransHop(hopMeta2));
        Assert.assertEquals((Object)hopMeta1, (Object)transMeta.findTransHop(step1, step2));
        Assert.assertEquals(null, (Object)transMeta.findTransHop(step3, step4, false));
        Assert.assertEquals((Object)hopMeta3, (Object)transMeta.findTransHop(step3, step4, true));
        Assert.assertEquals((Object)hopMeta2, (Object)transMeta.findTransHopTo(step3));
        transMeta.removeTransHop(0);
        hops = transMeta.getTransHopSteps(true);
        Assert.assertSame((Object)step2, hops.get(0));
        Assert.assertSame((Object)step3, hops.get(1));
        Assert.assertSame((Object)step4, hops.get(2));
        transMeta.removeTransHop(hopMeta2);
        hops = transMeta.getTransHopSteps(true);
        Assert.assertSame((Object)step3, hops.get(0));
        Assert.assertSame((Object)step4, hops.get(1));
    }

    @Test
    public void testGetAllTransHops() throws Exception {
        TransMeta transMeta = new TransMeta("transFile", "myTrans");
        StepMeta step1 = new StepMeta("name1", null);
        StepMeta step2 = new StepMeta("name2", null);
        StepMeta step3 = new StepMeta("name3", null);
        StepMeta step4 = new StepMeta("name4", null);
        TransHopMeta hopMeta1 = new TransHopMeta(step1, step2, true);
        TransHopMeta hopMeta2 = new TransHopMeta(step2, step3, true);
        TransHopMeta hopMeta3 = new TransHopMeta(step2, step4, true);
        transMeta.addTransHop(0, hopMeta1);
        transMeta.addTransHop(1, hopMeta2);
        transMeta.addTransHop(2, hopMeta3);
        List allTransHopFrom = transMeta.findAllTransHopFrom(step2);
        Assert.assertEquals((Object)step3, (Object)((TransHopMeta)allTransHopFrom.get(0)).getToStep());
        Assert.assertEquals((Object)step4, (Object)((TransHopMeta)allTransHopFrom.get(1)).getToStep());
    }

    @Test
    public void testGetPrevInfoFields() throws KettleStepException {
        DataGridMeta dgm1 = new DataGridMeta();
        dgm1.setFieldName(new String[]{"id", "colA"});
        dgm1.allocate(2);
        dgm1.setFieldType(new String[]{ValueMetaFactory.getValueMetaName((int)5), ValueMetaFactory.getValueMetaName((int)2)});
        ArrayList<List<String>> dgm1Data = new ArrayList<List<String>>();
        dgm1Data.add(Arrays.asList("1", "A"));
        dgm1Data.add(Arrays.asList("2", "B"));
        dgm1.setDataLines(dgm1Data);
        DataGridMeta dgm2 = new DataGridMeta();
        dgm2.allocate(1);
        dgm2.setFieldName(new String[]{"moreData"});
        dgm2.setFieldType(new String[]{ValueMetaFactory.getValueMetaName((int)2)});
        ArrayList<List<String>> dgm2Data = new ArrayList<List<String>>();
        dgm2Data.add(Arrays.asList("Some Informational Data"));
        dgm2.setDataLines(dgm2Data);
        StepMeta dg1 = new StepMeta("input1", (StepMetaInterface)dgm1);
        StepMeta dg2 = new StepMeta("input2", (StepMetaInterface)dgm2);
        String UDJC_METHOD = "public boolean processRow( StepMetaInterface smi, StepDataInterface sdi ) throws KettleException { return false; }";
        UserDefinedJavaClassMeta udjcMeta = new UserDefinedJavaClassMeta();
        udjcMeta.getInfoStepDefinitions().add(new InfoStepDefinition(dg2.getName(), dg2.getName(), dg2, "info_data"));
        udjcMeta.replaceDefinitions(Collections.singletonList(new UserDefinedJavaClassDef(UserDefinedJavaClassDef.ClassType.TRANSFORM_CLASS, "MainClass", "public boolean processRow( StepMetaInterface smi, StepDataInterface sdi ) throws KettleException { return false; }")));
        StepMeta udjc = new StepMeta("PDI-14910", (StepMetaInterface)udjcMeta);
        TransHopMeta hop1 = new TransHopMeta(dg1, udjc, true);
        TransHopMeta hop2 = new TransHopMeta(dg2, udjc, true);
        this.transMeta.addStep(dg1);
        this.transMeta.addStep(dg2);
        this.transMeta.addStep(udjc);
        this.transMeta.addTransHop(hop1);
        this.transMeta.addTransHop(hop2);
        RowMetaInterface row = null;
        row = this.transMeta.getPrevInfoFields(udjc);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((Object)"moreData", (Object)row.getValueMeta(0).getName());
        Assert.assertEquals((long)2L, (long)row.getValueMeta(0).getType());
    }

    @Test
    public void testAddStepWithChangeListenerInterface() {
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        StepMetaChangeListenerInterfaceMock metaInterface = (StepMetaChangeListenerInterfaceMock)Mockito.mock(StepMetaChangeListenerInterfaceMock.class);
        Mockito.when((Object)stepMeta.getStepMetaInterface()).thenReturn((Object)metaInterface);
        Assert.assertEquals((long)0L, (long)this.transMeta.steps.size());
        Assert.assertEquals((long)0L, (long)this.transMeta.stepChangeListeners.size());
        this.transMeta.addStep(0, stepMeta);
        Assert.assertEquals((long)1L, (long)this.transMeta.steps.size());
        Assert.assertEquals((long)1L, (long)this.transMeta.stepChangeListeners.size());
        this.transMeta.addStep(0, stepMeta);
        Assert.assertEquals((long)2L, (long)this.transMeta.steps.size());
        Assert.assertEquals((long)2L, (long)this.transMeta.stepChangeListeners.size());
    }

    @Test
    public void testIsAnySelectedStepUsedInTransHopsNothingSelectedCase() {
        List<StepMeta> selectedSteps = Arrays.asList(new StepMeta(), new StepMeta(), new StepMeta());
        this.transMeta.getSteps().addAll(selectedSteps);
        Assert.assertFalse((boolean)this.transMeta.isAnySelectedStepUsedInTransHops());
    }

    @Test
    public void testIsAnySelectedStepUsedInTransHopsAnySelectedCase() {
        StepMeta stepMeta = new StepMeta();
        stepMeta.setName(STEP_NAME);
        TransHopMeta transHopMeta = new TransHopMeta();
        stepMeta.setSelected(true);
        List<StepMeta> selectedSteps = Arrays.asList(new StepMeta(), stepMeta, new StepMeta());
        transHopMeta.setToStep(stepMeta);
        transHopMeta.setFromStep(stepMeta);
        this.transMeta.getSteps().addAll(selectedSteps);
        this.transMeta.addTransHop(transHopMeta);
        Assert.assertTrue((boolean)this.transMeta.isAnySelectedStepUsedInTransHops());
    }

    @Test
    public void testCloneWithParam() throws Exception {
        TransMeta transMeta = new TransMeta("transFile", "myTrans");
        transMeta.addParameterDefinition("key", "defValue", "description");
        Object clone = transMeta.realClone(true);
        Assert.assertNotNull((Object)clone);
    }

    private static StepMeta mockStepMeta(String name) {
        StepMeta meta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)meta.getName()).thenReturn((Object)name);
        return meta;
    }

    @Test
    public void testLoadXml() throws KettleException {
        final String directory = "/home/admin";
        Node jobNode = (Node)Mockito.mock(Node.class);
        NodeList nodeList = new NodeList(){
            ArrayList<Node> nodes = new ArrayList();
            {
                Node nodeInfo = (Node)Mockito.mock(Node.class);
                Mockito.when((Object)nodeInfo.getNodeName()).thenReturn((Object)"info");
                Mockito.when((Object)nodeInfo.getChildNodes()).thenReturn((Object)this);
                Node nodeDirectory = (Node)Mockito.mock(Node.class);
                Mockito.when((Object)nodeDirectory.getNodeName()).thenReturn((Object)"directory");
                Node child = (Node)Mockito.mock(Node.class);
                Mockito.when((Object)nodeDirectory.getFirstChild()).thenReturn((Object)child);
                Mockito.when((Object)child.getNodeValue()).thenReturn((Object)directory);
                this.nodes.add(nodeDirectory);
                this.nodes.add(nodeInfo);
            }

            @Override
            public Node item(int index) {
                return this.nodes.get(index);
            }

            @Override
            public int getLength() {
                return this.nodes.size();
            }
        };
        Mockito.when((Object)jobNode.getChildNodes()).thenReturn((Object)nodeList);
        Repository rep = (Repository)Mockito.mock(Repository.class);
        RepositoryDirectory repDirectory = new RepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory(), "home"), "admin");
        Mockito.when((Object)rep.findDirectory((String)Mockito.eq((Object)directory))).thenReturn((Object)repDirectory);
        TransMeta meta = new TransMeta();
        VariableSpace variableSpace = (VariableSpace)Mockito.mock(VariableSpace.class);
        Mockito.when((Object)variableSpace.listVariables()).thenReturn((Object)new String[0]);
        meta.loadXML(jobNode, null, (IMetaStore)Mockito.mock(IMetaStore.class), rep, false, variableSpace, (OverwritePrompter)Mockito.mock(OverwritePrompter.class));
        meta.setInternalKettleVariables(null);
        Assert.assertEquals((Object)repDirectory.getPath(), (Object)meta.getVariable("Internal.Transformation.Repository.Directory"));
    }

    @Test
    public void testTransWithOneStepIsConsideredUsed() throws Exception {
        TransMeta transMeta = new TransMeta(this.getClass().getResource("one-step-trans.ktr").getPath());
        Assert.assertEquals((long)1L, (long)transMeta.getUsedSteps().size());
        Repository rep = (Repository)Mockito.mock(Repository.class);
        ProgressMonitorListener monitor = (ProgressMonitorListener)Mockito.mock(ProgressMonitorListener.class);
        ArrayList remarks = new ArrayList();
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        transMeta.checkSteps(remarks, false, monitor, (VariableSpace)new Variables(), rep, metaStore);
        Assert.assertEquals((long)4L, (long)remarks.size());
        for (CheckResultInterface remark : remarks) {
            Assert.assertEquals((long)1L, (long)remark.getType());
        }
    }

    @Test
    public void testGetCacheVersion() throws Exception {
        TransMeta transMeta = new TransMeta(this.getClass().getResource("one-step-trans.ktr").getPath());
        int oldCacheVersion = transMeta.getCacheVersion();
        transMeta.setSizeRowset(10);
        int currCacheVersion = transMeta.getCacheVersion();
        Assert.assertNotEquals((long)oldCacheVersion, (long)currCacheVersion);
    }

    @Test
    public void testGetCacheVersionWithIrrelevantParameters() throws Exception {
        TransMeta transMeta = new TransMeta(this.getClass().getResource("one-step-trans.ktr").getPath());
        int oldCacheVersion = transMeta.getCacheVersion();
        transMeta.setSizeRowset(1000);
        int currCacheVersion = transMeta.getCacheVersion();
        Assert.assertNotEquals((long)oldCacheVersion, (long)currCacheVersion);
        oldCacheVersion = currCacheVersion;
        transMeta.setDescription("transformation description");
        transMeta.setTransstatus(100);
        transMeta.setTransLogTable((TransLogTable)Mockito.mock(TransLogTable.class));
        transMeta.setCreatedUser("user");
        transMeta.setModifiedUser("user");
        transMeta.setCreatedDate(new Date());
        transMeta.setModifiedDate(new Date());
        transMeta.setPrivateKey(false);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("key", "value");
        transMeta.setAttributes("group", attributes);
        StepMeta stepMeta = transMeta.getStep(0);
        stepMeta.setDescription("stepDescription");
        stepMeta.setLocation(10, 20);
        stepMeta.setLocation(new Point(30, 40));
        stepMeta.setStepID("Dummy");
        stepMeta.setDistributes(false);
        stepMeta.setCopies(5);
        stepMeta.setStepPartitioningMeta((StepPartitioningMeta)Mockito.mock(StepPartitioningMeta.class));
        Assert.assertEquals((long)oldCacheVersion, (long)transMeta.getCacheVersion());
    }

    @Test
    public void testGetPrevStepFields() throws KettleStepException {
        DataGridMeta dgm = new DataGridMeta();
        dgm.allocate(2);
        dgm.setFieldName(new String[]{"id"});
        dgm.setFieldType(new String[]{ValueMetaFactory.getValueMetaName((int)5)});
        ArrayList<List<String>> dgm1Data = new ArrayList<List<String>>();
        dgm1Data.add(Collections.singletonList("1"));
        dgm1Data.add(Collections.singletonList("2"));
        dgm.setDataLines(dgm1Data);
        DataGridMeta dgm2 = new DataGridMeta();
        dgm2.allocate(2);
        dgm2.setFieldName(new String[]{"foo"});
        dgm2.setFieldType(new String[]{ValueMetaFactory.getValueMetaName((int)2)});
        ArrayList<List<String>> dgm1Data2 = new ArrayList<List<String>>();
        dgm1Data2.add(Collections.singletonList("3"));
        dgm1Data2.add(Collections.singletonList("4"));
        dgm2.setDataLines(dgm1Data2);
        StepMeta dg = new StepMeta("input1", (StepMetaInterface)dgm);
        StepMeta dg2 = new StepMeta("input2", (StepMetaInterface)dgm2);
        TextFileOutputMeta textFileOutputMeta = new TextFileOutputMeta();
        StepMeta textFileOutputStep = new StepMeta("BACKLOG-21039", (StepMetaInterface)textFileOutputMeta);
        TransHopMeta hop = new TransHopMeta(dg, textFileOutputStep, true);
        TransHopMeta hop2 = new TransHopMeta(dg2, textFileOutputStep, true);
        this.transMeta.addStep(dg);
        this.transMeta.addStep(dg2);
        this.transMeta.addStep(textFileOutputStep);
        this.transMeta.addTransHop(hop);
        this.transMeta.addTransHop(hop2);
        RowMetaInterface allRows = this.transMeta.getPrevStepFields(textFileOutputStep, null, null);
        Assert.assertNotNull((Object)allRows);
        Assert.assertEquals((long)2L, (long)allRows.size());
        Assert.assertEquals((Object)"id", (Object)allRows.getValueMeta(0).getName());
        Assert.assertEquals((Object)"foo", (Object)allRows.getValueMeta(1).getName());
        Assert.assertEquals((long)5L, (long)allRows.getValueMeta(0).getType());
        Assert.assertEquals((long)2L, (long)allRows.getValueMeta(1).getType());
        RowMetaInterface rows1 = this.transMeta.getPrevStepFields(textFileOutputStep, "input1", null);
        Assert.assertNotNull((Object)rows1);
        Assert.assertEquals((long)1L, (long)rows1.size());
        Assert.assertEquals((Object)"id", (Object)rows1.getValueMeta(0).getName());
        Assert.assertEquals((long)5L, (long)rows1.getValueMeta(0).getType());
        RowMetaInterface rows2 = this.transMeta.getPrevStepFields(textFileOutputStep, "input2", null);
        Assert.assertNotNull((Object)rows2);
        Assert.assertEquals((long)1L, (long)rows2.size());
        Assert.assertEquals((Object)"foo", (Object)rows2.getValueMeta(0).getName());
        Assert.assertEquals((long)2L, (long)rows2.getValueMeta(0).getType());
        dgm.setFieldName(new String[]{"id", "name"});
        dgm.setFieldType(new String[]{ValueMetaFactory.getValueMetaName((int)5), ValueMetaFactory.getValueMetaName((int)2)});
        allRows = this.transMeta.getPrevStepFields(textFileOutputStep, null, null);
        Assert.assertNotNull((Object)allRows);
        Assert.assertEquals((long)3L, (long)allRows.size());
        Assert.assertEquals((Object)"id", (Object)allRows.getValueMeta(0).getName());
        Assert.assertEquals((Object)"name", (Object)allRows.getValueMeta(1).getName());
        Assert.assertEquals((Object)"foo", (Object)allRows.getValueMeta(2).getName());
        Assert.assertEquals((long)5L, (long)allRows.getValueMeta(0).getType());
        Assert.assertEquals((long)2L, (long)allRows.getValueMeta(1).getType());
        Assert.assertEquals((long)2L, (long)allRows.getValueMeta(2).getType());
        rows1 = this.transMeta.getPrevStepFields(textFileOutputStep, "input1", null);
        Assert.assertNotNull((Object)rows1);
        Assert.assertEquals((long)2L, (long)rows1.size());
        Assert.assertEquals((Object)"id", (Object)rows1.getValueMeta(0).getName());
        Assert.assertEquals((Object)"name", (Object)rows1.getValueMeta(1).getName());
        Assert.assertEquals((long)5L, (long)rows1.getValueMeta(0).getType());
        Assert.assertEquals((long)2L, (long)rows1.getValueMeta(1).getType());
    }

    @Test
    public void testHasLoop_simpleLoop() throws Exception {
        TransMeta transMetaSpy = (TransMeta)Mockito.spy((Object)this.transMeta);
        StepMeta stepMetaMain = this.createStepMeta("mainStep");
        StepMeta stepMeta2 = this.createStepMeta("step2");
        StepMeta stepMeta3 = this.createStepMeta("step3");
        ArrayList<StepMeta> mainPrevSteps = new ArrayList<StepMeta>();
        mainPrevSteps.add(stepMeta2);
        ((TransMeta)Mockito.doReturn(mainPrevSteps).when((Object)transMetaSpy)).findPreviousSteps(stepMetaMain, true);
        Mockito.when((Object)transMetaSpy.findNrPrevSteps(stepMetaMain)).thenReturn((Object)1);
        Mockito.when((Object)transMetaSpy.findPrevStep(stepMetaMain, 0)).thenReturn((Object)stepMeta2);
        ArrayList<StepMeta> stepmeta2PrevSteps = new ArrayList<StepMeta>();
        stepmeta2PrevSteps.add(stepMeta3);
        ((TransMeta)Mockito.doReturn(stepmeta2PrevSteps).when((Object)transMetaSpy)).findPreviousSteps(stepMeta2, true);
        Mockito.when((Object)transMetaSpy.findNrPrevSteps(stepMeta2)).thenReturn((Object)1);
        Mockito.when((Object)transMetaSpy.findPrevStep(stepMeta2, 0)).thenReturn((Object)stepMeta3);
        ArrayList<StepMeta> stepmeta3PrevSteps = new ArrayList<StepMeta>();
        stepmeta3PrevSteps.add(stepMetaMain);
        ((TransMeta)Mockito.doReturn(stepmeta3PrevSteps).when((Object)transMetaSpy)).findPreviousSteps(stepMeta3, true);
        Mockito.when((Object)transMetaSpy.findNrPrevSteps(stepMeta3)).thenReturn((Object)1);
        Mockito.when((Object)transMetaSpy.findPrevStep(stepMeta3, 0)).thenReturn((Object)stepMetaMain);
        Assert.assertTrue((boolean)transMetaSpy.hasLoop(stepMetaMain));
    }

    @Test
    public void testHasLoop_loopInPrevSteps() throws Exception {
        TransMeta transMetaSpy = (TransMeta)Mockito.spy((Object)this.transMeta);
        StepMeta stepMetaMain = this.createStepMeta("mainStep");
        StepMeta stepMeta2 = this.createStepMeta("step2");
        StepMeta stepMeta3 = this.createStepMeta("step3");
        StepMeta stepMeta4 = this.createStepMeta("step4");
        Mockito.when((Object)transMetaSpy.findNrPrevSteps(stepMetaMain)).thenReturn((Object)1);
        Mockito.when((Object)transMetaSpy.findPrevStep(stepMetaMain, 0)).thenReturn((Object)stepMeta2);
        Mockito.when((Object)transMetaSpy.findNrPrevSteps(stepMeta2)).thenReturn((Object)1);
        Mockito.when((Object)transMetaSpy.findPrevStep(stepMeta2, 0)).thenReturn((Object)stepMeta3);
        Mockito.when((Object)transMetaSpy.findNrPrevSteps(stepMeta3)).thenReturn((Object)1);
        Mockito.when((Object)transMetaSpy.findPrevStep(stepMeta3, 0)).thenReturn((Object)stepMeta4);
        Mockito.when((Object)transMetaSpy.findNrPrevSteps(stepMeta4)).thenReturn((Object)1);
        Mockito.when((Object)transMetaSpy.findPrevStep(stepMeta4, 0)).thenReturn((Object)stepMeta3);
        Assert.assertFalse((boolean)transMetaSpy.hasLoop(stepMetaMain));
    }

    @Test
    public void infoStepFieldsAreNotIncludedInGetStepFields() throws KettleStepException {
        TransMeta transMeta = new TransMeta((VariableSpace)new Variables());
        StepMeta toBeAppended1 = this.testStep("toBeAppended1", Collections.emptyList(), Arrays.asList("field1", "field2"));
        StepMeta toBeAppended2 = this.testStep("toBeAppended2", Collections.emptyList(), Arrays.asList("field1", "field2"));
        StepMeta append = this.testStep("append", Arrays.asList("toBeAppended1", "toBeAppended2"), Collections.singletonList("outputField"));
        StepMeta after = new StepMeta("after", (StepMetaInterface)new DummyTransMeta());
        this.wireUpTestTransMeta(transMeta, toBeAppended1, toBeAppended2, append, after);
        RowMetaInterface results = transMeta.getStepFields(append, after, (ProgressMonitorListener)Mockito.mock(ProgressMonitorListener.class));
        Assert.assertThat((Object)1, (Matcher)CoreMatchers.equalTo((Object)results.size()));
        Assert.assertThat((Object)"outputField", (Matcher)CoreMatchers.equalTo((Object)results.getFieldNames()[0]));
    }

    @Test
    public void prevStepFieldsAreIncludedInGetStepFields() throws KettleStepException {
        TransMeta transMeta = new TransMeta((VariableSpace)new Variables());
        StepMeta prevStep1 = this.testStep("prevStep1", Collections.emptyList(), Arrays.asList("field1", "field2"));
        StepMeta prevStep2 = this.testStep("prevStep2", Collections.emptyList(), Arrays.asList("field3", "field4", "field5"));
        StepMeta someStep = this.testStep("step", Arrays.asList("prevStep1"), Arrays.asList("outputField"));
        StepMeta after = new StepMeta("after", (StepMetaInterface)new DummyTransMeta());
        this.wireUpTestTransMeta(transMeta, prevStep1, prevStep2, someStep, after);
        RowMetaInterface results = transMeta.getStepFields(someStep, after, (ProgressMonitorListener)Mockito.mock(ProgressMonitorListener.class));
        Assert.assertThat((Object)4, (Matcher)CoreMatchers.equalTo((Object)results.size()));
        Assert.assertThat((Object)new String[]{"field3", "field4", "field5", "outputField"}, (Matcher)CoreMatchers.equalTo((Object)results.getFieldNames()));
    }

    @Test
    public void findPreviousStepsNullMeta() {
        TransMeta transMeta = new TransMeta((VariableSpace)new Variables());
        List result = transMeta.findPreviousSteps(null, false);
        Assert.assertThat((Object)0, (Matcher)CoreMatchers.equalTo((Object)result.size()));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo(new ArrayList()));
    }

    private void wireUpTestTransMeta(TransMeta transMeta, StepMeta toBeAppended1, StepMeta toBeAppended2, StepMeta append, StepMeta after) {
        transMeta.addStep(append);
        transMeta.addStep(after);
        transMeta.addStep(toBeAppended1);
        transMeta.addStep(toBeAppended2);
        transMeta.addTransHop(new TransHopMeta(toBeAppended1, append));
        transMeta.addTransHop(new TransHopMeta(toBeAppended2, append));
        transMeta.addTransHop(new TransHopMeta(append, after));
    }

    private StepMeta testStep(String name, List<String> infoStepnames, List<String> fieldNames) throws KettleStepException {
        StepMetaInterface smi = this.stepMetaInterfaceWithFields((StepMetaInterface)new DummyTransMeta(), infoStepnames, fieldNames);
        return new StepMeta(name, smi);
    }

    private StepMetaInterface stepMetaInterfaceWithFields(StepMetaInterface smi, List<String> infoStepnames, List<String> fieldNames) throws KettleStepException {
        RowMeta rowMetaWithFields = new RowMeta();
        StepIOMeta stepIOMeta = (StepIOMeta)Mockito.mock(StepIOMeta.class);
        Mockito.when((Object)stepIOMeta.getInfoStepnames()).thenReturn((Object)infoStepnames.toArray(new String[0]));
        fieldNames.stream().forEach(field -> rowMetaWithFields.addValueMeta((ValueMetaInterface)new ValueMetaString(field)));
        StepMetaInterface newSmi = (StepMetaInterface)Mockito.spy((Object)smi);
        Mockito.when((Object)newSmi.getStepIOMeta()).thenReturn((Object)stepIOMeta);
        ((StepMetaInterface)Mockito.doAnswer(invocationOnMock -> {
            RowMetaInterface passedRmi = (RowMetaInterface)invocationOnMock.getArguments()[0];
            passedRmi.addRowMeta((RowMetaInterface)rowMetaWithFields);
            return null;
        }).when((Object)newSmi)).getFields((RowMetaInterface)Mockito.any(), (String)Mockito.any(), (RowMetaInterface[])Mockito.any(), (StepMeta)Mockito.any(), (VariableSpace)Mockito.any(), (Repository)Mockito.any(), (IMetaStore)Mockito.any());
        return newSmi;
    }

    private StepMeta createStepMeta(String name) {
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)stepMeta.getName()).thenReturn((Object)name);
        return stepMeta;
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithFilename() {
        TransMeta transMetaTest = new TransMeta();
        transMetaTest.setFilename("hasFilename");
        transMetaTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        transMetaTest.setVariable("Internal.Transformation.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        transMetaTest.setVariable("Internal.Transformation.Repository.Directory", "/SomeRepDirectory");
        transMetaTest.setInternalEntryCurrentDirectory();
        Assert.assertEquals((Object)"file:///C:/SomeFilenameDirectory", (Object)transMetaTest.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithRepository() {
        TransMeta transMetaTest = new TransMeta();
        RepositoryDirectoryInterface path = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)path.getPath()).thenReturn((Object)"aPath");
        transMetaTest.setRepository((Repository)Mockito.mock(Repository.class));
        transMetaTest.setRepositoryDirectory(path);
        transMetaTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        transMetaTest.setVariable("Internal.Transformation.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        transMetaTest.setVariable("Internal.Transformation.Repository.Directory", "/SomeRepDirectory");
        transMetaTest.setInternalEntryCurrentDirectory();
        Assert.assertEquals((Object)"/SomeRepDirectory", (Object)transMetaTest.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithoutFilenameOrRepository() {
        TransMeta transMetaTest = new TransMeta();
        transMetaTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        transMetaTest.setVariable("Internal.Transformation.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        transMetaTest.setVariable("Internal.Transformation.Repository.Directory", "/SomeRepDirectory");
        transMetaTest.setInternalEntryCurrentDirectory();
        Assert.assertEquals((Object)"Original value defined at run execution", (Object)transMetaTest.getVariable("Internal.Entry.Current.Directory"));
    }

    public static abstract class StepMetaChangeListenerInterfaceMock
    implements StepMetaInterface,
    StepMetaChangeListenerInterface {
        public abstract Object clone();
    }
}

