/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.base.PrivateDatabasesTestTemplate;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.TransMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TransMetaPrivateDbTest
extends PrivateDatabasesTestTemplate<TransMeta> {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Override
    protected TransMeta createMeta() {
        return new TransMeta();
    }

    @Override
    protected TransMeta fromXml(String xml, SharedObjects fakeSharedObjects) throws Exception {
        TransMeta meta = (TransMeta)Mockito.spy((Object)new TransMeta());
        ((TransMeta)Mockito.doAnswer(this.createInjectingAnswer(meta, fakeSharedObjects)).when((Object)meta)).readSharedObjects();
        Document doc = XMLHandler.loadXMLFile((InputStream)new ByteArrayInputStream(xml.getBytes()), null, (boolean)false, (boolean)false);
        meta.loadXML(XMLHandler.getSubNode((Node)doc, (String)"transformation"), null, false);
        return meta;
    }

    @Override
    protected String toXml(TransMeta meta) throws Exception {
        return meta.getXML();
    }

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Test
    public void onePrivate_TwoShared() throws Exception {
        this.doTest_OnePrivate_TwoShared();
    }

    @Test
    public void noPrivate() throws Exception {
        this.doTest_NoPrivate();
    }

    @Test
    public void onePrivate_NoShared() throws Exception {
        this.doTest_OnePrivate_NoShared();
    }
}

