/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.plugins.ClassLoadingPluginInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TransExecutionConfigurationTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Test
    public void testConnectRepository() throws KettleException {
        TransExecutionConfiguration transExecConf = new TransExecutionConfiguration();
        RepositoriesMeta repositoriesMeta = (RepositoriesMeta)Mockito.mock(RepositoriesMeta.class);
        final RepositoryMeta repositoryMeta = (RepositoryMeta)Mockito.mock(RepositoryMeta.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        String mockRepo = "mockRepo";
        final boolean[] connectionSuccess = new boolean[]{false};
        Repository initialRepo = (Repository)Mockito.mock(Repository.class);
        transExecConf.setRepository(initialRepo);
        KettleLogStore.init();
        MockRepositoryPlugin mockRepositoryPlugin = (MockRepositoryPlugin)Mockito.mock(MockRepositoryPlugin.class);
        Mockito.when((Object)mockRepositoryPlugin.getIds()).thenReturn((Object)new String[]{"mockRepo"});
        Mockito.when((Object)mockRepositoryPlugin.matches("mockRepo")).thenReturn((Object)true);
        Mockito.when((Object)mockRepositoryPlugin.getName()).thenReturn((Object)"mock-repository");
        Mockito.when((Object)mockRepositoryPlugin.getClassMap()).thenAnswer(new Answer<Map<Class<?>, String>>(){

            public Map<Class<?>, String> answer(InvocationOnMock invocation) throws Throwable {
                HashMap dbMap = new HashMap();
                dbMap.put(Repository.class, repositoryMeta.getClass().getName());
                return dbMap;
            }
        });
        List registeredPlugins = PluginRegistry.getInstance().getPlugins(RepositoryPluginType.class);
        for (PluginInterface registeredPlugin : registeredPlugins) {
            PluginRegistry.getInstance().removePlugin(RepositoryPluginType.class, registeredPlugin);
        }
        PluginRegistry.getInstance().registerPlugin(RepositoryPluginType.class, (PluginInterface)mockRepositoryPlugin);
        Mockito.when((Object)repositoriesMeta.findRepository(Mockito.anyString())).thenAnswer((Answer)new Answer<RepositoryMeta>(){

            public RepositoryMeta answer(InvocationOnMock invocation) throws Throwable {
                return "mockRepo".equals(invocation.getArguments()[0]) ? repositoryMeta : null;
            }
        });
        Mockito.when((Object)mockRepositoryPlugin.loadClass(Repository.class)).thenReturn((Object)repository);
        ((Repository)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                if (!"username".equals(invocation.getArguments()[0]) || !"password".equals(invocation.getArguments()[1])) {
                    connectionSuccess[0] = false;
                    throw new KettleException("Mock Repository connection failed");
                }
                connectionSuccess[0] = true;
                return null;
            }
        }).when((Object)repository)).connect(Mockito.anyString(), Mockito.anyString());
        transExecConf.connectRepository(repositoriesMeta, "notFound", "username", "password");
        Assert.assertEquals((String)"Repository Changed", (Object)initialRepo, (Object)transExecConf.getRepository());
        transExecConf.connectRepository(repositoriesMeta, "mockRepo", "username", "");
        Assert.assertEquals((String)"Repository Changed", (Object)initialRepo, (Object)transExecConf.getRepository());
        transExecConf.connectRepository(repositoriesMeta, "mockRepo", "username", "password");
        Assert.assertEquals((String)"Repository didn't change", (Object)repository, (Object)transExecConf.getRepository());
        Assert.assertTrue((String)"Repository not connected", (boolean)connectionSuccess[0]);
    }

    @Test
    public void testDefaultPassedBatchId() {
        TransExecutionConfiguration tec = new TransExecutionConfiguration();
        Assert.assertEquals((String)"default passedBatchId value must be null", null, (Object)tec.getPassedBatchId());
    }

    @Test
    public void testCopy() {
        TransExecutionConfiguration tec = new TransExecutionConfiguration();
        tec.setPassedBatchId(null);
        TransExecutionConfiguration tecCopy = (TransExecutionConfiguration)tec.clone();
        Assert.assertEquals((String)"clone-copy", (Object)tec.getPassedBatchId(), (Object)tecCopy.getPassedBatchId());
        tec.setPassedBatchId(Long.valueOf(0L));
        tecCopy = (TransExecutionConfiguration)tec.clone();
        Assert.assertEquals((String)"clone-copy", (Object)tec.getPassedBatchId(), (Object)tecCopy.getPassedBatchId());
        tec.setPassedBatchId(Long.valueOf(5L));
        tecCopy = (TransExecutionConfiguration)tec.clone();
        Assert.assertEquals((String)"clone-copy", (Object)tec.getPassedBatchId(), (Object)tecCopy.getPassedBatchId());
    }

    @Test
    public void testCopyXml() throws Exception {
        TransExecutionConfiguration tec = new TransExecutionConfiguration();
        Long passedBatchId0 = null;
        long passedBatchId1 = 0L;
        long passedBatchId2 = 5L;
        tec.setPassedBatchId(passedBatchId0);
        String xml = tec.getXML();
        Document doc = XMLHandler.loadXMLString((String)xml);
        Node node = XMLHandler.getSubNode((Node)doc, (String)"transformation_execution_configuration");
        TransExecutionConfiguration tecCopy = new TransExecutionConfiguration(node);
        Assert.assertEquals((String)"xml-copy", (Object)tec.getPassedBatchId(), (Object)tecCopy.getPassedBatchId());
        tec.setPassedBatchId(Long.valueOf(0L));
        xml = tec.getXML();
        doc = XMLHandler.loadXMLString((String)xml);
        node = XMLHandler.getSubNode((Node)doc, (String)"transformation_execution_configuration");
        tecCopy = new TransExecutionConfiguration(node);
        Assert.assertEquals((String)"xml-copy", (Object)tec.getPassedBatchId(), (Object)tecCopy.getPassedBatchId());
        tec.setPassedBatchId(Long.valueOf(5L));
        xml = tec.getXML();
        doc = XMLHandler.loadXMLString((String)xml);
        node = XMLHandler.getSubNode((Node)doc, (String)"transformation_execution_configuration");
        tecCopy = new TransExecutionConfiguration(node);
        Assert.assertEquals((String)"xml-copy", (Object)tec.getPassedBatchId(), (Object)tecCopy.getPassedBatchId());
    }

    public static interface MockRepositoryPlugin
    extends PluginInterface,
    ClassLoadingPluginInterface {
    }
}

