/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterfaceFactory;
import org.pentaho.di.core.logging.LoggingObject;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.SubtransExecutor;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepStatus;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorParameters;

@RunWith(value=MockitoJUnitRunner.class)
public class SubtransExecutorTest {
    @Mock
    private LogChannelInterfaceFactory logChannelFactory;
    @Mock
    private LogChannel logChannel;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUp() throws Exception {
        KettleLogStore.setLogChannelInterfaceFactory((LogChannelInterfaceFactory)this.logChannelFactory);
        Mockito.when((Object)this.logChannelFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any())).thenReturn((Object)this.logChannel);
    }

    @BeforeClass
    public static void init() throws Exception {
        KettleClientEnvironment.init();
        PluginRegistry.addPluginType((PluginTypeInterface)StepPluginType.getInstance());
        PluginRegistry.init();
        if (!Props.isInitialized()) {
            Props.init((int)0);
        }
    }

    @Test
    public void testRunningZeroRowsIsEmptyOptional() throws Exception {
        SubtransExecutor subtransExecutor = new SubtransExecutor("subtransname", null, null, false, null, "");
        Optional execute = subtransExecutor.execute(Collections.emptyList());
        Assert.assertFalse((boolean)execute.isPresent());
    }

    @Test
    public void testRunsATrans() throws Exception {
        TransMeta parentMeta = new TransMeta(this.getClass().getResource("subtrans-executor-parent.ktr").getPath(), (VariableSpace)new Variables());
        TransMeta subMeta = new TransMeta(this.getClass().getResource("subtrans-executor-sub.ktr").getPath(), (VariableSpace)new Variables());
        LoggingObject loggingObject = new LoggingObject((Object)"anything");
        Trans parentTrans = (Trans)Mockito.spy((Object)new Trans(parentMeta, (LoggingObjectInterface)loggingObject));
        SubtransExecutor subtransExecutor = new SubtransExecutor("subtransname", parentTrans, subMeta, true, new TransExecutorParameters(), "Group By");
        RowMetaInterface rowMeta = parentMeta.getStepFields("Data Grid");
        List<RowMetaAndData> rows = Arrays.asList(new RowMetaAndData(rowMeta, new Object[]{"Pentaho", 1L}), new RowMetaAndData(rowMeta, new Object[]{"Pentaho", 2L}), new RowMetaAndData(rowMeta, new Object[]{"Pentaho", 3L}), new RowMetaAndData(rowMeta, new Object[]{"Pentaho", 4L}));
        Optional optionalResult = subtransExecutor.execute(rows);
        Assert.assertEquals((long)1L, (long)((Result)optionalResult.orElseThrow(AssertionError::new)).getRows().size());
        ((LogChannel)Mockito.verify((Object)this.logChannel)).logBasic(Const.CR + "------------> Linenr 1------------------------------" + Const.CR + "name = Pentaho" + Const.CR + "sum = 10" + Const.CR + Const.CR + "====================");
        Map statuses = subtransExecutor.getStatuses();
        Assert.assertEquals((long)3L, (long)statuses.size());
        ArrayList statusList = new ArrayList(statuses.values());
        Assert.assertEquals((Object)"Get rows from result", (Object)((StepStatus)statusList.get(0)).getStepname());
        Assert.assertEquals((Object)"Group by", (Object)((StepStatus)statusList.get(1)).getStepname());
        Assert.assertEquals((Object)"Write to log", (Object)((StepStatus)statusList.get(2)).getStepname());
        for (Map.Entry entry : statuses.entrySet()) {
            StepStatus statusSpy = (StepStatus)Mockito.spy(entry.getValue());
            statuses.put(entry.getKey(), statusSpy);
        }
        subtransExecutor.execute(rows);
        for (Map.Entry entry : statuses.entrySet()) {
            ((StepStatus)Mockito.verify(entry.getValue())).updateAll((StepInterface)Matchers.any());
        }
        ((Trans)Mockito.verify((Object)parentTrans, (VerificationMode)Mockito.atLeastOnce())).addActiveSubTransformation((String)Matchers.eq((Object)"subtransname"), (Trans)Matchers.any(Trans.class));
    }

    @Test
    public void stopsAll() throws KettleException {
        TransMeta parentMeta = new TransMeta(this.getClass().getResource("subtrans-executor-parent.ktr").getPath(), (VariableSpace)new Variables());
        TransMeta subMeta = new TransMeta(this.getClass().getResource("subtrans-executor-sub.ktr").getPath(), (VariableSpace)new Variables());
        LoggingObject loggingObject = new LoggingObject((Object)"anything");
        Trans parentTrans = new Trans(parentMeta, (LoggingObjectInterface)loggingObject);
        SubtransExecutor subtransExecutor = new SubtransExecutor("subtransname", parentTrans, subMeta, true, new TransExecutorParameters(), "");
        subtransExecutor.running = (Set)Mockito.spy((Object)subtransExecutor.running);
        RowMetaInterface rowMeta = parentMeta.getStepFields("Data Grid");
        List<RowMetaAndData> rows = Arrays.asList(new RowMetaAndData(rowMeta, new Object[]{"Pentaho", 1L}), new RowMetaAndData(rowMeta, new Object[]{"Pentaho", 2L}), new RowMetaAndData(rowMeta, new Object[]{"Pentaho", 3L}), new RowMetaAndData(rowMeta, new Object[]{"Pentaho", 4L}));
        subtransExecutor.execute(rows);
        ((Set)Mockito.verify((Object)subtransExecutor.running)).add(Matchers.any());
        subtransExecutor.stop();
        Assert.assertTrue((boolean)subtransExecutor.running.isEmpty());
    }

    @Test
    public void doesNotExecuteWhenStopped() throws KettleException {
        TransMeta parentMeta = new TransMeta(this.getClass().getResource("subtrans-executor-parent.ktr").getPath(), (VariableSpace)new Variables());
        TransMeta subMeta = new TransMeta(this.getClass().getResource("subtrans-executor-sub.ktr").getPath(), (VariableSpace)new Variables());
        LoggingObject loggingObject = new LoggingObject((Object)"anything");
        Trans parentTrans = new Trans(parentMeta, (LoggingObjectInterface)loggingObject);
        SubtransExecutor subtransExecutor = new SubtransExecutor("subtransname", parentTrans, subMeta, true, new TransExecutorParameters(), "");
        RowMetaInterface rowMeta = parentMeta.getStepFields("Data Grid");
        List<RowMetaAndData> rows = Arrays.asList(new RowMetaAndData(rowMeta, new Object[]{"Pentaho", 1L}), new RowMetaAndData(rowMeta, new Object[]{"Pentaho", 2L}), new RowMetaAndData(rowMeta, new Object[]{"Pentaho", 3L}), new RowMetaAndData(rowMeta, new Object[]{"Pentaho", 4L}));
        subtransExecutor.stop();
        subtransExecutor.execute(rows);
        ((LogChannel)Mockito.verify((Object)this.logChannel, (VerificationMode)Mockito.never())).logBasic("\n------------> Linenr 1------------------------------\nname = Pentaho\nsum = 10\n\n====================");
    }
}

