/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class StepWithMappingMetaTest {
    @Mock
    TransMeta transMeta;

    @Before
    public void setupBefore() throws Exception {
        KettleEnvironment.init();
    }

    @Test
    public void loadMappingMeta() throws Exception {
        String variablePath = "Internal.Entry.Current.Directory";
        final String virtualDir = "/testFolder/CDA-91";
        final String fileName = "testTrans.ktr";
        Variables variables = new Variables();
        StepMeta stepMeta = new StepMeta();
        TransMeta parentTransMeta = new TransMeta();
        stepMeta.setParentTransMeta(parentTransMeta);
        RepositoryDirectoryInterface repositoryDirectory = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)repositoryDirectory.toString()).thenReturn((Object)virtualDir);
        stepMeta.getParentTransMeta().setRepositoryDirectory(repositoryDirectory);
        StepWithMappingMeta mappingMetaMock = (StepWithMappingMeta)Mockito.mock(StepWithMappingMeta.class);
        Mockito.when((Object)mappingMetaMock.getSpecificationMethod()).thenReturn((Object)ObjectLocationSpecificationMethod.FILENAME);
        Mockito.when((Object)mappingMetaMock.getFileName()).thenReturn((Object)("${" + variablePath + "}/" + fileName));
        Mockito.when((Object)mappingMetaMock.getParentStepMeta()).thenReturn((Object)stepMeta);
        Repository rep = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doAnswer((Answer)new Answer<TransMeta>(){

            public TransMeta answer(InvocationOnMock invocation) throws Throwable {
                String originalArgument = (String)invocation.getArguments()[0];
                Assert.assertEquals((Object)virtualDir, (Object)originalArgument);
                return null;
            }
        }).when((Object)rep)).findDirectory(Mockito.anyString());
        ((Repository)Mockito.doAnswer((Answer)new Answer<TransMeta>(){

            public TransMeta answer(InvocationOnMock invocation) throws Throwable {
                String originalArgument = (String)invocation.getArguments()[0];
                Assert.assertEquals((Object)fileName, (Object)originalArgument);
                return (TransMeta)Mockito.mock(TransMeta.class);
            }
        }).when((Object)rep)).loadTransformation(Mockito.anyString(), (RepositoryDirectoryInterface)Mockito.any(RepositoryDirectoryInterface.class), (ProgressMonitorListener)Mockito.any(ProgressMonitorListener.class), Mockito.anyBoolean(), Mockito.anyString());
        StepWithMappingMeta.loadMappingMeta((StepWithMappingMeta)mappingMetaMock, (Repository)rep, null, (VariableSpace)variables, (boolean)true);
    }

    @Test
    @PrepareForTest(value={StepWithMappingMeta.class})
    public void testExportResources() throws Exception {
        StepWithMappingMeta stepWithMappingMeta = (StepWithMappingMeta)Mockito.spy((Object)new StepWithMappingMeta(){

            public void setDefault() {
            }

            public StepDataInterface getStepData() {
                return null;
            }

            public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
                return null;
            }
        });
        String testName = "test";
        PowerMockito.mockStatic(StepWithMappingMeta.class, (Class[])new Class[0]);
        Mockito.when((Object)StepWithMappingMeta.loadMappingMeta((StepWithMappingMeta)((StepWithMappingMeta)Mockito.any()), (Repository)((Repository)Mockito.any()), (IMetaStore)((IMetaStore)Mockito.any()), (VariableSpace)((VariableSpace)Mockito.any()))).thenReturn((Object)this.transMeta);
        Mockito.when((Object)this.transMeta.exportResources((VariableSpace)Mockito.any(), Mockito.anyMap(), (ResourceNamingInterface)Mockito.any(), (Repository)Mockito.any(), (IMetaStore)Mockito.any())).thenReturn((Object)testName);
        stepWithMappingMeta.exportResources(null, null, null, null, null);
        ((TransMeta)Mockito.verify((Object)this.transMeta)).setFilename("${Internal.Entry.Current.Directory}/" + testName);
        ((StepWithMappingMeta)Mockito.verify((Object)stepWithMappingMeta)).setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
    }

    @Test
    @PrepareForTest(value={StepWithMappingMeta.class})
    public void loadMappingMetaTest() throws Exception {
        String childParam = "childParam";
        String childValue = "childValue";
        String paramOverwrite = "paramOverwrite";
        String parentParam = "parentParam";
        String parentValue = "parentValue";
        String variablePath = "Internal.Entry.Current.Directory";
        String virtualDir = "/testFolder/CDA-91";
        String fileName = "testTrans.ktr";
        Variables variables = new Variables();
        variables.setVariable(parentParam, parentValue);
        variables.setVariable(paramOverwrite, parentValue);
        StepMeta stepMeta = new StepMeta();
        TransMeta parentTransMeta = new TransMeta();
        stepMeta.setParentTransMeta(parentTransMeta);
        RepositoryDirectoryInterface repositoryDirectory = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)repositoryDirectory.toString()).thenReturn((Object)virtualDir);
        stepMeta.getParentTransMeta().setRepositoryDirectory(repositoryDirectory);
        StepWithMappingMeta mappingMetaMock = (StepWithMappingMeta)Mockito.mock(StepWithMappingMeta.class);
        Mockito.when((Object)mappingMetaMock.getSpecificationMethod()).thenReturn((Object)ObjectLocationSpecificationMethod.FILENAME);
        Mockito.when((Object)mappingMetaMock.getFileName()).thenReturn((Object)("${" + variablePath + "}/" + fileName));
        Mockito.when((Object)mappingMetaMock.getParentStepMeta()).thenReturn((Object)stepMeta);
        Repository rep = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)Mockito.mock(RepositoryDirectoryInterface.class)).when((Object)rep)).findDirectory(Mockito.anyString());
        TransMeta child = new TransMeta();
        child.setVariable(childParam, childValue);
        child.setVariable(paramOverwrite, childValue);
        ((Repository)Mockito.doReturn((Object)child).when((Object)rep)).loadTransformation(Mockito.anyString(), (RepositoryDirectoryInterface)Mockito.any(), (ProgressMonitorListener)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
        TransMeta transMeta = StepWithMappingMeta.loadMappingMeta((StepWithMappingMeta)mappingMetaMock, (Repository)rep, null, (VariableSpace)variables, (boolean)true);
        Assert.assertNotNull((Object)transMeta);
        Assert.assertEquals((Object)parentValue, (Object)transMeta.getVariable(paramOverwrite));
        Assert.assertEquals((Object)childValue, (Object)transMeta.getVariable(childParam));
        Assert.assertEquals((Object)parentValue, (Object)transMeta.getVariable(parentParam));
    }

    @Test
    @PrepareForTest(value={StepWithMappingMeta.class})
    public void loadMappingMetaTest_PathShouldBeTakenFromParentTrans() throws Exception {
        String fileName = "subtrans-executor-sub.ktr";
        Path parentFolder = Paths.get(this.getClass().getResource("subtrans-executor-sub.ktr").toURI()).getParent();
        Variables variables = new Variables();
        variables.setVariable("Internal.Entry.Current.Directory", parentFolder.toString());
        TransMeta parentTransMeta = new TransMeta((VariableSpace)variables);
        StepMeta stepMeta = new StepMeta();
        stepMeta.setParentTransMeta(parentTransMeta);
        StepWithMappingMeta mappingMetaMock = (StepWithMappingMeta)Mockito.mock(StepWithMappingMeta.class);
        Mockito.when((Object)mappingMetaMock.getSpecificationMethod()).thenReturn((Object)ObjectLocationSpecificationMethod.FILENAME);
        Mockito.when((Object)mappingMetaMock.getFileName()).thenReturn((Object)("${Internal.Entry.Current.Directory}/" + fileName));
        Mockito.when((Object)mappingMetaMock.getParentStepMeta()).thenReturn((Object)stepMeta);
        TransMeta transMeta = StepWithMappingMeta.loadMappingMeta((StepWithMappingMeta)mappingMetaMock, null, null, (VariableSpace)variables, (boolean)true);
        StringBuilder expected = new StringBuilder(parentFolder.toUri().toString());
        Assert.assertEquals((Object)expected.deleteCharAt(expected.length() - 1).toString(), (Object)transMeta.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    @PrepareForTest(value={StepWithMappingMeta.class})
    public void activateParamsTest() throws Exception {
        String childParam = "childParam";
        String childValue = "childValue";
        String paramOverwrite = "paramOverwrite";
        String parentValue = "parentValue";
        String stepValue = "stepValue";
        Variables parent = new Variables();
        parent.setVariable(paramOverwrite, parentValue);
        TransMeta childVariableSpace = new TransMeta();
        childVariableSpace.addParameterDefinition(childParam, "", "");
        childVariableSpace.setParameterValue(childParam, childValue);
        String[] parameters = childVariableSpace.listParameters();
        StepWithMappingMeta.activateParams((VariableSpace)childVariableSpace, (NamedParams)childVariableSpace, (VariableSpace)parent, (String[])parameters, (String[])new String[]{childParam, paramOverwrite}, (String[])new String[]{childValue, stepValue}, (boolean)true);
        Assert.assertEquals((Object)childValue, (Object)childVariableSpace.getVariable(childParam));
        Assert.assertEquals((Object)stepValue, (Object)childVariableSpace.getVariable(paramOverwrite));
    }

    @Test
    @PrepareForTest(value={StepWithMappingMeta.class})
    public void activateParamsWithFalsePassParametersFlagTest() throws Exception {
        String childParam = "childParam";
        String childValue = "childValue";
        String paramOverwrite = "paramOverwrite";
        String parentValue = "parentValue";
        String stepValue = "stepValue";
        String parentAndChildParameter = "parentAndChildParameter";
        Variables parent = new Variables();
        parent.setVariable(paramOverwrite, parentValue);
        parent.setVariable(parentAndChildParameter, parentValue);
        TransMeta childVariableSpace = new TransMeta();
        childVariableSpace.addParameterDefinition(childParam, "", "");
        childVariableSpace.setParameterValue(childParam, childValue);
        childVariableSpace.addParameterDefinition(parentAndChildParameter, "", "");
        childVariableSpace.setParameterValue(parentAndChildParameter, childValue);
        String[] parameters = childVariableSpace.listParameters();
        StepWithMappingMeta.activateParams((VariableSpace)childVariableSpace, (NamedParams)childVariableSpace, (VariableSpace)parent, (String[])parameters, (String[])new String[]{childParam, paramOverwrite}, (String[])new String[]{childValue, stepValue}, (boolean)false);
        Assert.assertEquals((Object)childValue, (Object)childVariableSpace.getVariable(childParam));
        Assert.assertEquals((Object)stepValue, (Object)childVariableSpace.getVariable(paramOverwrite));
        Assert.assertEquals((Object)childValue, (Object)childVariableSpace.getVariable(parentAndChildParameter));
    }

    @Test
    @PrepareForTest(value={StepWithMappingMeta.class})
    public void activateParamsWithTruePassParametersFlagTest() throws Exception {
        String childParam = "childParam";
        String childValue = "childValue";
        String paramOverwrite = "paramOverwrite";
        String parentValue = "parentValue";
        String stepValue = "stepValue";
        String parentAndChildParameter = "parentAndChildParameter";
        Variables parent = new Variables();
        parent.setVariable(paramOverwrite, parentValue);
        parent.setVariable(parentAndChildParameter, parentValue);
        TransMeta childVariableSpace = new TransMeta();
        childVariableSpace.addParameterDefinition(childParam, "", "");
        childVariableSpace.setParameterValue(childParam, childValue);
        childVariableSpace.addParameterDefinition(parentAndChildParameter, "", "");
        childVariableSpace.setParameterValue(parentAndChildParameter, childValue);
        String[] parameters = childVariableSpace.listParameters();
        StepWithMappingMeta.activateParams((VariableSpace)childVariableSpace, (NamedParams)childVariableSpace, (VariableSpace)parent, (String[])parameters, (String[])new String[]{childParam, paramOverwrite}, (String[])new String[]{childValue, stepValue}, (boolean)true);
        Assert.assertEquals((Object)childValue, (Object)childVariableSpace.getVariable(childParam));
        Assert.assertEquals((Object)stepValue, (Object)childVariableSpace.getVariable(paramOverwrite));
        Assert.assertEquals((Object)parentValue, (Object)childVariableSpace.getVariable(parentAndChildParameter));
    }

    @Test
    @PrepareForTest(value={StepWithMappingMeta.class})
    public void activateParamsTestWithNoParameterChild() throws Exception {
        String newParam = "newParamParent";
        String parentValue = "parentValue";
        TransMeta parentMeta = new TransMeta();
        TransMeta childVariableSpace = new TransMeta();
        String[] parameters = childVariableSpace.listParameters();
        StepWithMappingMeta.activateParams((VariableSpace)childVariableSpace, (NamedParams)childVariableSpace, (VariableSpace)parentMeta, (String[])parameters, (String[])new String[]{newParam}, (String[])new String[]{parentValue}, (boolean)true);
        Assert.assertEquals((Object)parentValue, (Object)childVariableSpace.getParameterValue(newParam));
    }

    @Test
    @PrepareForTest(value={StepWithMappingMeta.class})
    public void testFileNameAsVariable() throws Exception {
        String transName = "test.ktr";
        String transDirectory = "/admin";
        String transNameVar = "transName";
        String transDirectoryVar = "transDirectory";
        Variables parent = new Variables();
        parent.setVariable(transNameVar, transName);
        parent.setVariable(transDirectoryVar, transDirectory);
        StepMeta stepMeta = new StepMeta();
        TransMeta parentTransMeta = new TransMeta();
        stepMeta.setParentTransMeta(parentTransMeta);
        StepWithMappingMeta mappingMetaMock = (StepWithMappingMeta)Mockito.mock(StepWithMappingMeta.class);
        Mockito.when((Object)mappingMetaMock.getSpecificationMethod()).thenReturn((Object)ObjectLocationSpecificationMethod.FILENAME);
        Mockito.when((Object)mappingMetaMock.getFileName()).thenReturn((Object)("${" + transDirectoryVar + "}/${" + transNameVar + "}"));
        Mockito.when((Object)mappingMetaMock.getParentStepMeta()).thenReturn((Object)stepMeta);
        Repository rep = (Repository)Mockito.mock(Repository.class);
        RepositoryDirectoryInterface directoryInterface = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        ((Repository)Mockito.doReturn((Object)directoryInterface).when((Object)rep)).findDirectory(Mockito.anyString());
        ((Repository)Mockito.doReturn((Object)new TransMeta()).when((Object)rep)).loadTransformation(Mockito.anyString(), (RepositoryDirectoryInterface)Mockito.any(), (ProgressMonitorListener)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
        TransMeta transMeta = StepWithMappingMeta.loadMappingMeta((StepWithMappingMeta)mappingMetaMock, (Repository)rep, null, (VariableSpace)parent, (boolean)true);
        Assert.assertNotNull((Object)transMeta);
        ((Repository)Mockito.verify((Object)rep, (VerificationMode)Mockito.times((int)1))).findDirectory((String)Mockito.eq((Object)transDirectory));
        ((Repository)Mockito.verify((Object)rep, (VerificationMode)Mockito.times((int)1))).loadTransformation((String)Mockito.eq((Object)transName), (RepositoryDirectoryInterface)Mockito.eq((Object)directoryInterface), (ProgressMonitorListener)Mockito.eq(null), Mockito.eq((boolean)true), (String)Mockito.eq(null));
    }

    @Test
    @PrepareForTest(value={StepWithMappingMeta.class})
    public void replaceVariablesWithJobInternalVariablesTest() {
        String variableOverwrite = "paramOverwrite";
        String variableChildOnly = "childValueVariable";
        String[] jobVariables = Const.INTERNAL_JOB_VARIABLES;
        Variables ChildVariables = new Variables();
        Variables replaceByParentVariables = new Variables();
        for (String internalVariable : jobVariables) {
            ChildVariables.setVariable(internalVariable, "childValue");
            replaceByParentVariables.setVariable(internalVariable, "parentValue");
        }
        ChildVariables.setVariable(variableChildOnly, "childValueVariable");
        ChildVariables.setVariable(variableOverwrite, "childNotInternalValue");
        replaceByParentVariables.setVariable(variableOverwrite, "parentNotInternalValue");
        StepWithMappingMeta.replaceVariableValues((VariableSpace)ChildVariables, (VariableSpace)replaceByParentVariables);
        Assert.assertEquals((Object)"childValue", (Object)ChildVariables.getVariable("Internal.Entry.Current.Directory"));
        Assert.assertEquals((Object)"parentNotInternalValue", (Object)ChildVariables.getVariable(variableOverwrite));
        Assert.assertEquals((Object)variableChildOnly, (Object)ChildVariables.getVariable(variableChildOnly));
    }

    @Test
    @PrepareForTest(value={StepWithMappingMeta.class})
    public void replaceVariablesWithTransInternalVariablesTest() {
        String variableOverwrite = "paramOverwrite";
        String variableChildOnly = "childValueVariable";
        String[] jobVariables = Const.INTERNAL_TRANS_VARIABLES;
        Variables ChildVariables = new Variables();
        Variables replaceByParentVariables = new Variables();
        for (String internalVariable : jobVariables) {
            ChildVariables.setVariable(internalVariable, "childValue");
            replaceByParentVariables.setVariable(internalVariable, "parentValue");
        }
        ChildVariables.setVariable(variableChildOnly, "childValueVariable");
        ChildVariables.setVariable(variableOverwrite, "childNotInternalValue");
        replaceByParentVariables.setVariable(variableOverwrite, "parentNotInternalValue");
        StepWithMappingMeta.replaceVariableValues((VariableSpace)ChildVariables, (VariableSpace)replaceByParentVariables);
        Assert.assertEquals((Object)"childValue", (Object)ChildVariables.getVariable("Internal.Entry.Current.Directory"));
        Assert.assertEquals((Object)"parentNotInternalValue", (Object)ChildVariables.getVariable(variableOverwrite));
        Assert.assertEquals((Object)variableChildOnly, (Object)ChildVariables.getVariable(variableChildOnly));
    }
}

