/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.step.StepInterface;

public class RowProducerTest {
    RowProducer rowProducer;
    StepInterface stepInterface;
    RowSet rowSet;
    RowMetaInterface rowMeta;
    Object[] rowData;

    @Before
    public void setUp() throws Exception {
        this.stepInterface = (StepInterface)Mockito.mock(StepInterface.class);
        this.rowSet = (RowSet)Mockito.mock(RowSet.class);
        this.rowProducer = new RowProducer(this.stepInterface, this.rowSet);
        this.rowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        this.rowData = new Object[0];
    }

    @Test
    public void testPutRow2Arg() throws Exception {
        Mockito.when((Object)this.rowSet.putRowWait((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)))).thenReturn((Object)true);
        this.rowProducer.putRow(this.rowMeta, this.rowData);
        ((RowSet)Mockito.verify((Object)this.rowSet, (VerificationMode)Mockito.times((int)1))).putRowWait(this.rowMeta, this.rowData, Long.MAX_VALUE, TimeUnit.DAYS);
        Assert.assertTrue((boolean)this.rowProducer.putRow(this.rowMeta, this.rowData, true));
    }

    @Test
    public void testPutRow3Arg() throws Exception {
        Mockito.when((Object)this.rowSet.putRowWait((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)))).thenReturn((Object)true);
        this.rowProducer.putRow(this.rowMeta, this.rowData, false);
        ((RowSet)Mockito.verify((Object)this.rowSet, (VerificationMode)Mockito.times((int)1))).putRow(this.rowMeta, this.rowData);
    }

    @Test
    public void testPutRowWait() throws Exception {
        this.rowProducer.putRowWait(this.rowMeta, this.rowData, 1L, TimeUnit.MILLISECONDS);
        ((RowSet)Mockito.verify((Object)this.rowSet, (VerificationMode)Mockito.times((int)1))).putRowWait(this.rowMeta, this.rowData, 1L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testFinished() throws Exception {
        this.rowProducer.finished();
        ((RowSet)Mockito.verify((Object)this.rowSet, (VerificationMode)Mockito.times((int)1))).setDone();
    }

    @Test
    public void testGetSetRowSet() throws Exception {
        Assert.assertEquals((Object)this.rowSet, (Object)this.rowProducer.getRowSet());
        this.rowProducer.setRowSet(null);
        Assert.assertNull((Object)this.rowProducer.getRowSet());
        RowSet newRowSet = (RowSet)Mockito.mock(RowSet.class);
        this.rowProducer.setRowSet(newRowSet);
        Assert.assertEquals((Object)newRowSet, (Object)this.rowProducer.getRowSet());
    }

    @Test
    public void testGetSetStepInterface() throws Exception {
        Assert.assertEquals((Object)this.stepInterface, (Object)this.rowProducer.getStepInterface());
        this.rowProducer.setStepInterface(null);
        Assert.assertNull((Object)this.rowProducer.getStepInterface());
        StepInterface newStepInterface = (StepInterface)Mockito.mock(StepInterface.class);
        this.rowProducer.setStepInterface(newStepInterface);
        Assert.assertEquals((Object)newStepInterface, (Object)this.rowProducer.getStepInterface());
    }
}

