/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.pentaho.di.base.LoadSaveBase;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Partitioner;
import org.pentaho.di.trans.steps.loadsave.MemoryRepository;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.w3c.dom.Node;

public class LoadSaveTester<T extends Partitioner>
extends LoadSaveBase<T> {
    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes, List<String> xmlAttributes, List<String> repoAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap) {
        super(clazz, commonAttributes, xmlAttributes, repoAttributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap);
    }

    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes) {
        super(clazz, commonAttributes);
    }

    public void testSerialization() throws KettleException {
        this.testXmlRoundTrip();
        this.testRepoRoundTrip();
        this.testClone();
    }

    public void testXmlRoundTrip() throws KettleException {
        Partitioner metaToSave = (Partitioner)this.createMeta();
        Map<String, FieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters(this.xmlAttributes, metaToSave);
        Partitioner metaLoaded = (Partitioner)this.createMeta();
        String xml = "<step>" + metaToSave.getXML() + "</step>";
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        metaLoaded.loadXML(XMLHandler.getSubNode((Node)XMLHandler.loadXMLFile((InputStream)is, null, (boolean)false, (boolean)false), (String)"step"));
        this.validateLoadedMeta(this.xmlAttributes, validatorMap, metaToSave, metaLoaded);
    }

    public void testRepoRoundTrip() throws KettleException {
        Partitioner metaToSave = (Partitioner)this.createMeta();
        Map<String, FieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters(this.repoAttributes, metaToSave);
        Partitioner metaLoaded = (Partitioner)this.createMeta();
        MemoryRepository rep = new MemoryRepository();
        metaToSave.saveRep((Repository)rep, null, null);
        metaLoaded.loadRep((Repository)rep, null);
        this.validateLoadedMeta(this.repoAttributes, validatorMap, metaToSave, metaLoaded);
    }

    protected void testClone() {
        Partitioner metaToSave = (Partitioner)this.createMeta();
        Map<String, FieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters(this.xmlAttributes, metaToSave);
        Partitioner metaLoaded = metaToSave.clone();
        this.validateLoadedMeta(this.xmlAttributes, validatorMap, metaToSave, metaLoaded);
    }
}

