/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.shared;

import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.shared.SharedObjectBase;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;

public class SharedObjectsTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    @Mock
    SharedObjects sharedObjectsMock;

    @Before
    public void init() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void writeToFileTest() throws KettleException, IOException {
        ((SharedObjects)Mockito.doCallRealMethod().when((Object)this.sharedObjectsMock)).writeToFile((FileObject)Matchers.any(FileObject.class), Matchers.anyString());
        Mockito.when((Object)this.sharedObjectsMock.initOutputStreamUsingKettleVFS((FileObject)Matchers.any(FileObject.class))).thenThrow(new Throwable[]{new RuntimeException()});
        try {
            this.sharedObjectsMock.writeToFile((FileObject)Matchers.any(FileObject.class), Matchers.anyString());
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        ((SharedObjects)Mockito.verify((Object)this.sharedObjectsMock)).restoreFileFromBackup(Matchers.anyString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyBackupVfs() throws Exception {
        String dirName = "ram:/SharedObjectsTest";
        FileObject baseDir = KettleVFS.getFileObject((String)"ram:/SharedObjectsTest");
        try {
            baseDir.createFolder();
            String fileName = "ram:/SharedObjectsTest/shared.xml";
            SharedObjects sharedObjects = new SharedObjects("ram:/SharedObjectsTest/shared.xml");
            TestSharedObject shared1 = new TestSharedObject("shared1", "<shared1>shared1</shared1>");
            sharedObjects.storeObject((SharedObjectInterface)shared1);
            sharedObjects.saveToFile();
            String backupFileName = "ram:/SharedObjectsTest/shared.xml.backup";
            FileObject backup = KettleVFS.getFileObject((String)"ram:/SharedObjectsTest/shared.xml.backup");
            Assert.assertFalse((boolean)backup.exists());
            String contents = KettleVFS.getTextFileContent((String)"ram:/SharedObjectsTest/shared.xml", (String)"utf8");
            Assert.assertTrue((boolean)contents.contains(shared1.getXML()));
            TestSharedObject shared2 = new TestSharedObject("shared2", "<shared2>shared2</shared2>");
            sharedObjects.storeObject((SharedObjectInterface)shared2);
            sharedObjects.saveToFile();
            Assert.assertTrue((boolean)backup.exists());
            String contentsBackup = KettleVFS.getTextFileContent((String)"ram:/SharedObjectsTest/shared.xml.backup", (String)"utf8");
            Assert.assertEquals((Object)contents, (Object)contentsBackup);
        }
        finally {
            if (baseDir.exists()) {
                baseDir.deleteAll();
            }
        }
    }

    private static class TestSharedObject
    extends SharedObjectBase
    implements SharedObjectInterface {
        private String name;
        private String xml;

        public TestSharedObject(String name, String xml) {
            this.name = name;
            this.xml = xml;
        }

        public String getName() {
            return this.name;
        }

        public String getXML() throws KettleException {
            return this.xml;
        }
    }
}

