/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryConnectionDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryStepDelegate;

public class KettleDatabaseRepositoryStepDelegateUnitTest {
    @Test
    public void getStepTypeIDs_WhenNeedToUseNotAllValues() throws Exception {
        boolean amount = true;
        final String[] values = new String[]{"1", "2", "3"};
        KettleDatabaseRepository rep = new KettleDatabaseRepository();
        rep.connectionDelegate = (KettleDatabaseRepositoryConnectionDelegate)Mockito.mock(KettleDatabaseRepositoryConnectionDelegate.class);
        Mockito.when((Object)rep.connectionDelegate.getDatabaseMeta()).thenReturn(Mockito.mock(DatabaseMeta.class));
        KettleDatabaseRepositoryStepDelegate delegate = new KettleDatabaseRepositoryStepDelegate(rep);
        delegate.getStepTypeIDs(values, 1);
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.verify((Object)rep.connectionDelegate)).getIDsWithValues(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String[])Matchers.argThat((Matcher)new BaseMatcher<String[]>(){

            public boolean matches(Object item) {
                return ((String[])item).length == 1 && ((String[])item)[0].equals(values[0]);
            }

            public void describeTo(Description description) {
            }
        }));
    }

    @Test
    public void testGetStepTypeCodeToIdMap() throws KettleException {
        KettleDatabaseRepositoryConnectionDelegate connectionDelegate;
        KettleDatabaseRepository repository = (KettleDatabaseRepository)Mockito.mock(KettleDatabaseRepository.class);
        repository.connectionDelegate = connectionDelegate = (KettleDatabaseRepositoryConnectionDelegate)Mockito.mock(KettleDatabaseRepositoryConnectionDelegate.class);
        DatabaseMeta databaseMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        Mockito.when((Object)connectionDelegate.getDatabaseMeta()).thenReturn((Object)databaseMeta);
        Mockito.when((Object)databaseMeta.quoteField(Matchers.anyString())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocationOnMock) throws Throwable {
                return "QUOTE_" + String.valueOf(invocationOnMock.getArguments()[0] + "_QUOTE");
            }
        });
        Mockito.when((Object)databaseMeta.getQuotedSchemaTableCombination(Matchers.anyString(), Matchers.anyString())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocationOnMock) throws Throwable {
                return "QUOTE_" + String.valueOf(invocationOnMock.getArguments()[0]) + "____" + String.valueOf(invocationOnMock.getArguments()[1] + "_QUOTE");
            }
        });
        Mockito.when((Object)connectionDelegate.getDatabaseMeta()).thenReturn((Object)databaseMeta);
        KettleDatabaseRepositoryStepDelegate kettleDatabaseRepositoryStepDelegate = new KettleDatabaseRepositoryStepDelegate(repository);
        Map map = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)connectionDelegate.getValueToIdMap(kettleDatabaseRepositoryStepDelegate.quoteTable("R_STEP_TYPE"), kettleDatabaseRepositoryStepDelegate.quote("ID_STEP_TYPE"), kettleDatabaseRepositoryStepDelegate.quote("CODE"))).thenReturn((Object)map);
        Assert.assertEquals((Object)map, (Object)kettleDatabaseRepositoryStepDelegate.getStepTypeCodeToIdMap());
    }
}

