/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import java.util.ArrayList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryConnectionDelegate;

public class KettleDatabaseRepositoryConnectionDelegateUnitTest {
    private DatabaseMeta databaseMeta;
    private KettleDatabaseRepository repository;
    private Database database;
    private KettleDatabaseRepositoryConnectionDelegate kettleDatabaseRepositoryConnectionDelegate;

    @Before
    public void setup() {
        this.repository = (KettleDatabaseRepository)Mockito.mock(KettleDatabaseRepository.class);
        this.databaseMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        this.database = (Database)Mockito.mock(Database.class);
        this.kettleDatabaseRepositoryConnectionDelegate = new KettleDatabaseRepositoryConnectionDelegate(this.repository, this.databaseMeta);
        this.kettleDatabaseRepositoryConnectionDelegate.database = this.database;
    }

    @Test
    public void createIdsWithsValueQuery() {
        String table = "table";
        String id = "id";
        String lookup = "lookup";
        String expectedTemplate = String.format("select %s from %s where %s in ", "id", "table", "lookup") + "(%s)";
        Assert.assertTrue((boolean)String.format(expectedTemplate, "?").equalsIgnoreCase(KettleDatabaseRepositoryConnectionDelegate.createIdsWithValuesQuery((String)"table", (String)"id", (String)"lookup", (int)1)));
        Assert.assertTrue((boolean)String.format(expectedTemplate, "?,?").equalsIgnoreCase(KettleDatabaseRepositoryConnectionDelegate.createIdsWithValuesQuery((String)"table", (String)"id", (String)"lookup", (int)2)));
    }

    @Test
    public void testGetValueToIdMap() throws KettleException {
        String tablename = "test-tablename";
        String idfield = "test-idfield";
        String lookupfield = "test-lookupfield";
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        int id = 1234;
        LongObjectId longObjectId = new LongObjectId((long)id);
        rows.add(new Object[]{lookupfield, id});
        Mockito.when((Object)this.database.getRows((String)Matchers.eq((Object)("SELECT " + lookupfield + ", " + idfield + " FROM " + tablename)), (RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.eq((Object)new Object[0]), Matchers.eq((int)1000), Matchers.eq((boolean)false), Matchers.eq((int)-1), (ProgressMonitorListener)Matchers.eq((Object)null))).thenReturn(rows);
        Map valueToIdMap = this.kettleDatabaseRepositoryConnectionDelegate.getValueToIdMap(tablename, idfield, lookupfield);
        Assert.assertEquals((long)1L, (long)valueToIdMap.size());
        Assert.assertEquals((Object)longObjectId, valueToIdMap.get(lookupfield));
    }
}

