/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryDatabaseDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryJobDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryTransDelegate;

public class KettleDatabaseRepository_GetObjectInformation_Test {
    private static final String ABSENT_ID = "non-existing object";
    private static final String EXISTING_ID = "existing object";
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private KettleDatabaseRepository repository;
    private RepositoryDirectoryInterface directoryInterface;

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.directoryInterface = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        this.repository = (KettleDatabaseRepository)Mockito.spy((Object)new KettleDatabaseRepository());
        ((KettleDatabaseRepository)Mockito.doReturn((Object)this.directoryInterface).when((Object)this.repository)).loadRepositoryDirectoryTree();
        ((KettleDatabaseRepository)Mockito.doReturn((Object)this.directoryInterface).when((Object)this.repository)).loadRepositoryDirectoryTree((RepositoryDirectoryInterface)Matchers.any(RepositoryDirectoryInterface.class));
    }

    @Test
    public void getObjectInformation_AbsentJob_IsDeletedFlagSet() throws Exception {
        KettleDatabaseRepositoryJobDelegate jobDelegate = (KettleDatabaseRepositoryJobDelegate)Mockito.spy((Object)new KettleDatabaseRepositoryJobDelegate(this.repository));
        RowMeta meta = KettleDatabaseRepository_GetObjectInformation_Test.createMetaForJob();
        ((KettleDatabaseRepositoryJobDelegate)Mockito.doReturn((Object)new RowMetaAndData((RowMetaInterface)meta, new Object[meta.size()])).when((Object)jobDelegate)).getJob((ObjectId)new StringObjectId(ABSENT_ID));
        this.assertIsDeletedSet_ForAbsentObject(null, jobDelegate, RepositoryObjectType.JOB);
    }

    @Test
    public void getObjectInformation_AbsentTrans_IsDeletedFlagSet() throws Exception {
        KettleDatabaseRepositoryTransDelegate transDelegate = (KettleDatabaseRepositoryTransDelegate)Mockito.spy((Object)new KettleDatabaseRepositoryTransDelegate(this.repository));
        RowMeta meta = KettleDatabaseRepository_GetObjectInformation_Test.createMetaForTrans();
        ((KettleDatabaseRepositoryTransDelegate)Mockito.doReturn((Object)new RowMetaAndData((RowMetaInterface)meta, new Object[meta.size()])).when((Object)transDelegate)).getTransformation((ObjectId)new StringObjectId(ABSENT_ID));
        this.assertIsDeletedSet_ForAbsentObject(transDelegate, null, RepositoryObjectType.TRANSFORMATION);
    }

    private void assertIsDeletedSet_ForAbsentObject(KettleDatabaseRepositoryTransDelegate transDelegate, KettleDatabaseRepositoryJobDelegate jobDelegate, RepositoryObjectType objectType) throws Exception {
        this.repository.transDelegate = transDelegate;
        this.repository.jobDelegate = jobDelegate;
        Mockito.when((Object)this.directoryInterface.findDirectory((ObjectId)Matchers.any(ObjectId.class))).thenReturn(null);
        RepositoryObject object = this.repository.getObjectInformation((ObjectId)new StringObjectId(ABSENT_ID), objectType);
        Assert.assertTrue((boolean)object.isDeleted());
    }

    @Test
    public void getObjectInformation_ExistingJob_IsDeletedFlagNotSet() throws Exception {
        KettleDatabaseRepositoryJobDelegate jobDelegate = (KettleDatabaseRepositoryJobDelegate)Mockito.spy((Object)new KettleDatabaseRepositoryJobDelegate(this.repository));
        RowMeta meta = KettleDatabaseRepository_GetObjectInformation_Test.createMetaForJob();
        Object[] values = new Object[meta.size()];
        values[Arrays.asList(meta.getFieldNames()).indexOf((Object)"NAME")] = EXISTING_ID;
        ((KettleDatabaseRepositoryJobDelegate)Mockito.doReturn((Object)new RowMetaAndData((RowMetaInterface)meta, values)).when((Object)jobDelegate)).getJob((ObjectId)new StringObjectId(EXISTING_ID));
        this.assertIsDeletedNotSet_ForExistingObject(null, jobDelegate, RepositoryObjectType.JOB);
    }

    @Test
    public void getObjectInformation_ExistingTrans_IsDeletedFlagNotSet() throws Exception {
        KettleDatabaseRepositoryTransDelegate transDelegate = (KettleDatabaseRepositoryTransDelegate)Mockito.spy((Object)new KettleDatabaseRepositoryTransDelegate(this.repository));
        RowMeta meta = KettleDatabaseRepository_GetObjectInformation_Test.createMetaForJob();
        Object[] values = new Object[meta.size()];
        values[Arrays.asList(meta.getFieldNames()).indexOf((Object)"NAME")] = EXISTING_ID;
        ((KettleDatabaseRepositoryTransDelegate)Mockito.doReturn((Object)new RowMetaAndData((RowMetaInterface)meta, values)).when((Object)transDelegate)).getTransformation((ObjectId)new StringObjectId(EXISTING_ID));
        this.assertIsDeletedNotSet_ForExistingObject(transDelegate, null, RepositoryObjectType.TRANSFORMATION);
    }

    @Test
    public void getObjectInformation_GetDatabaseInformation() throws Exception {
        KettleDatabaseRepositoryDatabaseDelegate databaseDelegate;
        this.repository.databaseDelegate = databaseDelegate = (KettleDatabaseRepositoryDatabaseDelegate)Mockito.spy((Object)new KettleDatabaseRepositoryDatabaseDelegate(this.repository));
        RowMeta meta = KettleDatabaseRepository_GetObjectInformation_Test.createMetaForDatabase();
        Object[] values = new Object[meta.size()];
        values[Arrays.asList(meta.getFieldNames()).indexOf((Object)"NAME")] = EXISTING_ID;
        ((KettleDatabaseRepositoryDatabaseDelegate)Mockito.doReturn((Object)new RowMetaAndData((RowMetaInterface)meta, values)).when((Object)databaseDelegate)).getDatabase((ObjectId)new StringObjectId(EXISTING_ID));
        RepositoryObject actual = this.repository.getObjectInformation((ObjectId)new StringObjectId(EXISTING_ID), RepositoryObjectType.DATABASE);
        Assert.assertEquals((Object)new StringObjectId(EXISTING_ID), (Object)actual.getObjectId());
        Assert.assertEquals((Object)EXISTING_ID, (Object)actual.getName());
        Assert.assertEquals((Object)RepositoryObjectType.DATABASE, (Object)actual.getObjectType());
    }

    private void assertIsDeletedNotSet_ForExistingObject(KettleDatabaseRepositoryTransDelegate transDelegate, KettleDatabaseRepositoryJobDelegate jobDelegate, RepositoryObjectType objectType) throws Exception {
        this.repository.transDelegate = transDelegate;
        this.repository.jobDelegate = jobDelegate;
        Mockito.when((Object)this.directoryInterface.findDirectory((ObjectId)Matchers.any(ObjectId.class))).thenReturn(null);
        RepositoryObject object = this.repository.getObjectInformation((ObjectId)new StringObjectId(EXISTING_ID), objectType);
        Assert.assertFalse((boolean)object.isDeleted());
    }

    private static RowMeta createMetaForJob() throws Exception {
        LinkedHashMap<String, Integer> fields = new LinkedHashMap<String, Integer>();
        fields.put("NAME", 2);
        fields.put("DESCRIPTION", 2);
        fields.put("MODIFIED_USER", 2);
        fields.put("MODIFIED_DATE", 3);
        fields.put("ID_DIRECTORY", 5);
        return KettleDatabaseRepository_GetObjectInformation_Test.createMeta(fields);
    }

    private static RowMeta createMetaForTrans() throws Exception {
        LinkedHashMap<String, Integer> fields = new LinkedHashMap<String, Integer>();
        fields.put("NAME", 2);
        fields.put("DESCRIPTION", 2);
        fields.put("MODIFIED_USER", 2);
        fields.put("MODIFIED_DATE", 3);
        fields.put("ID_DIRECTORY", 5);
        return KettleDatabaseRepository_GetObjectInformation_Test.createMeta(fields);
    }

    private static RowMeta createMetaForDatabase() throws Exception {
        LinkedHashMap<String, Integer> fields = new LinkedHashMap<String, Integer>();
        fields.put("NAME", 2);
        return KettleDatabaseRepository_GetObjectInformation_Test.createMeta(fields);
    }

    private static RowMeta createMeta(LinkedHashMap<String, Integer> fields) throws Exception {
        RowMeta meta = new RowMeta();
        for (Map.Entry<String, Integer> entry : fields.entrySet()) {
            meta.addValueMeta(ValueMetaFactory.createValueMeta((String)entry.getKey(), (int)entry.getValue()));
        }
        return meta;
    }
}

