/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryDatabaseDelegate;

public class KettleDatabaseRepository_DatabaseNames_Test {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private KettleDatabaseRepository repository;
    private KettleDatabaseRepositoryDatabaseDelegate databaseDelegate;

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.repository = (KettleDatabaseRepository)Mockito.spy((Object)new KettleDatabaseRepository());
        this.repository.databaseDelegate = this.databaseDelegate = (KettleDatabaseRepositoryDatabaseDelegate)Mockito.spy((Object)new KettleDatabaseRepositoryDatabaseDelegate(this.repository));
    }

    @Test
    public void getDatabaseId_ExactMatch() throws Exception {
        String name = UUID.randomUUID().toString();
        StringObjectId expectedId = new StringObjectId("expected");
        ((KettleDatabaseRepositoryDatabaseDelegate)Mockito.doReturn((Object)expectedId).when((Object)this.databaseDelegate)).getDatabaseID(name);
        ObjectId id = this.repository.getDatabaseID(name);
        Assert.assertEquals((Object)expectedId, (Object)id);
    }

    @Test
    public void getDatabaseId_InsensitiveMatch() throws Exception {
        String name = "databaseWithCamelCase";
        String lookupName = "databaseWithCamelCase".toLowerCase();
        Assert.assertNotSame((Object)lookupName, (Object)"databaseWithCamelCase");
        StringObjectId expected = new StringObjectId("expected");
        ((KettleDatabaseRepositoryDatabaseDelegate)Mockito.doReturn((Object)expected).when((Object)this.databaseDelegate)).getDatabaseID("databaseWithCamelCase");
        ((KettleDatabaseRepositoryDatabaseDelegate)Mockito.doReturn(null).when((Object)this.databaseDelegate)).getDatabaseID(lookupName);
        DatabaseMeta db = new DatabaseMeta();
        db.setName("databaseWithCamelCase");
        db.setObjectId((ObjectId)expected);
        List<DatabaseMeta> dbs = Collections.singletonList(db);
        ((KettleDatabaseRepository)Mockito.doReturn(dbs).when((Object)this.repository)).getDatabases();
        ObjectId id = this.repository.getDatabaseID(lookupName);
        Assert.assertEquals((Object)expected, (Object)id);
    }

    @Test
    public void getDatabaseId_ReturnsExactMatch_PriorToCaseInsensitiveMatch() throws Exception {
        String exact = "databaseExactMatch";
        String similar = "databaseExactMatch".toLowerCase();
        Assert.assertNotSame((Object)similar, (Object)"databaseExactMatch");
        StringObjectId exactId = new StringObjectId("exactId");
        ((KettleDatabaseRepositoryDatabaseDelegate)Mockito.doReturn((Object)exactId).when((Object)this.databaseDelegate)).getDatabaseID("databaseExactMatch");
        StringObjectId similarId = new StringObjectId("similarId");
        ((KettleDatabaseRepositoryDatabaseDelegate)Mockito.doReturn((Object)similarId).when((Object)this.databaseDelegate)).getDatabaseID(similar);
        DatabaseMeta db = new DatabaseMeta();
        db.setName("databaseExactMatch");
        DatabaseMeta another = new DatabaseMeta();
        db.setName(similar);
        List<DatabaseMeta> dbs = Arrays.asList(another, db);
        ((KettleDatabaseRepository)Mockito.doReturn(dbs).when((Object)this.repository)).getDatabases();
        ObjectId id = this.repository.getDatabaseID("databaseExactMatch");
        Assert.assertEquals((Object)exactId, (Object)id);
    }
}

