/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.UserInfo;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositoryMeta;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryConnectionDelegate;

public class KettleDatabaseRepositoryTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    KettleDatabaseRepository repo;

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        this.repo = (KettleDatabaseRepository)Mockito.spy((Object)new KettleDatabaseRepository());
        this.repo.setRepositoryMeta(new KettleDatabaseRepositoryMeta("myId", "myName", "myDescription", new DatabaseMeta()));
        this.repo.connectionDelegate = (KettleDatabaseRepositoryConnectionDelegate)Mockito.spy((Object)new KettleDatabaseRepositoryConnectionDelegate(this.repo, new DatabaseMeta()));
    }

    @Test
    public void testInsertLogEntry() throws KettleException {
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doReturn((Object)new LongObjectId(123L)).when((Object)this.repo.connectionDelegate)).getNextLogID();
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doReturn((Object)"2.4").when((Object)this.repo.connectionDelegate)).getVersion();
        ((KettleDatabaseRepository)Mockito.doReturn((Object)new UserInfo("John Doe")).when((Object)this.repo)).getUserInfo();
        ArgumentCaptor argumentTableName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor argumentTableData = ArgumentCaptor.forClass(RowMetaAndData.class);
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doNothing().when((Object)this.repo.connectionDelegate)).insertTableRow((String)argumentTableName.capture(), (RowMetaAndData)argumentTableData.capture());
        Date beforeLogEntryDate = Calendar.getInstance().getTime();
        this.repo.insertLogEntry("testDescription");
        Date afterLogEntryDate = Calendar.getInstance().getTime();
        RowMetaAndData insertRecord = (RowMetaAndData)argumentTableData.getValue();
        Assert.assertEquals((Object)"R_REPOSITORY_LOG", (Object)argumentTableName.getValue());
        Assert.assertEquals((long)5L, (long)insertRecord.size());
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(0).getType());
        Assert.assertEquals((Object)"ID_REPOSITORY_LOG", (Object)insertRecord.getValueMeta(0).getName());
        Assert.assertEquals((Object)123L, (Object)insertRecord.getInteger(0));
        Assert.assertEquals((long)2L, (long)insertRecord.getValueMeta(1).getType());
        Assert.assertEquals((Object)"REP_VERSION", (Object)insertRecord.getValueMeta(1).getName());
        Assert.assertEquals((Object)"2.4", (Object)insertRecord.getString(1, null));
        Assert.assertEquals((long)3L, (long)insertRecord.getValueMeta(2).getType());
        Assert.assertEquals((Object)"LOG_DATE", (Object)insertRecord.getValueMeta(2).getName());
        Assert.assertTrue((beforeLogEntryDate.compareTo(insertRecord.getDate(2, new Date(Long.MIN_VALUE))) <= 0 && afterLogEntryDate.compareTo(insertRecord.getDate(2, new Date(Long.MIN_VALUE))) >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)insertRecord.getValueMeta(3).getType());
        Assert.assertEquals((Object)"LOG_USER", (Object)insertRecord.getValueMeta(3).getName());
        Assert.assertEquals((Object)"John Doe", (Object)insertRecord.getString(3, null));
        Assert.assertEquals((long)2L, (long)insertRecord.getValueMeta(4).getType());
        Assert.assertEquals((Object)"OPERATION_DESC", (Object)insertRecord.getValueMeta(4).getName());
        Assert.assertEquals((Object)"testDescription", (Object)insertRecord.getString(4, null));
    }

    @Test
    public void testInsertTransNote() throws KettleException {
        ArgumentCaptor argumentTableName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor argumentTableData = ArgumentCaptor.forClass(RowMetaAndData.class);
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doNothing().when((Object)this.repo.connectionDelegate)).insertTableRow((String)argumentTableName.capture(), (RowMetaAndData)argumentTableData.capture());
        this.repo.insertTransNote((ObjectId)new LongObjectId(456L), (ObjectId)new LongObjectId(789L));
        RowMetaAndData insertRecord = (RowMetaAndData)argumentTableData.getValue();
        Assert.assertEquals((Object)"R_TRANS_NOTE", (Object)argumentTableName.getValue());
        Assert.assertEquals((long)2L, (long)insertRecord.size());
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(0).getType());
        Assert.assertEquals((Object)"ID_TRANSFORMATION", (Object)insertRecord.getValueMeta(0).getName());
        Assert.assertEquals((Object)456L, (Object)insertRecord.getInteger(0));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(1).getType());
        Assert.assertEquals((Object)"ID_NOTE", (Object)insertRecord.getValueMeta(1).getName());
        Assert.assertEquals((Object)789L, (Object)insertRecord.getInteger(1));
    }

    @Test
    public void testInsertJobNote() throws KettleException {
        ArgumentCaptor argumentTableName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor argumentTableData = ArgumentCaptor.forClass(RowMetaAndData.class);
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doNothing().when((Object)this.repo.connectionDelegate)).insertTableRow((String)argumentTableName.capture(), (RowMetaAndData)argumentTableData.capture());
        this.repo.insertJobNote((ObjectId)new LongObjectId(234L), (ObjectId)new LongObjectId(567L));
        RowMetaAndData insertRecord = (RowMetaAndData)argumentTableData.getValue();
        Assert.assertEquals((Object)"R_JOB_NOTE", (Object)argumentTableName.getValue());
        Assert.assertEquals((long)2L, (long)insertRecord.size());
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(0).getType());
        Assert.assertEquals((Object)"ID_JOB", (Object)insertRecord.getValueMeta(0).getName());
        Assert.assertEquals((Object)234L, (Object)insertRecord.getInteger(0));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(1).getType());
        Assert.assertEquals((Object)"ID_NOTE", (Object)insertRecord.getValueMeta(1).getName());
        Assert.assertEquals((Object)567L, (Object)insertRecord.getInteger(1));
    }

    private RowMetaAndData getNullIntegerRow() {
        RowMeta rm = new RowMeta();
        rm.addValueMeta((ValueMetaInterface)new ValueMetaInteger());
        return new RowMetaAndData((RowMetaInterface)rm, new Object[]{null});
    }

    @Test
    public void testInsertStepDatabase() throws KettleException {
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doReturn((Object)this.getNullIntegerRow()).when((Object)this.repo.connectionDelegate)).getOneRow(Matchers.anyString(), Matchers.anyString(), (ObjectId)Matchers.any(ObjectId.class));
        ArgumentCaptor argumentTableName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor argumentTableData = ArgumentCaptor.forClass(RowMetaAndData.class);
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doNothing().when((Object)this.repo.connectionDelegate)).insertTableRow((String)argumentTableName.capture(), (RowMetaAndData)argumentTableData.capture());
        this.repo.insertStepDatabase((ObjectId)new LongObjectId(654L), (ObjectId)new LongObjectId(765L), (ObjectId)new LongObjectId(876L));
        RowMetaAndData insertRecord = (RowMetaAndData)argumentTableData.getValue();
        Assert.assertEquals((Object)"R_STEP_DATABASE", (Object)argumentTableName.getValue());
        Assert.assertEquals((long)3L, (long)insertRecord.size());
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(0).getType());
        Assert.assertEquals((Object)"ID_TRANSFORMATION", (Object)insertRecord.getValueMeta(0).getName());
        Assert.assertEquals((Object)654L, (Object)insertRecord.getInteger(0));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(1).getType());
        Assert.assertEquals((Object)"ID_STEP", (Object)insertRecord.getValueMeta(1).getName());
        Assert.assertEquals((Object)765L, (Object)insertRecord.getInteger(1));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(2).getType());
        Assert.assertEquals((Object)"ID_DATABASE", (Object)insertRecord.getValueMeta(2).getName());
        Assert.assertEquals((Object)876L, (Object)insertRecord.getInteger(2));
    }

    @Test
    public void testInsertJobEntryDatabase() throws KettleException {
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doReturn((Object)this.getNullIntegerRow()).when((Object)this.repo.connectionDelegate)).getOneRow(Matchers.anyString(), Matchers.anyString(), (ObjectId)Matchers.any(ObjectId.class));
        ArgumentCaptor argumentTableName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor argumentTableData = ArgumentCaptor.forClass(RowMetaAndData.class);
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doNothing().when((Object)this.repo.connectionDelegate)).insertTableRow((String)argumentTableName.capture(), (RowMetaAndData)argumentTableData.capture());
        this.repo.insertJobEntryDatabase((ObjectId)new LongObjectId(234L), (ObjectId)new LongObjectId(345L), (ObjectId)new LongObjectId(456L));
        RowMetaAndData insertRecord = (RowMetaAndData)argumentTableData.getValue();
        Assert.assertEquals((Object)"R_JOBENTRY_DATABASE", (Object)argumentTableName.getValue());
        Assert.assertEquals((long)3L, (long)insertRecord.size());
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(0).getType());
        Assert.assertEquals((Object)"ID_JOB", (Object)insertRecord.getValueMeta(0).getName());
        Assert.assertEquals((Object)234L, (Object)insertRecord.getInteger(0));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(1).getType());
        Assert.assertEquals((Object)"ID_JOBENTRY", (Object)insertRecord.getValueMeta(1).getName());
        Assert.assertEquals((Object)345L, (Object)insertRecord.getInteger(1));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(2).getType());
        Assert.assertEquals((Object)"ID_DATABASE", (Object)insertRecord.getValueMeta(2).getName());
        Assert.assertEquals((Object)456L, (Object)insertRecord.getInteger(2));
    }

    @Test
    public void testInsertTransformationPartitionSchema() throws KettleException {
        ArgumentCaptor argumentTableName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor argumentTableData = ArgumentCaptor.forClass(RowMetaAndData.class);
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doNothing().when((Object)this.repo.connectionDelegate)).insertTableRow((String)argumentTableName.capture(), (RowMetaAndData)argumentTableData.capture());
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doReturn((Object)new LongObjectId(456L)).when((Object)this.repo.connectionDelegate)).getNextTransformationPartitionSchemaID();
        ObjectId result = this.repo.insertTransformationPartitionSchema((ObjectId)new LongObjectId(147L), (ObjectId)new LongObjectId(258L));
        RowMetaAndData insertRecord = (RowMetaAndData)argumentTableData.getValue();
        Assert.assertEquals((Object)"R_TRANS_PARTITION_SCHEMA", (Object)argumentTableName.getValue());
        Assert.assertEquals((long)3L, (long)insertRecord.size());
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(0).getType());
        Assert.assertEquals((Object)"ID_TRANS_PARTITION_SCHEMA", (Object)insertRecord.getValueMeta(0).getName());
        Assert.assertEquals((Object)456L, (Object)insertRecord.getInteger(0));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(1).getType());
        Assert.assertEquals((Object)"ID_TRANSFORMATION", (Object)insertRecord.getValueMeta(1).getName());
        Assert.assertEquals((Object)147L, (Object)insertRecord.getInteger(1));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(2).getType());
        Assert.assertEquals((Object)"ID_PARTITION_SCHEMA", (Object)insertRecord.getValueMeta(2).getName());
        Assert.assertEquals((Object)258L, (Object)insertRecord.getInteger(2));
        Assert.assertEquals((Object)new LongObjectId(456L), (Object)result);
    }

    @Test
    public void testInsertClusterSlave() throws KettleException {
        ArgumentCaptor argumentTableName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor argumentTableData = ArgumentCaptor.forClass(RowMetaAndData.class);
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doNothing().when((Object)this.repo.connectionDelegate)).insertTableRow((String)argumentTableName.capture(), (RowMetaAndData)argumentTableData.capture());
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doReturn((Object)new LongObjectId(357L)).when((Object)this.repo.connectionDelegate)).getNextClusterSlaveID();
        SlaveServer testSlave = new SlaveServer("slave1", "fakelocal", "9081", "fakeuser", "fakepass");
        testSlave.setObjectId((ObjectId)new LongObjectId(864L));
        ClusterSchema testSchema = new ClusterSchema("schema1", Arrays.asList(testSlave));
        testSchema.setObjectId((ObjectId)new LongObjectId(159L));
        ObjectId result = this.repo.insertClusterSlave(testSchema, testSlave);
        RowMetaAndData insertRecord = (RowMetaAndData)argumentTableData.getValue();
        Assert.assertEquals((Object)"R_CLUSTER_SLAVE", (Object)argumentTableName.getValue());
        Assert.assertEquals((long)3L, (long)insertRecord.size());
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(0).getType());
        Assert.assertEquals((Object)"ID_CLUSTER_SLAVE", (Object)insertRecord.getValueMeta(0).getName());
        Assert.assertEquals((Object)357L, (Object)insertRecord.getInteger(0));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(1).getType());
        Assert.assertEquals((Object)"ID_CLUSTER", (Object)insertRecord.getValueMeta(1).getName());
        Assert.assertEquals((Object)159L, (Object)insertRecord.getInteger(1));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(2).getType());
        Assert.assertEquals((Object)"ID_SLAVE", (Object)insertRecord.getValueMeta(2).getName());
        Assert.assertEquals((Object)864L, (Object)insertRecord.getInteger(2));
        Assert.assertEquals((Object)new LongObjectId(357L), (Object)result);
    }

    @Test
    public void testInsertTransformationCluster() throws KettleException {
        ArgumentCaptor argumentTableName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor argumentTableData = ArgumentCaptor.forClass(RowMetaAndData.class);
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doNothing().when((Object)this.repo.connectionDelegate)).insertTableRow((String)argumentTableName.capture(), (RowMetaAndData)argumentTableData.capture());
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doReturn((Object)new LongObjectId(123L)).when((Object)this.repo.connectionDelegate)).getNextTransformationClusterID();
        ObjectId result = this.repo.insertTransformationCluster((ObjectId)new LongObjectId(456L), (ObjectId)new LongObjectId(789L));
        RowMetaAndData insertRecord = (RowMetaAndData)argumentTableData.getValue();
        Assert.assertEquals((Object)"R_TRANS_CLUSTER", (Object)argumentTableName.getValue());
        Assert.assertEquals((long)3L, (long)insertRecord.size());
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(0).getType());
        Assert.assertEquals((Object)"ID_TRANS_CLUSTER", (Object)insertRecord.getValueMeta(0).getName());
        Assert.assertEquals((Object)123L, (Object)insertRecord.getInteger(0));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(1).getType());
        Assert.assertEquals((Object)"ID_TRANSFORMATION", (Object)insertRecord.getValueMeta(1).getName());
        Assert.assertEquals((Object)456L, (Object)insertRecord.getInteger(1));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(2).getType());
        Assert.assertEquals((Object)"ID_CLUSTER", (Object)insertRecord.getValueMeta(2).getName());
        Assert.assertEquals((Object)789L, (Object)insertRecord.getInteger(2));
        Assert.assertEquals((Object)new LongObjectId(123L), (Object)result);
    }

    @Test
    public void testInsertTransformationSlave() throws KettleException {
        ArgumentCaptor argumentTableName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor argumentTableData = ArgumentCaptor.forClass(RowMetaAndData.class);
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doNothing().when((Object)this.repo.connectionDelegate)).insertTableRow((String)argumentTableName.capture(), (RowMetaAndData)argumentTableData.capture());
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doReturn((Object)new LongObjectId(789L)).when((Object)this.repo.connectionDelegate)).getNextTransformationSlaveID();
        ObjectId result = this.repo.insertTransformationSlave((ObjectId)new LongObjectId(456L), (ObjectId)new LongObjectId(123L));
        RowMetaAndData insertRecord = (RowMetaAndData)argumentTableData.getValue();
        Assert.assertEquals((Object)"R_TRANS_SLAVE", (Object)argumentTableName.getValue());
        Assert.assertEquals((long)3L, (long)insertRecord.size());
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(0).getType());
        Assert.assertEquals((Object)"ID_TRANS_SLAVE", (Object)insertRecord.getValueMeta(0).getName());
        Assert.assertEquals((Object)789L, (Object)insertRecord.getInteger(0));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(1).getType());
        Assert.assertEquals((Object)"ID_TRANSFORMATION", (Object)insertRecord.getValueMeta(1).getName());
        Assert.assertEquals((Object)456L, (Object)insertRecord.getInteger(1));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(2).getType());
        Assert.assertEquals((Object)"ID_SLAVE", (Object)insertRecord.getValueMeta(2).getName());
        Assert.assertEquals((Object)123L, (Object)insertRecord.getInteger(2));
        Assert.assertEquals((Object)new LongObjectId(789L), (Object)result);
    }

    @Test
    public void testInsertTransStepCondition() throws KettleException {
        ArgumentCaptor argumentTableName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor argumentTableData = ArgumentCaptor.forClass(RowMetaAndData.class);
        ((KettleDatabaseRepositoryConnectionDelegate)Mockito.doNothing().when((Object)this.repo.connectionDelegate)).insertTableRow((String)argumentTableName.capture(), (RowMetaAndData)argumentTableData.capture());
        this.repo.insertTransStepCondition((ObjectId)new LongObjectId(234L), (ObjectId)new LongObjectId(567L), (ObjectId)new LongObjectId(468L));
        RowMetaAndData insertRecord = (RowMetaAndData)argumentTableData.getValue();
        Assert.assertEquals((Object)"R_TRANS_STEP_CONDITION", (Object)argumentTableName.getValue());
        Assert.assertEquals((long)3L, (long)insertRecord.size());
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(0).getType());
        Assert.assertEquals((Object)"ID_TRANSFORMATION", (Object)insertRecord.getValueMeta(0).getName());
        Assert.assertEquals((Object)234L, (Object)insertRecord.getInteger(0));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(1).getType());
        Assert.assertEquals((Object)"ID_STEP", (Object)insertRecord.getValueMeta(1).getName());
        Assert.assertEquals((Object)567L, (Object)insertRecord.getInteger(1));
        Assert.assertEquals((long)5L, (long)insertRecord.getValueMeta(2).getType());
        Assert.assertEquals((Object)"ID_CONDITION", (Object)insertRecord.getValueMeta(2).getName());
        Assert.assertEquals((Object)468L, (Object)insertRecord.getInteger(2));
    }
}

