/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr;

import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.UserInfo;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositoryMeta;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositorySecurityProvider;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryUserDelegate;

public class KettleDatabaseRepositorySecurityProviderTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private KettleDatabaseRepository repository;
    private KettleDatabaseRepositorySecurityProvider provider;

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        this.repository = new KettleDatabaseRepository();
        this.repository.userDelegate = (KettleDatabaseRepositoryUserDelegate)Mockito.mock(KettleDatabaseRepositoryUserDelegate.class);
        this.provider = new KettleDatabaseRepositorySecurityProvider(this.repository, (RepositoryMeta)new KettleDatabaseRepositoryMeta(), (IUser)new UserInfo());
    }

    @Test(expected=KettleException.class)
    public void saveUserInfo_NormalizesInfo_FailsIfStillBreaches() throws Exception {
        this.provider.saveUserInfo((IUser)new UserInfo("    "));
    }

    @Test(expected=KettleException.class)
    public void saveUserInfo_CheckDuplication_FailsIfFoundSame() throws Exception {
        this.testSaveUserInfo_Passes("login", "login", "login");
    }

    @Test
    public void saveUserInfo_CheckDuplication_PassesIfFoundDifferenceInCase() throws Exception {
        this.testSaveUserInfo_Passes("login", "login", "LOGIN");
    }

    @Test
    public void saveUserInfo_NormalizesInfo_PassesIfNoViolations() throws Exception {
        this.testSaveUserInfo_Passes("login    ", "login");
    }

    @Test
    public void saveUserInfo_CheckDuplication_PassesIfFoundNothing() throws Exception {
        this.testSaveUserInfo_Passes("login", "login");
    }

    private void testSaveUserInfo_Passes(String login, String expectedLogin) throws Exception {
        this.testSaveUserInfo_Passes(login, expectedLogin, "prefix_" + login);
    }

    private void testSaveUserInfo_Passes(String login, String expectedLogin, String existing) throws Exception {
        ((KettleDatabaseRepositoryUserDelegate)Mockito.doReturn((Object)new StringObjectId(existing)).when((Object)this.repository.userDelegate)).getUserID((String)Mockito.eq((Object)existing));
        this.provider.saveUserInfo((IUser)new UserInfo(login));
        ArgumentCaptor captor = ArgumentCaptor.forClass(UserInfo.class);
        ((KettleDatabaseRepositoryUserDelegate)Mockito.verify((Object)this.repository.userDelegate)).saveUserInfo((IUser)captor.capture());
        Assert.assertEquals((String)"UserInfo should be passed", (Object)expectedLogin, (Object)((UserInfo)captor.getValue()).getLogin());
    }
}

