/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr;

import java.util.HashMap;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositoryMeta;

@RunWith(value=MockitoJUnitRunner.class)
public class KettleDatabaseRepositoryMetaTest {
    public static final String JSON_OUTPUT = "{\"isDefault\":true,\"displayName\":\"Name\",\"description\":\"Description\",\"databaseConnection\":\"Database Connection\",\"id\":\"KettleDatabaseRepository\"}";
    @Mock
    RepositoriesMeta repositoriesMeta;
    @Mock
    DatabaseMeta databaseMeta;
    public static final String NAME = "Name";
    public static final String DESCRIPTION = "Description";
    public static final String DATABASE_CONNECTION = "Database Connection";
    KettleDatabaseRepositoryMeta kettleDatabaseRepositoryMeta;

    @Before
    public void setup() {
        this.kettleDatabaseRepositoryMeta = new KettleDatabaseRepositoryMeta();
    }

    @Test
    public void testPopulate() throws Exception {
        this.kettleDatabaseRepositoryMeta.setConnection(this.databaseMeta);
        Mockito.when((Object)this.databaseMeta.getName()).thenReturn((Object)DATABASE_CONNECTION);
        Mockito.when((Object)this.repositoriesMeta.searchDatabase(DATABASE_CONNECTION)).thenReturn((Object)this.databaseMeta);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("displayName", NAME);
        properties.put("description", DESCRIPTION);
        properties.put("databaseConnection", DATABASE_CONNECTION);
        properties.put("isDefault", true);
        this.kettleDatabaseRepositoryMeta.populate(properties, this.repositoriesMeta);
        Assert.assertEquals((Object)NAME, (Object)this.kettleDatabaseRepositoryMeta.getName());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.kettleDatabaseRepositoryMeta.getDescription());
        Assert.assertEquals((Object)DATABASE_CONNECTION, (Object)this.kettleDatabaseRepositoryMeta.getConnection().getName());
        Assert.assertEquals((Object)true, (Object)this.kettleDatabaseRepositoryMeta.isDefault());
    }

    @Test
    public void testToJSONString() {
        Mockito.when((Object)this.databaseMeta.getName()).thenReturn((Object)DATABASE_CONNECTION);
        this.kettleDatabaseRepositoryMeta.setName(NAME);
        this.kettleDatabaseRepositoryMeta.setDescription(DESCRIPTION);
        this.kettleDatabaseRepositoryMeta.setConnection(this.databaseMeta);
        this.kettleDatabaseRepositoryMeta.setDefault(Boolean.valueOf(true));
        JSONObject json = this.kettleDatabaseRepositoryMeta.toJSONObject();
        Assert.assertEquals((Object)JSON_OUTPUT, (Object)json.toString());
    }
}

